/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.GrupoProdutos;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseGrupoProdutos;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecoBaseGrupoProdutosImpl
extends DaoGenericEntityImpl<TabelaPrecoBaseGrupoProdutos, Long> {
    public TabelaPrecoBaseGrupoProdutos getPrecosBaseGrupoProdutos(GrupoProdutos grupoProdutos, TabelaPrecoBase tabelaPrecoBase, Moeda moeda) {
        Criteria c = this.criteria();
        c.createAlias("tabelaPrecoBase", "tb");
        c.add(this.eq("grupoProdutos", grupoProdutos));
        c.add(this.lessEqual("tb.dataInicial", new Date()));
        c.add(this.greatherEqual("tb.dataFinal", new Date()));
        c.add(this.eq("tb", tabelaPrecoBase));
        c.add(this.lessEqual("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("tb.moeda", moeda));
        Disjunction d = Restrictions.disjunction();
        d.add(this.isNull("tb.tabelaUsoInterno"));
        d.add(this.notEqual("tb.tabelaUsoInterno", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add((Criterion)d);
        return (TabelaPrecoBaseGrupoProdutos)c.uniqueResult();
    }

    public TabelaPrecoBaseGrupoProdutos getTabelaPrecoBaseGrupoProdAtivo(TabelaPrecoBase tabBase, GrupoProdutos produto) {
        return (TabelaPrecoBaseGrupoProdutos)this.toUnique(this.restrictions(this.criteria(), this.eq("tabelaPrecoBase", tabBase), this.eq("grupoProdutos", produto), this.eq("ativo", (short)1)));
    }

    public TabelaPrecoBaseGrupoProdutos getTabelaPrecoBaseGrupoProdTabVinc(TabelaPrecoBase tabBase, GrupoProdutos produto) {
        TabelaPrecoBaseGrupoProdutos tab = this.getTabelaPrecoBaseGrupoProdAtivo(tabBase, produto);
        if (tab == null && tabBase.getTabelaPrecoVinculada() != null) {
            tab = this.getTabelaPrecoBaseGrupoProdAtivo(tabBase.getTabelaPrecoVinculada(), produto);
        }
        return tab;
    }
}

