/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.impl.ProdutoPrecos;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.InfAdicionalProduto;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.res.DTOProdutoRes;
import com.touchcomp.touchvomodel.vo.tabelaprecobaseproduto.DTOTabelaPrecoBaseProdutoRes;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecoBaseImpl
extends DaoGenericEntityImpl<TabelaPrecoBase, Long> {
    public HashMap findDataUltimaGeracaoArquivoXML() {
        NativeQuery q = this.sqlQuery("select max(u.data_sincronizacao) as DATA,  u.id_natureza as ID_NATUREZA,  u.id_centro_estoque as ID_CENTRO_ESTOQUE,  u.id_tabela_base as ID_TABELA_BASE  from ultima_sinc_tab_base u  group by u.id_natureza, u.id_centro_estoque, u.id_tabela_base  order by  max(u.data_sincronizacao) desc");
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return (HashMap)q.uniqueResult();
    }

    public void insertDataUltimaGeracaoArquivoXML(String idNatureza, String idCentroEstoque, String idTabelaBase) {
        Object query = "insert into ultima_sinc_tab_base (DATA_SINCRONIZACAO, ID_NATUREZA, ID_CENTRO_ESTOQUE, ID_TABELA_BASE) values (current_timestamp,";
        query = (String)query + "'";
        query = (String)query + idNatureza;
        query = (String)query + "'";
        query = (String)query + ", ";
        query = (String)query + "'";
        query = (String)query + idCentroEstoque;
        query = (String)query + "'";
        query = (String)query + ", ";
        query = (String)query + "'";
        query = (String)query + idTabelaBase;
        query = (String)query + "'";
        query = (String)query + ") ";
        NativeQuery q = this.sqlQuery((String)query);
        q.executeUpdate();
    }

    public List<ProdutoPrecos> getProdutosPrecosTabCodBarras(TabelaPrecoBase tabPrecoBase) {
        List<ProdutoPrecos> tabVinc = this.getProdutosPrecosTabCodBarrasInternal(tabPrecoBase.getTabelaPrecoVinculada());
        List<ProdutoPrecos> tab = this.getProdutosPrecosTabCodBarrasInternal(tabPrecoBase);
        for (ProdutoPrecos re : tabVinc) {
            Optional<ProdutoPrecos> found = tab.stream().filter(i -> ToolMethods.isEquals((Object)re.getIdProduto(), (Object)i.getIdProduto()) && ToolMethods.isEquals((Object)re.getCodigoBarras(), (Object)i.getCodigoBarras())).findFirst();
            if (found.isPresent()) continue;
            tab.add(re);
        }
        return tab;
    }

    public List<ProdutoPrecos> getProdutosPrecosTabCodBarrasInternal(TabelaPrecoBase tabPrecoBase) {
        if (tabPrecoBase == null) {
            return new LinkedList<ProdutoPrecos>();
        }
        Criteria crit = this.criteria();
        crit.createAlias("produtos", "tab");
        crit.createAlias("tab.produto", "prod");
        crit.createAlias("prod.unidadeMedida", "un");
        crit.createAlias("prod.codigoBarras", "cod");
        ProjectionList data = Projections.projectionList();
        data.add((Projection)Projections.property((String)"prod.identificador"));
        data.add((Projection)Projections.property((String)"prod.codigoAuxiliar"));
        data.add((Projection)Projections.property((String)"prod.nome"));
        data.add((Projection)Projections.property((String)"un.sigla"));
        data.add((Projection)Projections.property((String)"cod.codigoBarras"));
        data.add((Projection)Projections.property((String)"tab.valorVenda"));
        data.add((Projection)Projections.property((String)"prod.nomeAuxiliar"));
        crit.setProjection((Projection)data);
        crit.add(this.eq("tab.ativo", (short)1));
        crit.add(this.eq("identificador", tabPrecoBase.getIdentificador()));
        crit.addOrder(org.hibernate.criterion.Order.asc((String)"prod.nome"));
        List res = crit.list();
        LinkedList<ProdutoPrecos> ret = new LinkedList<ProdutoPrecos>();
        res.forEach(d -> {
            ProdutoPrecos p = new ProdutoPrecos();
            p.setIdProduto((Long)d[0]);
            p.setCodigoAuxiliar((String)d[1]);
            p.setNome((String)d[2]);
            p.setUnidadeMedida((String)d[3]);
            p.setCodigoBarras((String)d[4]);
            p.setValorVenda((Double)d[5]);
            p.setNomeAuxiliar((String)d[6]);
            ret.add(p);
        });
        return ret;
    }

    public List<ProdutoPrecos> getProdutosVendaFracionada(TabelaPrecoBase tabPrecoBase) {
        List<ProdutoPrecos> tabVinc = this.getProdutosVendaFracionadaInternal(tabPrecoBase.getTabelaPrecoVinculada());
        List<ProdutoPrecos> tab = this.getProdutosVendaFracionadaInternal(tabPrecoBase);
        for (ProdutoPrecos re : tabVinc) {
            Optional<ProdutoPrecos> found = tab.stream().filter(i -> ToolMethods.isEquals((Object)re.getIdProduto(), (Object)i.getIdProduto())).findFirst();
            if (found.isPresent()) continue;
            tab.add(re);
        }
        return tab;
    }

    public List<ProdutoPrecos> getProdutosVendaFracionadaInternal(TabelaPrecoBase tabPrecoBase) {
        if (tabPrecoBase == null) {
            return new LinkedList<ProdutoPrecos>();
        }
        CriteriaBuilder builder = this.criteriaBuilder(TabelaPrecoBase.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(TabelaPrecoBase.class);
        Join jTabBaseProd = root.join("produtos", javax.persistence.criteria.JoinType.INNER);
        Join jProduto = jTabBaseProd.join("produto", javax.persistence.criteria.JoinType.INNER);
        Join jUnidadeMedida = jProduto.join("unidadeMedida", javax.persistence.criteria.JoinType.INNER);
        Subquery sqSent = crit.subquery(Long.class);
        Root sqSentNU = sqSent.from(InfAdicionalProduto.class);
        sqSent.select(builder.max((Expression)sqSentNU.get("identificador")));
        sqSent.groupBy(new Expression[]{sqSentNU.get("identificador")});
        sqSent.where((Expression)builder.equal((Expression)sqSentNU.get("produto"), (Expression)jTabBaseProd.get("produto")));
        crit.multiselect(new Selection[]{jProduto.get("identificador"), jProduto.get("codigoAuxiliar"), jProduto.get("nome"), jUnidadeMedida.get("sigla"), jTabBaseProd.get("valorVenda"), jProduto.get("periodoValLoteFab"), jProduto.get("nomeAuxiliar"), sqSent.getSelection()});
        exps.add(builder.equal((Expression)jTabBaseProd.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.equal((Expression)jProduto.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.equal((Expression)jProduto.get("qtdeNaoFracionada"), (Object)EnumConstantsMentorSimNao.NAO.getValue()));
        exps.add(builder.equal((Expression)root.get("identificador"), (Object)tabPrecoBase.getIdentificador()));
        crit.where(exps.toArray(new Predicate[0]));
        crit.orderBy(new Order[]{builder.asc((Expression)jProduto.get("nome"))});
        List res = this.getEntityManager().createQuery(crit).getResultList();
        LinkedList<ProdutoPrecos> ret = new LinkedList<ProdutoPrecos>();
        res.forEach(d -> {
            ProdutoPrecos p = new ProdutoPrecos();
            p.setIdProduto((Long)d[0]);
            p.setCodigoAuxiliar((String)d[1]);
            p.setNome((String)d[2]);
            p.setUnidadeMedida((String)d[3]);
            p.setValorVenda((Double)d[4]);
            p.setNrDiasValidade((Number)((Long)d[5]));
            p.setNomeAuxiliar((String)d[6]);
            p.setIdInfAdicionalProduto((Long)d[7]);
            ret.add(p);
        });
        return ret;
    }

    public List<TabelaPrecoBase> getAllTabelasAtivas() {
        return this.toList(this.restrictions(this.greatherEqual("dataFinal", new Date())));
    }

    public List<Produto> getProdByDescCodAux(String text, Empresa emp) {
        text = ((String)text).toLowerCase() + "%";
        Object hql = "select distinct prod from TabelaPrecoBase t inner join t.produtos prods inner join prods.produto prod where ";
        hql = ((String)text).length() < 50 ? (String)hql + " (lower(prod.nome) like(:text) or lower(prod.codigoAuxiliar) like(:text)) " : (String)hql + " lower(prod.nome) like(:text)";
        hql = (String)hql + " and t.empresa = :emp and prods.ativo=:sim";
        hql = (String)hql + " order by prod.nome";
        return this.query((String)hql).setString("text", (String)text).setEntity("emp", (Object)emp).setShort("sim", (short)1).list();
    }

    public Double getValorVendaTabPrincipal(Produto prod, Empresa emp) {
        Query q = this.query("SELECT DISTINCT p.valorVenda FROM TabelaPrecoBase t INNER JOIN t.produtos p WHERE t.empresa = :empresa AND   p.produto = :produto AND   t.tabelaPrincipal = :sim");
        q.setEntity("empresa", (Object)emp);
        q.setEntity("produto", (Object)prod);
        q.setInteger("sim", 1);
        q.setMaxResults(1);
        Double ret = (Double)q.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public Double getValorCustoTabPrincipal(Produto prod, Empresa emp) {
        HashMap res = this.getTabelaPrincipalAndVinculada(emp);
        Long idTabelaPrincipal = (Long)res.get("TABELA_PRINCIAL");
        Long idTabelaVinculada = (Long)res.get("TABELA_VINCULADA");
        Double valor = this.getValorCusto(prod, idTabelaPrincipal);
        if (!ToolMethods.isNull((Object)valor).booleanValue()) {
            return valor;
        }
        if (ToolMethods.isNull((Object)idTabelaVinculada).booleanValue()) {
            return 0.0;
        }
        valor = this.getValorCusto(prod, idTabelaVinculada);
        return ToolMethods.isNull((Object)valor) == false ? valor : 0.0;
    }

    private Double getValorCusto(Produto prod, Long idTabela) {
        Criteria c = this.criteria();
        c.createAlias("produtos", "tp");
        c.add(this.eq("identificador", idTabela));
        c.add(this.eq("tp.produto", prod));
        c.add(this.eq("tp.ativo", (short)1));
        c.setProjection((Projection)Projections.property((String)"tp.valorCusto"));
        c.setMaxResults(1);
        return (Double)c.uniqueResult();
    }

    private HashMap getTabelaPrincipalAndVinculada(Empresa emp) {
        String query = "select\nt.identificador as TABELA_PRINCIAL,\nv.identificador as TABELA_VINCULADA\nfrom TabelaPrecoBase t\n     left join t.tabelaPrecoVinculada v\nwhere t.empresa = :emp\nand t.tabelaPrincipal = :sim\norder by v.identificador desc\n";
        Query q = this.query(query);
        q.setMaxResults(1);
        q.setEntity("emp", (Object)emp);
        q.setInteger("sim", 1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        HashMap res = (HashMap)q.uniqueResult();
        return res;
    }

    public Double getPercComissaoMultiplasComissoesTabelaBase(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Double valorUnitario) {
        Object hql = "select c.percComissao  from TabelaPrecoBaseProdutoComissao c  inner join c.tabelaPrecoBaseProduto t inner join t.tabelaPrecoBase b left join b.ufs u left join u.unidadeFederativa ud  where t.produto=:produto and :data between b.dataInicial and b.dataFinal and b.tabelaPrincipal = :principal and t.ativo = :sim and u.ativo = :sim and b.moeda = :moeda and :valorUnitario between c.valorVendaInicial and c.valorVendaFinal and c.ativo = :sim and (b.tabelaUsoInterno is null or b.tabelaUsoInterno <> :sim)";
        if (uf != null) {
            hql = (String)hql + " and ud=:uf";
        }
        Query q = this.query((String)hql).setMaxResults(1).setEntity("produto", (Object)produto).setDate("data", dataEmissao).setShort("principal", (short)1).setEntity("moeda", (Object)moeda).setShort("sim", (short)1).setDouble("valorUnitario", valorUnitario.doubleValue());
        if (uf != null) {
            q.setEntity("uf", (Object)uf);
        }
        return (Double)q.uniqueResult();
    }

    public TabelaPrecoBase getTabelaPrecoBasePrincipal(Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Empresa empresa) {
        Criteria c = this.criteria();
        c.createAlias("ufs", "u", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("u.unidadeFederativa", "ud", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("tabelaPrecoVinculada", "tpv", JoinType.LEFT_OUTER_JOIN);
        c.add(this.lessEqual("dataInicial", dataEmissao));
        c.add(this.greatherEqual("dataFinal", dataEmissao));
        c.add(this.eq("tabelaPrincipal", EnumConstantsMentorSimNao.SIM.getValueInt()));
        c.add(this.eq("u.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("moeda", moeda));
        c.add(this.eq("empresa", empresa));
        if (uf != null) {
            c.add(this.eq("ud.identificador", uf.getIdentificador()));
        }
        Disjunction d = Restrictions.disjunction();
        d.add(this.isNull("tabelaUsoInterno"));
        d.add(this.notEqual("tabelaUsoInterno", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add((Criterion)d);
        this.orderDesc(c, "identificador");
        c.setMaxResults(1);
        TabelaPrecoBase found = (TabelaPrecoBase)c.uniqueResult();
        return found;
    }

    public DTOTabelaPrecoBaseProdutoRes getValorVendaTabPrincipal(String barcode, Empresa emp) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jProduto = builder.join("produtos");
        Join jProdutoProd = builder.join((From)jProduto, "produto");
        Join jProdutoProdUN = builder.join((From)jProdutoProd, "unidadeMedida");
        Join jProdutoProdCodBarras = builder.join((From)jProdutoProd, "codigoBarras");
        builder.equal("empresa", emp);
        builder.between("dataInicial", "dataFinal", (Comparable)new Date());
        builder.equal((From)jProdutoProdCodBarras, "codigoBarras", barcode);
        builder.equal((From)jProdutoProdCodBarras, "ativo", (short)1);
        builder.equal((From)jProdutoProd, "ativo", (short)1);
        builder.equal((From)jProduto, "ativo", (short)1);
        builder.select((From)jProduto, "identificador", "valorVenda", "valorVendaAnterior");
        builder.select((From)jProdutoProd, "identificador", "nome");
        builder.select((From)jProdutoProdUN, "sigla");
        builder.setMaxResults(1);
        Object[] found = (Object[])builder.getUniqueResult();
        DTOTabelaPrecoBaseProdutoRes ret = new DTOTabelaPrecoBaseProdutoRes();
        if (found != null) {
            ret.setIdentificador((Long)found[0]);
            ret.setValorVenda((Double)found[1]);
            ret.setValorVendaAnt((Double)found[2]);
            ret.setProduto(new DTOProdutoRes());
            ret.getProduto().setIdentificador((Long)found[3]);
            ret.getProduto().setCodigoAuxiliar(barcode);
            ret.getProduto().setNome((String)found[4]);
            ret.getProduto().setUnidadeMedidaSigla((String)found[5]);
        }
        return ret;
    }

    public List<TabelaPrecoBase> getTabelasPrecoAtivas(Produto produto) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jProduto = builder.join("produtos");
        builder.between("dataInicial", "dataFinal", (Comparable)new Date());
        builder.equal((From)jProduto, "produto", produto);
        builder.equal((From)jProduto, "ativo", (short)1);
        return builder.getResultEnt();
    }
}

