/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProdutoComissao;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecoBaseProdutoComissaoImpl
extends DaoGenericEntityImpl<TabelaPrecoBaseProdutoComissao, Long> {
    public Double getPercComissaoMultiplasComissoesTabelaBase(Produto produto, Date dataEmissao, UnidadeFederativa uf, Moeda moeda, Double valorUnitario) {
        Criteria c = this.criteria();
        c.createAlias("tabelaPrecoBaseProduto", "t");
        c.createAlias("t.tabelaPrecoBase", "b");
        c.createAlias("b.ufs", "u", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("u.unidadeFederativa", "ud", JoinType.LEFT_OUTER_JOIN);
        c.add(this.eq("t.produto", "produto"));
        c.add(this.greatherEqual("b.dataInicial", dataEmissao));
        c.add(this.lessEqual("b.dataFinal", dataEmissao));
        c.add(this.eq("b.tabelaPrincipal", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("t.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("u.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("b.moeda", moeda));
        c.add(this.greatherEqual("valorVendaInicial", valorUnitario));
        c.add(this.lessEqual("valorVendaFinal", valorUnitario));
        c.add(this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        Disjunction d = Restrictions.disjunction();
        d.add(this.isNull("b.tabelaUsoInterno"));
        d.add(this.notEqual("b.tabelaUsoInterno", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add((Criterion)d);
        if (uf != null) {
            c.add(this.eq("ud", uf));
        }
        return (Double)c.uniqueResult();
    }
}

