/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecoBaseProdutoImpl
extends DaoGenericEntityImpl<TabelaPrecoBaseProduto, Long> {
    public Map<String, Object> getDadosPrecoProdEngProd(Long idProduto, Date dataConsulta) {
        Query q = this.query(" select tp.valorVenda as VALOR_VENDA,m.identificador as ID_MOEDA from TabelaPrecoBase t inner join t.produtos tp inner join tp.produto p inner join t.moeda m where p.identificador =:idProduto and :dataConsulta between t.dataInicial and t.dataFinal and tp.ativo=:sim and t.tabelaUsoInterno=:sim");
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("dataConsulta", dataConsulta);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setMaxResults(1);
        Map re = (Map)q.uniqueResult();
        return re;
    }

    public TabelaPrecoBaseProduto getTabelaPrecoBaseProd(TabelaPrecoBase tabBase, Produto produto) {
        return (TabelaPrecoBaseProduto)this.toUnique(this.restrictions(this.criteria(), this.eq("tabelaPrecoBase", tabBase), this.eq("produto", produto)));
    }

    public TabelaPrecoBaseProduto getTabelaPrecoBaseProdAtivo(TabelaPrecoBase tabBase, Produto produto) {
        return (TabelaPrecoBaseProduto)this.toUnique(this.restrictions(this.criteria(), this.eq("tabelaPrecoBase", tabBase), this.eq("produto", produto), this.eq("ativo", (short)1)));
    }

    public TabelaPrecoBaseProduto getTabelaPrecoBaseProdTabVinc(TabelaPrecoBase tabBase, Produto produto) {
        TabelaPrecoBaseProduto tab = this.getTabelaPrecoBaseProdAtivo(tabBase, produto);
        if (tab == null && tabBase.getTabelaPrecoVinculada() != null) {
            tab = this.getTabelaPrecoBaseProdAtivo(tabBase.getTabelaPrecoVinculada(), produto);
        }
        return tab;
    }

    public List<Produto> getProdutosCriadosAltVincTab(Date lastSinc, Long idTabPrecos) {
        String query = "select p from TabelaPrecoBaseProduto tp inner join tp.produto p inner join p.gradesProduto pg inner join tp.tabelaPrecoBase t where t.identificador = :idTab and (tp.dataAtualizacao >= :data or p.dataAtualizacao >= :data or pg.dataAtualizacao >= :data)";
        Query q = this.query(query);
        q.setLong("idTab", idTabPrecos.longValue());
        q.setDate("data", lastSinc);
        List data = q.list();
        return data;
    }

    public List<TabelaPrecoBaseProduto> getTabPrecoProdSimPrecosIguais(Produto produto, TabelaPrecoBase tabelaPrecoBase) {
        String query = "select distinct tp from TabelaPrecoBaseProduto tp inner join tp.tabelaPrecoBase t where t = :tabela and exists (     select ps from ProdutosSimilares ps     inner join ps.produtosSimilaresItens p     inner join p.produto pr     where tp.produto= p.produto     and ps.precosMargensIguais=:sim     and  exists(         select ps1 from ProdutosSimilares ps1         inner join ps1.produtosSimilaresItens p1         where ps1=ps and p1.produto=:produto))";
        Query q = this.query(query);
        q.setShort("sim", (short)1);
        q.setEntity("tabela", (Object)tabelaPrecoBase);
        q.setEntity("produto", (Object)produto);
        List data = q.list();
        return data;
    }

    public List<TabelaPrecoBaseProduto> getTabPrecoBaseProdsAtivos(Produto produto) {
        return this.toList(this.restrictions(this.eq("produto", produto), this.eq("ativo", (short)1)));
    }

    public List<TabelaPrecoBaseProduto> getProdutosCriadosAltVincTab(Date lastSinc, TabelaPrecoBase tabBase, int firstRes, Integer maxRegs) {
        String query = "select tp from TabelaPrecoBaseProduto tp inner join tp.tabelaPrecoBase t inner join tp.produto prod inner join prod.infoEcommerce eco where t = :tabela and (prod.dataAtualizacao >= :data or tp.dataCriacao >=:data or eco.dataAtualizacao>=:data) order by prod.identificador";
        Query q = this.query(query);
        q.setEntity("tabela", (Object)tabBase);
        q.setDate("data", lastSinc);
        q.setFirstResult(firstRes);
        q.setMaxResults(maxRegs.intValue());
        List data = q.list();
        return data;
    }

    public List<TabelaPrecoBaseProduto> getItensCriadosAltVincTab(Date lastSinc, TabelaPrecoBase tabBase, int firstRes, Integer maxRegs) {
        String query = "select tp from TabelaPrecoBaseProduto tp inner join tp.tabelaPrecoBase t where t = :tabela and (tp.dataAtualizacao >= :data) order by tp.identificador";
        Query q = this.query(query);
        q.setEntity("tabela", (Object)tabBase);
        q.setDate("data", lastSinc);
        q.setFirstResult(firstRes);
        q.setMaxResults(maxRegs.intValue());
        List data = q.list();
        return data;
    }

    public boolean forcarDataAtualizacaoProdutos(TabelaPrecoBase tabela) {
        String query = "update TabelaPrecoBaseProduto t set t.dataAtualizacao = current_timestamp  where t.tabelaPrecoBase = :tabelaPrecoBase";
        Query q = this.query(query);
        q.setEntity("tabelaPrecoBase", (Object)tabela);
        q.executeUpdate();
        return true;
    }

    public List<TabelaPrecoBaseProduto> getProdutosTabelaPreco(String text, TabelaPrecoBase tabela, Empresa empresa, EnumConstantsMentorSimNao usarIdentificador) {
        Criteria c = this.criteria();
        c.createAlias("tabelaPrecoBase", "tb");
        c.createAlias("tb.empresa", "e");
        c.createAlias("produto", "p");
        c.createAlias("p.unidadeMedida", "u");
        if (usarIdentificador == EnumConstantsMentorSimNao.NAO || text == null) {
            Disjunction d = Restrictions.or((Criterion[])new Criterion[0]);
            d.add(this.like("p.nome", text != null ? text.toUpperCase() : ""));
            d.add(this.like("p.nome", text != null ? text : ""));
            c.add((Criterion)d);
        } else {
            c.add(this.eq("p.identificador", Long.parseLong(text)));
        }
        if (empresa != null) {
            c.add(this.eq("e.identificador", empresa.getIdentificador()));
        }
        if (tabela != null) {
            c.add(this.eq("tb.identificador", tabela.getIdentificador()));
        }
        c.add(this.eq("p.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        this.orderDesc(c, "p.nome");
        return c.list();
    }

    public boolean forcarDtAtualizacaoProdAlterados(TabelaPrecoBase tabela) {
        String sql = "update TabelaPrecoBaseProduto t set t.dataAtualizacao = current_timestamp  where t.tabelaPrecoBase = :tabelaPrecoBase and  t.dataAtualizacao >=current_date";
        Query q = this.query(sql);
        q.setEntity("tabelaPrecoBase", (Object)tabela);
        q.executeUpdate();
        return true;
    }

    public List<Produto> findProdutosByCategoria(String search, Long idCategoria, Pageable pageable) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jProd = builder.joinLeft("produto");
        if (TMethods.isWithData((Number)idCategoria)) {
            Join jCatProd = builder.joinLeft((From)jProd, "categoriasProduto");
            Join jCatProdCat = builder.joinLeft((From)jCatProd, "categoriaProduto");
            builder.equal((From)jCatProdCat, "identificador", idCategoria);
        }
        builder.setDistinct(true);
        builder.equal((From)jProd, "ativo", (short)1);
        builder.equal("ativo", (short)1);
        builder.select("produto");
        LinkedList<Predicate> preds = new LinkedList<Predicate>();
        if (search != null && search.length() < 60) {
            preds.add(builder.getIlike((From)jProd, "codigoAuxiliar", search));
        }
        if (search != null && search.startsWith(" ")) {
            preds.add(builder.getIlike((From)jProd, "nome", search));
        } else if (search != null) {
            preds.add(builder.getStartWith((From)jProd, "nome", search));
        }
        if (!preds.isEmpty()) {
            builder.or(preds);
        }
        builder.setFirstResult(pageable.getPageSize() * pageable.getPageNumber());
        builder.setMaxResults(pageable.getPageSize());
        builder.orderAsc((From)jProd, "nome");
        return builder.getResult();
    }

    public TabelaPrecoBaseProduto getTabBaseUsoInterno(Produto produto, Date data, Moeda moeda, Empresa empresa) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jTab = builder.joinLeft("tabelaPrecoBase");
        builder.equal((From)jTab, "empresa", empresa);
        builder.equal((From)jTab, "moeda", moeda);
        builder.equal((From)jTab, "tabelaUsoInterno", (short)1);
        builder.ge((From)jTab, "dataFinal", data);
        builder.equal("produto", produto);
        return (TabelaPrecoBaseProduto)builder.getUniqueResult();
    }
}

