/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.TabelaPrecoCodigoCodigo;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecoCodigoCodigoImpl
extends DaoGenericEntityImpl<TabelaPrecoCodigoCodigo, Long> {
    public Object[] getPrecosBasePrincipal(String codAux, Date dataEmissao, UnidadeFederativa uf, Moeda moeda) {
        Criteria c = this.criteria();
        ProjectionList fields = Projections.projectionList();
        fields.add((Projection)Projections.property((String)"valorVenda"));
        fields.add((Projection)Projections.property((String)"percentualMinimo"));
        fields.add((Projection)Projections.property((String)"percentualMaximo"));
        fields.add((Projection)Projections.property((String)"percentualComissaoPadrao"));
        fields.add((Projection)Projections.property((String)"valorCusto"));
        fields.add((Projection)Projections.property((String)"b.identificador"));
        c.setProjection((Projection)fields);
        c.createAlias("tabelaPrecoCodigo", "b");
        c.createAlias("b.tabelaPrecoCodigoUf", "u", JoinType.LEFT_OUTER_JOIN);
        c.createAlias("u.unidadeFederativa", "ud", JoinType.LEFT_OUTER_JOIN);
        c.add(this.eq("codigo", codAux));
        c.add(this.greatherEqual("b.dataInicial", dataEmissao));
        c.add(this.lessEqual("b.dataFinal", dataEmissao));
        c.add(this.eq("b.tabelaPrincipal", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("u.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        c.add(this.eq("b.moeda", moeda));
        if (uf != null) {
            c.add(this.eq("ud", uf));
        }
        this.orderDesc(c, "b.identificador");
        Object[] result = (Object[])c.uniqueResult();
        return result;
    }
}

