/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoes;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProd;
import com.touchcomp.basementor.model.vo.TabelaPrecoPromocoesProdQtd;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecoPromocoesImpl
extends DaoGenericEntityImpl<TabelaPrecoPromocoes, Long> {
    public TabelaPrecoPromocoesProd getTabelaPrecosPromo(Produto produto, Date dataEmissao, Empresa empresa) {
        AuxCriteriaBuilder builder = this.queryBuilder(TabelaPrecoPromocoesProd.class);
        Join jTabPromo = builder.join("tabelaPrecoPromocoes");
        Join jTabPromoEmps = builder.join((From)jTabPromo, "empresas");
        builder.equal("produto", produto);
        builder.equal("ativo", (short)1);
        builder.between((From)jTabPromo, "dataInicial", "dataFinal", (Comparable)dataEmissao);
        builder.gt("valorVenda", Double.valueOf(0.0));
        builder.equal((From)jTabPromoEmps, "empresa", empresa);
        builder.equal((From)jTabPromoEmps, "ativo", (short)1);
        builder.orderDesc((From)jTabPromo, "identificador");
        return (TabelaPrecoPromocoesProd)builder.getUniqueResult();
    }

    public TabelaPrecoPromocoesProd getTabelaPrecosPromoTabBase(Produto produto, Date dataEmissao, Empresa empresa, TabelaPrecoBase tabela) {
        AuxCriteriaBuilder builder = this.queryBuilder(TabelaPrecoPromocoesProd.class);
        Join jTabPromo = builder.join("tabelaPrecoPromocoes");
        Join jTabPromoEmps = builder.join((From)jTabPromo, "empresas");
        builder.equal("produto", produto);
        builder.equal("ativo", (short)1);
        builder.between((From)jTabPromo, "dataInicial", "dataFinal", (Comparable)dataEmissao);
        builder.equal((From)jTabPromo, "tabelaPreco", tabela);
        builder.equal((From)jTabPromoEmps, "empresa", empresa);
        builder.equal((From)jTabPromoEmps, "ativo", (short)1);
        builder.orderDesc((From)jTabPromo, "identificador");
        return (TabelaPrecoPromocoesProd)builder.getUniqueResult();
    }

    public TabelaPrecoPromocoesProdQtd getTabelaPrecosPromo(Produto produto, Empresa empresa, Date dataEmissao, Double quantidade) {
        AuxCriteriaBuilder builder = this.queryBuilder(TabelaPrecoPromocoesProdQtd.class);
        Join jTabPromoProd = builder.join("tabelaPrecoPromocoesProd");
        Join jTabPromo = builder.join((From)jTabPromoProd, "tabelaPrecoPromocoes");
        Join jTabPromoEmps = builder.join((From)jTabPromo, "empresas");
        builder.equal((From)jTabPromoProd, "produto", produto);
        builder.equal((From)jTabPromoProd, "ativo", (short)1);
        builder.between((From)jTabPromo, "dataInicial", "dataFinal", (Comparable)dataEmissao);
        builder.gt((From)jTabPromoProd, "valorVenda", Double.valueOf(0.0));
        builder.le("quantidadeInicial", quantidade);
        builder.ge("quantidadeFinal", quantidade);
        builder.equal((From)jTabPromoEmps, "empresa", empresa);
        builder.equal((From)jTabPromoEmps, "ativo", (short)1);
        builder.orderDesc((From)jTabPromo, "identificador");
        return (TabelaPrecoPromocoesProdQtd)builder.getUniqueResult();
    }

    public List<Produto> getTabelaPrecosPromo(Empresa empresa, Date dataEmissao, Pageable pageable) {
        AuxCriteriaBuilder builder = this.queryBuilder(TabelaPrecoPromocoesProd.class);
        Join jTabProduto = builder.join("produto");
        Join jTabPromo = builder.join("tabelaPrecoPromocoes");
        Join jTabPromoEmps = builder.join((From)jTabPromo, "empresas");
        builder.equal("ativo", (short)1);
        builder.between((From)jTabPromo, "dataInicial", "dataFinal", (Comparable)dataEmissao);
        builder.equal((From)jTabPromoEmps, "empresa", empresa);
        builder.equal((From)jTabPromoEmps, "ativo", (short)1);
        builder.orderAsc((From)jTabProduto, "nome");
        builder.select("produto");
        builder.setMaxResults(pageable.getPageSize());
        builder.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        return builder.getResult();
    }
}

