/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.tabelaprecosdinamica.EnumTabelaPrecosDinamicaTipo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TabelaPrecosDinamica;
import com.touchcomp.basementor.model.vo.TabelaPrecosDinamicaCond;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTabelaPrecosDinamicaImpl
extends DaoGenericEntityImpl<TabelaPrecosDinamica, Long> {
    public TabelaPrecosDinamicaCond getTabela(HashMap<EnumTabelaPrecosDinamicaTipo, Object> data, Empresa empresa, String parte) {
        Criteria c = this.getCriteria(data, empresa, parte);
        c.setMaxResults(1);
        return (TabelaPrecosDinamicaCond)c.uniqueResult();
    }

    public List<TabelaPrecosDinamicaCond> getTabelas(HashMap<EnumTabelaPrecosDinamicaTipo, Object> data, Empresa empresa, String parte) {
        Criteria c = this.getCriteria(data, empresa, parte);
        return c.list();
    }

    private Criteria getCriteria(HashMap<EnumTabelaPrecosDinamicaTipo, Object> data, Empresa empresa, String parte) {
        Criteria c = this.getSession().createCriteria(TabelaPrecosDinamicaCond.class);
        c.createAlias("tabelaPrecDinamica", "t");
        c.createAlias("t.empresas", "tabemp");
        String[] aux = ToolString.splitString((String)parte, (char[])new char[0]);
        LinkedList<EnumTabelaPrecosDinamicaTipo> added = new LinkedList<EnumTabelaPrecosDinamicaTipo>();
        block19: for (String string : aux) {
            EnumTabelaPrecosDinamicaTipo temp = EnumTabelaPrecosDinamicaTipo.get((Object)string);
            Object entity = data.get(temp);
            added.add(temp);
            switch (temp) {
                case PESSOA_CLIENTE_1: {
                    c.add((Criterion)Restrictions.eq((String)"pessoa", (Object)entity));
                    continue block19;
                }
                case GRUPO_PESSOAS_CLIENTE_2: {
                    c.add((Criterion)Restrictions.eq((String)"grupoPessoas", (Object)entity));
                    continue block19;
                }
                case PESSOA_REPRESENTANTE_3: {
                    c.add((Criterion)Restrictions.eq((String)"pessoa", (Object)entity));
                    continue block19;
                }
                case GRUPO_PESSOAS_REPRESENTANTE_4: {
                    c.add((Criterion)Restrictions.eq((String)"grupoPessoas", (Object)entity));
                    continue block19;
                }
                case CLASSIFICACAO_CLIENTE_5: {
                    c.add((Criterion)Restrictions.eq((String)"classificacaoClientes", (Object)entity));
                    continue block19;
                }
                case CATEGORIA_CLIENTE_6: {
                    c.add((Criterion)Restrictions.eq((String)"categoriaPessoa", (Object)entity));
                    continue block19;
                }
                case REGIAO_TAB_PRECO_CLIENTE_7: {
                    c.add((Criterion)Restrictions.eq((String)"regiaoTabPrecoDinamica", (Object)entity));
                    continue block19;
                }
                case PRODUTO_8: {
                    c.createAlias("tabelaPrecoBase", "tb");
                    c.createAlias("tb.produtos", "tbp");
                    c.createAlias("tb.tabelaPrecoVinculada", "tv", JoinType.LEFT_OUTER_JOIN);
                    c.createAlias("tv.produtos", "tvp", JoinType.LEFT_OUTER_JOIN);
                    c.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"tbp.produto", (Object)entity), (Criterion)Restrictions.eq((String)"tbp.ativo", (Object)1)), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"tvp.produto", (Object)entity), (Criterion)Restrictions.eq((String)"tvp.ativo", (Object)1))));
                }
            }
        }
        block20: for (String string : EnumTabelaPrecosDinamicaTipo.values()) {
            if (added.contains(string)) continue;
            switch (1.$SwitchMap$com$touchcomp$basementor$constants$enums$tabelaprecosdinamica$EnumTabelaPrecosDinamicaTipo[string.ordinal()]) {
                case 1: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3) || added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1)) continue block20;
                    c.add(Restrictions.isNull((String)"pessoa"));
                    continue block20;
                }
                case 2: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2) || added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4)) continue block20;
                    c.add(Restrictions.isNull((String)"grupoPessoas"));
                    continue block20;
                }
                case 3: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1) || added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3)) continue block20;
                    c.add(Restrictions.isNull((String)"pessoa"));
                    continue block20;
                }
                case 4: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4) || added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2)) continue block20;
                    c.add(Restrictions.isNull((String)"grupoPessoas"));
                    continue block20;
                }
                case 5: {
                    c.add(Restrictions.isNull((String)"classificacaoClientes"));
                    continue block20;
                }
                case 6: {
                    c.add(Restrictions.isNull((String)"categoriaPessoa"));
                    continue block20;
                }
                case 7: {
                    c.add(Restrictions.isNull((String)"regiaoTabPrecoDinamica"));
                }
            }
        }
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"tabemp.empresa", (Object)empresa));
        c.addOrder(Order.desc((String)"identificador"));
        return c;
    }

    public List<TabelaPrecosDinamicaCond> getTabelasValidas(Empresa empresa, String parte) {
        Criteria c = this.getSession().createCriteria(TabelaPrecosDinamicaCond.class);
        c.createAlias("tabelaPrecDinamica", "t");
        c.createAlias("t.empresas", "tabemp");
        String[] aux = ToolString.splitString((String)parte, (char[])new char[0]);
        LinkedList<EnumTabelaPrecosDinamicaTipo> added = new LinkedList<EnumTabelaPrecosDinamicaTipo>();
        block19: for (String string : aux) {
            EnumTabelaPrecosDinamicaTipo temp = EnumTabelaPrecosDinamicaTipo.get((Object)string);
            added.add(temp);
            switch (temp) {
                case PESSOA_CLIENTE_1: {
                    c.add(Restrictions.isNotNull((String)"pessoa"));
                    continue block19;
                }
                case GRUPO_PESSOAS_CLIENTE_2: {
                    c.add(Restrictions.isNotNull((String)"grupoPessoas"));
                    continue block19;
                }
                case PESSOA_REPRESENTANTE_3: {
                    c.add(Restrictions.isNotNull((String)"pessoa"));
                    continue block19;
                }
                case GRUPO_PESSOAS_REPRESENTANTE_4: {
                    c.add(Restrictions.isNotNull((String)"grupoPessoas"));
                    continue block19;
                }
                case CLASSIFICACAO_CLIENTE_5: {
                    c.add(Restrictions.isNotNull((String)"classificacaoClientes"));
                    continue block19;
                }
                case CATEGORIA_CLIENTE_6: {
                    c.add(Restrictions.isNotNull((String)"categoriaPessoa"));
                    continue block19;
                }
                case REGIAO_TAB_PRECO_CLIENTE_7: {
                    c.add(Restrictions.isNotNull((String)"regiaoTabPrecoDinamica"));
                    continue block19;
                }
                case PRODUTO_8: {
                    c.createAlias("tabelaPrecoBase", "tb");
                    c.createAlias("tb.produtos", "tbp");
                    c.createAlias("tb.tabelaPrecoVinculada", "tv", JoinType.LEFT_OUTER_JOIN);
                    c.createAlias("tv.produtos", "tvp", JoinType.LEFT_OUTER_JOIN);
                    c.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"tbp.produto"), (Criterion)Restrictions.eq((String)"tbp.ativo", (Object)1)), (Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"tvp.produto"), (Criterion)Restrictions.eq((String)"tvp.ativo", (Object)1))));
                }
            }
        }
        block20: for (String string : EnumTabelaPrecosDinamicaTipo.values()) {
            if (added.contains(string)) continue;
            switch (1.$SwitchMap$com$touchcomp$basementor$constants$enums$tabelaprecosdinamica$EnumTabelaPrecosDinamicaTipo[string.ordinal()]) {
                case 1: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3) || added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1)) continue block20;
                    c.add(Restrictions.isNull((String)"pessoa"));
                    continue block20;
                }
                case 2: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2) || added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4)) continue block20;
                    c.add(Restrictions.isNull((String)"grupoPessoas"));
                    continue block20;
                }
                case 3: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_CLIENTE_1) || added.contains(EnumTabelaPrecosDinamicaTipo.PESSOA_REPRESENTANTE_3)) continue block20;
                    c.add(Restrictions.isNull((String)"pessoa"));
                    continue block20;
                }
                case 4: {
                    if (added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_REPRESENTANTE_4) || added.contains(EnumTabelaPrecosDinamicaTipo.GRUPO_PESSOAS_CLIENTE_2)) continue block20;
                    c.add(Restrictions.isNull((String)"grupoPessoas"));
                    continue block20;
                }
                case 5: {
                    c.add(Restrictions.isNull((String)"classificacaoClientes"));
                    continue block20;
                }
                case 6: {
                    c.add(Restrictions.isNull((String)"categoriaPessoa"));
                    continue block20;
                }
                case 7: {
                    c.add(Restrictions.isNull((String)"regiaoTabPrecoDinamica"));
                }
            }
        }
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.add((Criterion)Restrictions.eq((String)"tabemp.empresa", (Object)empresa));
        c.addOrder(Order.desc((String)"identificador"));
        return c.list();
    }
}

