/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.TicketFiscal;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTicketFiscalImpl
extends DaoGenericEntityImpl<TicketFiscal, Long> {
    public List<TicketFiscal> pesquisarTicketFiscalDataFechamentoProduto(Empresa empresa, Date dataInicial, Date dataFinal, Short filtrarProduto, Produto produto) {
        Object hql = "FROM TicketFiscal t WHERE t.empresa                      = :empresa AND   CAST(t.dataFechamento AS date) BETWEEN :dataInicial AND :dataFinal AND   t.status                       = :status";
        if (ToolMethods.isEquals((Object)filtrarProduto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            hql = (String)hql + " AND   t.produto                      = :produto";
        }
        hql = (String)hql + " ORDER BY t.numero";
        Query q = this.query((String)hql);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        if (ToolMethods.isEquals((Object)filtrarProduto, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            q.setEntity("produto", (Object)produto);
        }
        q.setShort("status", EnumConstTicketFiscalStatus.FECHADA.value);
        return q.list();
    }

    public TicketFiscal pesquisarTicketFiscalEmpresaSerieNumero(Empresa empresa, String serie, Integer numero) {
        Query q = this.query("FROM TicketFiscal t WHERE t.empresa = :empresa AND   t.serie   = :serie AND   t.numero  = :numero");
        q.setEntity("empresa", (Object)empresa);
        q.setString("serie", serie);
        q.setInteger("numero", numero.intValue());
        return (TicketFiscal)q.uniqueResult();
    }

    public TicketFiscal pesquisarTicketFiscalEmpresaSerieImportadoNumeroImportado(Empresa empresa, String serie, Integer numero) {
        Query q = this.query("FROM TicketFiscal t WHERE t.empresa = :empresa AND   t.serieImportado   = :serie AND   t.numeroImportado  = :numero");
        q.setEntity("empresa", (Object)empresa);
        q.setString("serie", serie);
        q.setInteger("numero", numero.intValue());
        return (TicketFiscal)q.uniqueResult();
    }

    public Double pesquisarTicketFiscalSaldoPorPedidoAndGrade(Pedido pedido, GradeItemPedido gradeItemPedido) {
        Query q = this.query("SELECT SUM(t.quantidade) FROM PedidoTicketFiscal t INNER JOIN t.ticketFiscal f INNER JOIN t.pedido p WHERE p = :pedido AND t.gradeItemPedido = :gradeItemPedido AND f.status = :status");
        q.setEntity("pedido", (Object)pedido);
        q.setEntity("gradeItemPedido", (Object)gradeItemPedido);
        q.setShort("status", EnumConstTicketFiscalStatus.FECHADA.value);
        if (q.uniqueResult() == null) {
            return 0.0;
        }
        return (Double)q.uniqueResult();
    }
}

