/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.ticketfiscalterceiros.EnumConstTicketFiscalTerceirosStatus;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementor.model.vo.TicketFiscalTerceiros;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTicketFiscalTerceirosImpl
extends DaoGenericEntityImpl<TicketFiscalTerceiros, Long> {
    public List<TicketFiscalTerceiros> pesquisarTicketFiscalEntradaDataTicket(Empresa empresa, Date dataInicial, Date dataFinal) {
        Query q = this.query("FROM TicketFiscalTerceiros t WHERE t.empresa                  = :empresa AND   CAST(t.dataTicket AS date) BETWEEN :dataInicial AND :dataFinal AND   t.status                   = :status ORDER BY t.numero");
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("status", EnumConstTicketFiscalTerceirosStatus.FECHADA.value);
        return q.list();
    }

    public TicketFiscalTerceiros pesquisarTicketFiscalEntradaEmpresaCnpjFornecedorNumero(Empresa empresa, String cnpjFornecedor, Long numero) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros   t INNER JOIN t.unidadeFatFornecedor u INNER JOIN u.pessoa               p INNER JOIN p.complemento          c WHERE t.empresa = :empresa AND   c.cnpj    = :cnpjFornecedor AND   t.numero  = :numero");
        q.setEntity("empresa", (Object)empresa);
        q.setString("cnpjFornecedor", cnpjFornecedor);
        q.setLong("numero", numero.longValue());
        return (TicketFiscalTerceiros)q.uniqueResult();
    }

    public TicketFiscalTerceiros pesquisarTicketFiscalEntradaEmpresaChaveNFEntrada(Empresa empresa, String chaveNotaFiscalEntrada) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros   t WHERE t.empresa                = :empresa AND   t.chaveNotaFiscalEntrada = :chaveNotaFiscalEntrada AND   t.notaTerceiros IS NULL");
        q.setEntity("empresa", (Object)empresa);
        q.setString("chaveNotaFiscalEntrada", chaveNotaFiscalEntrada);
        return (TicketFiscalTerceiros)q.uniqueResult();
    }

    public TicketFiscalTerceiros pesquisarTicketFiscalEntradaEmpresaIdTicketEntrada(Empresa empresa, Long idTicketEntrada) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros   t WHERE t.empresa       = :empresa AND   t.identificador = :idTicketEntrada AND   t.notaTerceiros IS NULL");
        q.setEntity("empresa", (Object)empresa);
        q.setLong("idTicketEntrada", idTicketEntrada.longValue());
        return (TicketFiscalTerceiros)q.uniqueResult();
    }

    public List<TicketFiscalTerceiros> pesquisarTicketFiscalEntradaEmpresaUnidadeFatFornecedorGradeCorDataCompraFechadoSemControleCompraTicket(Empresa empresa, UnidadeFatFornecedor unidadeFatFornecedor, GradeCor gradeCor, Date dataCompra) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros   t WHERE t.empresa              = :empresa AND   t.unidadeFatFornecedor = :unidadeFatFornecedor AND   t.gradeCor             = :gradeCor AND   t.dataTicket          >= :dataCompra AND   t.status               = :status AND NOT EXISTS(FROM ControleCompraTicketTic c WHERE c.ticketFiscalTerceiros = t)");
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("unidadeFatFornecedor", (Object)unidadeFatFornecedor);
        q.setEntity("gradeCor", (Object)gradeCor);
        q.setDate("dataCompra", dataCompra);
        q.setShort("status", EnumConstTicketFiscalTerceirosStatus.FECHADA.value);
        return q.list();
    }

    public TicketFiscalTerceiros pesquisarTicketFiscalEntradaEmpresaNumeroDataHora(Empresa empresa, Long numero, Date dataTicket, Date horaTicket) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros   t WHERE t.empresa    = :empresa AND   t.numero     = :numero AND   t.dataTicket = :dataTicket AND   t.horaTicket = :horaTicket");
        q.setEntity("empresa", (Object)empresa);
        q.setLong("numero", numero.longValue());
        q.setDate("dataTicket", dataTicket);
        q.setTime("horaTicket", horaTicket);
        return (TicketFiscalTerceiros)q.uniqueResult();
    }

    public List<TicketFiscalTerceiros> pesquisarTicketsLoteSemAvaliacaoFichaTecnica(Empresa empresa, Date dataInicial, Date dataFinal) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros  t INNER JOIN t.loteFabricacao l LEFT  JOIN l.fichaTecnica   f WHERE t.empresa      = :empresa AND   t.dataTicket   BETWEEN :dataInicial AND :dataFinal AND   f.identificador IS NULL ORDER BY t.numero");
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public TicketFiscalTerceiros pesquisarTicketFiscalTerceirosPorLoteFabricacao(LoteFabricacao loteFabricacao) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros  t WHERE t.loteFabricacao = :loteFabricacao");
        q.setEntity("loteFabricacao", (Object)loteFabricacao);
        q.setMaxResults(1);
        return (TicketFiscalTerceiros)q.uniqueResult();
    }

    public List<TicketFiscalTerceiros> pesquisarTicketFiscalTerceirosPorNotaTerceiros(NotaFiscalTerceiros notaFiscalTerceiros) {
        Query q = this.query("SELECT t FROM TicketFiscalTerceiros  t WHERE t.notaTerceiros = :notaFiscalTerceiros");
        q.setEntity("notaFiscalTerceiros", (Object)notaFiscalTerceiros);
        return q.list();
    }
}

