/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloProvReal;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.FechamentoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.TipoCooperado;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTituloImpl
extends DaoGenericEntityImpl<Titulo, Long> {
    public Double findValorTotalTitulos(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select  sum(t.valor) as valorTotalTitulos  from Titulo t  where  t.pessoa.identificador = :idPessoa  and t.provisao = :rec  and t.pagRec = :realizado");
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        q.setLong("idPessoa", idPessoa.longValue());
        return (Double)q.uniqueResult();
    }

    public Long findNumTitulosProtestados(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select count(*)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and t.provisao = :rec  and t.pagRec = :realizado and sc.tipoCobranca = :protestada ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("protestada", EnumConstSituacaoCobranca.PROTESTADA.getEnumId().shortValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        Long numTitulosProtestados = (Long)q.uniqueResult();
        return numTitulosProtestados;
    }

    public Long findNumTitulosCartorio(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select count(*)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and t.provisao = :rec  and t.pagRec = :realizado and sc.tipoCobranca = :cartorio ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("cartorio", EnumConstSituacaoCobranca.CARTORIO.getEnumId().shortValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        Long numTitulosProtestados = (Long)q.uniqueResult();
        return numTitulosProtestados;
    }

    public Double findMaiorAtrasoTitulo(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select max(gb.dataLiquidacao - bt.titulo.dataVencimento) as maiorAtraso  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gf  inner join gf.baixaTitulo bt  inner join bt.titulo t  inner join t.pessoa p  where p.identificador = :idPessoa  and t.pagRec = :rec  and t.provisao = :realizado ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        Double maiorAtraso = (Double)q.uniqueResult();
        return maiorAtraso;
    }

    public Double findAtrasoMedioTitulos(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select avg((gb.dataLiquidacao - bt.titulo.dataVencimento)*1.0) as maiorAtraso  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gf  inner join gf.baixaTitulo bt  inner join bt.titulo t  inner join t.pessoa p  where p.identificador = :idPessoa  and t.pagRec = :recebimento  and t.provisao = :realizado ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("recebimento", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        Double atrasoMedio = (Double)q.uniqueResult();
        return atrasoMedio;
    }

    public Double findPercentualAtrasoTitulos(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select  count(bt.titulo.identificador) as quantidadeTituloAtrasados  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gf  inner join gf.baixaTitulo bt  inner join bt.titulo t  inner join t.pessoa p  where p.identificador = :idPessoa  and t.pagRec = :rec  and t.provisao = :realizado  and gb.dataLiquidacao > bt.titulo.dataVencimento ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        Long quantidadeTituloAtrasados = (Long)q.uniqueResult();
        org.hibernate.query.Query q2 = this.query(" select  count(bt.titulo.identificador) as quantidadeTituloTotal  from GrupoDeBaixa gb  inner join gb.grupoDeBaixaFormas gf  inner join gf.baixaTitulo bt  inner join bt.titulo t  inner join t.pessoa p  where p.identificador = :idPessoa  and t.pagRec = :rec and t.provisao = :realizado ");
        q2.setLong("idPessoa", idPessoa.longValue());
        q2.setShort("rec", pagRec.value.shortValue());
        q2.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        Long quantidadeTituloTotal = (Long)q2.uniqueResult();
        Double porcentagem = 0.0;
        if (quantidadeTituloTotal != null && quantidadeTituloTotal > 0L) {
            porcentagem = (double)quantidadeTituloAtrasados.longValue() * 100.0 / (double)quantidadeTituloTotal.longValue();
        }
        return porcentagem;
    }

    public Titulo getByCodigoAuxiliar(String codigoAuxiliar) {
        return (Titulo)this.toUnique(this.restrictions(this.criteria(), this.eq("codigoAuxiliar", codigoAuxiliar)));
    }

    public Date findUltimaDataTituloProtesto(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select max(t.dataEmissao)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and t.provisao = :rec  and t.pagRec = :realizado and sc.tipoCobranca = :protestada ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("protestada", EnumConstSituacaoCobranca.PROTESTADA.getEnumId().shortValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        return (Date)q.uniqueResult();
    }

    public Date findUltimaDataTituloSustado(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select max(t.dataEmissao)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and t.provisao = :rec  and t.pagRec = :realizado and sc.tipoCobranca = :sustado ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("sustado", EnumConstSituacaoCobranca.SUSTADO.getEnumId().shortValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        return (Date)q.uniqueResult();
    }

    public Date findUltimaDataTituloCartorio(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select max(t.dataEmissao)  from Titulo as t  inner join t.carteiraCobranca as c  inner join c.situacaoCobranca sc  where t.pessoa.identificador =:idPessoa  and t.provisao = :rec  and t.pagRec = :realizado and sc.tipoCobranca = :cartorio ");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("cartorio", EnumConstSituacaoCobranca.CARTORIO.getEnumId().shortValue());
        q.setShort("rec", pagRec.value.shortValue());
        q.setShort("realizado", EnumConstTituloProvReal.REALIZADO.value.shortValue());
        return (Date)q.uniqueResult();
    }

    public List<Titulo> findTitulosComCotacaoOutraMoedaSemIntegracaoTaxaCambial(Long idGrupoEmpresa, Long idMoeda, Date dataFinal) {
        org.hibernate.query.Query q = this.query("select t\n from Titulo t\n\tinner join t.cotacaoMoeda cm\n\t\tinner join cm.moeda m\n where (m.identificador = :idMoeda)\n and (t.dataEmissao <= :dataFinal)\n and t.valorSaldo > 0 and (t.empresa.empresaDados.grupoEmpresa.identificador = :idGrupoEmpresa)\n and (\n\tt not in\n(\tselect i2.titulo\n\tfrom IntegracaoTaxaCambial it2\n\t\tinner join it2.itemIntegracao i2\n\t\t\tinner join i2.titulo\n))");
        q.setLong("idMoeda", idMoeda.longValue());
        q.setLong("idGrupoEmpresa", idGrupoEmpresa.longValue());
        q.setDate("dataFinal", dataFinal);
        return this.toList((Query)q);
    }

    public Double findSaldoTitulosAntecipado(Long idPessoa, EnumConstTituloPagRec pagRec) {
        String hql = "select distinct t.identificador as ID_TITULO, t.valor as VALOR from Titulo t inner join t.pessoa p where t.antecipado = 1 AND t.provisao = :provisao  AND t.pagRec = :pagRec AND p.identificador = :idPessoa AND t.valor > (select coalesce(sum(b.valor),0) from BaixaTituloAntecipado b where b.titulo = t)";
        org.hibernate.query.Query q = this.query(hql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setShort("pagRec", (short)0);
        q.setShort("provisao", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List titulos = q.list();
        Double valorTitulos = 0.0;
        for (HashMap h : titulos) {
            Long idTitulo = (Long)h.get("ID_TITULO");
            Double valor = (Double)h.get("VALOR");
            hql = " select coalesce(sum(b.valor),0)  from BaixaTituloAntecipado b where b.titulo.identificador = :idTitulo";
            q = this.query(hql);
            q.setLong("idTitulo", idTitulo.longValue());
            Double vrBaixa = (Double)q.uniqueResult();
            valorTitulos = valorTitulos + (valor - vrBaixa);
        }
        return valorTitulos;
    }

    public Double findValorTotalTitulosAntecipados(Long idPessoa, EnumConstTituloPagRec pagRec) {
        org.hibernate.query.Query q = this.query(" select coalesce(sum(t.valor),0)  from Titulo t  where t.pessoa.identificador = :idPessoa  and t.provisao = :realizado  and t.pagRec = :pag  and t.antecipado = :antecipado ");
        q.setShort("pag", pagRec.value.shortValue());
        q.setShort("realizado", (short)1);
        q.setShort("antecipado", (short)1);
        q.setLong("idPessoa", idPessoa.longValue());
        return (Double)q.uniqueResult();
    }

    public List<BaixaTitulo> findBaixasPorTitulo(Titulo titulo) {
        org.hibernate.query.Query q = this.query("select distinct b from BaixaTitulo b  where b.titulo.identificador = :idTitulo");
        q.setLong("idTitulo", titulo.getIdentificador().longValue());
        return q.list();
    }

    public List<Titulo> findTitulosPorDataEmissaoAndVencimentoAndMeioPagAndTipoDocAndPagRec(Date dataEmissaoInicial, Date dataEmissaoFinal, Date dataVencInicial, Date dataVencFinal, Short pagRec, MeioPagamento meioPagamento, TipoDoc tipoDoc) {
        Object hql = " select distinct t  from Titulo t  where t.provisao = :realizado  and t.pagRec = :pagRec  and t.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal and t.dataVencimento between :dataVencInicial and :dataVencFinal and t.valorSaldo > 0";
        if (tipoDoc != null) {
            hql = (String)hql + " and t.tipoDoc = :tipoDoc";
        }
        if (meioPagamento != null) {
            hql = (String)hql + " and t.meioPagamento = :meioPagamento";
        }
        org.hibernate.query.Query q = this.query((String)hql);
        q.setShort("pagRec", pagRec.shortValue());
        q.setShort("realizado", (short)1);
        if (meioPagamento != null) {
            q.setEntity("meioPagamento", (Object)meioPagamento);
        }
        if (tipoDoc != null) {
            q.setEntity("tipoDoc", (Object)tipoDoc);
        }
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setDate("dataVencInicial", dataVencInicial);
        q.setDate("dataVencFinal", dataVencFinal);
        return q.list();
    }

    public List findTitulosNaoLiberados(Short filtrarDataCad, Date dataCadInicial, Date dataCadFinal, Short filtrarDataVenc, Date dataVencInicial, Date dataVencFinal, Short filtrarFornecedor, Long pessoaFornIdentificador, Short filtrarEmpresa, Long empresaIdentificador) {
        String hql = "select distinct t from LiberacaoTitulos l right join l.itemLiberacao item right join item.titulo t  inner join t.pessoa p   where t.provisao = :realizado and t.pagRec = :pagamento and l is null and (:pescData != 1 or t.dataVencimento between :dataInicial and :dataFinal) and (:pescForn != 1 or p.identificador = :idPessoa) and (:pescEmpresa != 1 or t.empresa.identificador = :idEmpresa) and (:pescDataCadastro != 1 or t.dataCadastro between :dataCadastroInicial and :dataCadastroFinal)";
        org.hibernate.query.Query q = this.query(hql);
        q.setLong("idPessoa", pessoaFornIdentificador.longValue());
        q.setLong("idEmpresa", empresaIdentificador.longValue());
        q.setDate("dataInicial", ToolDate.dataPrimHora((Date)dataVencInicial));
        q.setDate("dataFinal", ToolDate.dataUltHora((Date)dataVencFinal));
        q.setDate("dataCadastroInicial", ToolDate.dataPrimHora((Date)dataCadInicial));
        q.setDate("dataCadastroFinal", ToolDate.dataUltHora((Date)dataCadFinal));
        q.setInteger("pescData", (int)filtrarDataVenc.shortValue());
        q.setInteger("pescForn", (int)filtrarFornecedor.shortValue());
        q.setInteger("pescEmpresa", (int)filtrarEmpresa.shortValue());
        q.setInteger("pescDataCadastro", (int)filtrarDataCad.shortValue());
        q.setInteger("realizado", 1);
        q.setInteger("pagamento", 0);
        return q.list();
    }

    public Titulo findTituloNaoLiberado(Long idTitulo) {
        String hql = "select distinct t from LiberacaoTitulos l right join l.itemLiberacao item right join item.titulo t  inner join t.pessoa p   where t.provisao = :realizado and t.pagRec = :pagamento and l is null and t.identificador = :idTitulo and t.valorSaldo > 0";
        org.hibernate.query.Query q = this.query(hql);
        q.setLong("idTitulo", idTitulo.longValue());
        q.setInteger("realizado", 1);
        q.setInteger("pagamento", 0);
        q.setMaxResults(1);
        return (Titulo)q.uniqueResult();
    }

    public Double findSomatorioValorTotalTitulos(Cliente cliente) {
        String hql = "SELECT SUM(t.valorSaldo) FROM Titulo t WHERE EXISTS ( SELECT u.pessoa FROM UnidadeFatCliente u  WHERE u.cliente = :cliente AND u.pessoa = t.pessoa) AND t.pagRec = :recebimento AND t.valorSaldo > 0d AND t.provisao = 1";
        org.hibernate.query.Query q = this.query(hql);
        q.setEntity("cliente", (Object)cliente);
        q.setInteger("recebimento", 1);
        Double valorSaldo = (Double)q.uniqueResult();
        if (ToolMethods.isEquals((Object)valorSaldo, null)) {
            valorSaldo = 0.0;
        }
        return valorSaldo;
    }

    public Double findTotalCompraPorPeriodoAndPessoa(Date dataInicial, Date dataFinal, String cnpj) {
        String hql = "select sum(t.valor) \nfrom Titulo t \nwhere t.pessoa.complemento.cnpj = :cnpj \nand (t.dataEmissao between :dataInicial and :dataFinal )\nand t.pagRec = :recebimento\nand t.provisao = :realizado";
        org.hibernate.query.Query q = this.query(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("recebimento", (short)1);
        q.setShort("realizado", (short)1);
        q.setString("cnpj", cnpj);
        Double valorSaldo = (Double)q.uniqueResult();
        if (ToolMethods.isEquals((Object)valorSaldo, null)) {
            valorSaldo = 0.0;
        }
        return valorSaldo;
    }

    public Double findTotalPagoPorPeriodoAndPessoa(Date dataInicial, Date dataFinal, String cnpj) {
        String hql = "select \nsum(t.valor - t.valorSaldo) \nfrom Titulo t\n     inner join BaixaTitulo b on (b.titulo = t)\n        inner join b.grupoDeBaixaFormas gb\n             inner join gb.grupoBaixaCompensacao gbc\nwhere (t.pessoa.complemento.cnpj = :cnpj) \nand (gbc.dataLiquidacao between :dataInicial and :dataFinal )\nand (t.pagRec = :recebimento)\nand (t.provisao = :realizado)\nand (t.valorSaldo > 0)";
        org.hibernate.query.Query q = this.query(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("recebimento", (short)1);
        q.setShort("realizado", (short)1);
        q.setString("cnpj", cnpj);
        Double valorSaldo = (Double)q.uniqueResult();
        if (ToolMethods.isEquals((Object)valorSaldo, null)) {
            valorSaldo = 0.0;
        }
        return valorSaldo;
    }

    public Double findTotalAVencerPorPeriodoAndPessoa(Date dataInicial, Date dataFinal, String cnpj) {
        String hql = "select sum (t.valor) \nfrom Titulo t \nwhere t.pessoa.complemento.cnpj = :cnpj\nand (t.dataVencimento between :dataInicial and :dataFinal )\nand (t.pagRec = :recebimento) \nand (t.provisao = :realizado)";
        org.hibernate.query.Query q = this.query(hql);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setShort("recebimento", (short)1);
        q.setShort("realizado", (short)1);
        q.setString("cnpj", cnpj);
        Double valorSaldo = (Double)q.uniqueResult();
        if (ToolMethods.isEquals((Object)valorSaldo, null)) {
            valorSaldo = 0.0;
        }
        return valorSaldo;
    }

    public Double findTotalVencidoPorPessoa(Date dataInicial, String cnpj) {
        String hql = "select sum (t.valor) \nfrom Titulo t \nwhere t.pessoa.complemento.cnpj = :cnpj\nand (t.dataVencimento < :dataInicial)\nand (t.pagRec = :recebimento)\nand (t.provisao = :realizado)\nand (t.valorSaldo > 0)";
        org.hibernate.query.Query q = this.query(hql);
        q.setDate("dataInicial", dataInicial);
        q.setShort("recebimento", (short)1);
        q.setShort("realizado", (short)1);
        q.setString("cnpj", cnpj);
        Double valorSaldo = (Double)q.uniqueResult();
        if (ToolMethods.isEquals((Object)valorSaldo, null)) {
            valorSaldo = 0.0;
        }
        return valorSaldo;
    }

    public List<Titulo> findTitulosCooperados(Date dataVencimentoInicial, Date dataVencimentoFinal, TipoCooperado tipoCooperado, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos) {
        CriteriaBuilder qb = this.criteriaBuilder();
        CriteriaQuery criteria = qb.createQuery(this.getEntityClass());
        Root rootTitulo = criteria.from(Titulo.class);
        Root rootClient = criteria.from(Cliente.class);
        Root rootCooperado = criteria.from(Cooperado.class);
        rootTitulo.alias("titulo");
        rootClient.alias("cliente");
        criteria.select((Selection)rootTitulo);
        List preds = TMethods.toList((Object[])new Object[]{qb.equal((Expression)rootTitulo.get("provisao"), (Object)1), qb.between((Expression)rootTitulo.get("dataVencimento"), (Comparable)dataVencimentoInicial, (Comparable)dataVencimentoFinal), qb.equal((Expression)rootTitulo.get("pessoa"), (Expression)rootClient.get("pessoa")), qb.equal((Expression)rootCooperado.get("cliente"), (Expression)rootClient), qb.equal((Expression)rootCooperado.get("tipoCooperado"), (Object)tipoCooperado), qb.greaterThan((Expression)rootTitulo.get("valorSaldo"), (Comparable)Double.valueOf(0.0))});
        if (dataEmissaoInicial != null && dataEmissaoFinal != null) {
            preds.add(qb.between((Expression)rootTitulo.get("dataEmissao"), (Comparable)dataEmissaoInicial, (Comparable)dataEmissaoFinal));
        }
        if (TMethods.isWithData(meiosPagamentos)) {
            preds.add(qb.in((Expression)rootTitulo.get("meioPagamento")).getExpression().in(meiosPagamentos));
        }
        criteria.where(preds.toArray(new Predicate[0]));
        List result = this.getEntityManager().createQuery(criteria).getResultList();
        return result;
    }

    public List<Titulo> findTitulosCliente(Date dataVencimentoInicial, Date dataVencimentoFinal, ClassificacaoClientes classificacaoClientes, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, UnidadeFatCliente unidadeFatCliente, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        Object hql = " select distinct titulo  from Titulo titulo  inner join titulo.meioPagamento m  inner join Cliente cliente on(cliente.pessoa = titulo.pessoa) inner join cliente.faturamento clienteFat left join Cooperado coop on(coop.cliente = cliente) where  titulo.provisao = :realizado  and  titulo.dataVencimento between :dataInicial and :dataFinal  and  titulo.valorSaldo > 0  and coop is null";
        if (TMethods.isWithData(meiosPagamentos)) {
            hql = (String)hql + " and m in(:meiosPagamento)";
        }
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and titulo.classificacaoPessoa = :classificacao";
        }
        if (ToolMethods.isEquals((Object)tipoCliente, (Object)1)) {
            hql = (String)hql + " and clienteFat.categoriaPessoa = :categoria";
        } else if (!ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and cliente.classificacaoClientes = :classificacao";
        }
        if (dataEmissaoInicial != null && dataEmissaoFinal != null) {
            hql = (String)hql + " and titulo.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal";
        }
        if (unidadeFatCliente != null) {
            hql = (String)hql + " and titulo.pessoa = :pessoa";
        }
        org.hibernate.query.Query q = this.query((String)hql);
        if (ToolMethods.isEquals((Object)tipoCliente, (Object)1)) {
            q.setParameter("categoria", (Object)categoriaPessoa);
        } else {
            q.setParameter("classificacao", (Object)classificacaoClientes);
        }
        q.setParameter("realizado", (Object)1);
        q.setDate("dataInicial", dataVencimentoInicial);
        q.setDate("dataFinal", dataVencimentoFinal);
        if (TMethods.isWithData(meiosPagamentos)) {
            q.setParameter("meiosPagamento", meiosPagamentos);
        }
        if (dataEmissaoInicial != null && dataEmissaoFinal != null) {
            q.setDate("dataEmissaoInicial", dataEmissaoInicial);
            q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        }
        if (unidadeFatCliente != null) {
            q.setParameter("pessoa", (Object)unidadeFatCliente.getPessoa());
        }
        return q.list();
    }

    public List<Titulo> titulosAbertoMesesAnterioresCooperado(TipoCooperado tipoCooperado, Date periodoInicial, Date periodoEmissaoInicial, Date periodoEmissaoFinal, List<MeioPagamento> meiosPagamentos) {
        CriteriaBuilder qb = this.criteriaBuilder();
        CriteriaQuery criteria = qb.createQuery(this.getEntityClass());
        Root rootTitulo = criteria.from(Titulo.class);
        Root rootClient = criteria.from(Cliente.class);
        Root rootCooperado = criteria.from(Cooperado.class);
        rootTitulo.alias("titulo");
        rootClient.alias("cliente");
        criteria.select((Selection)rootTitulo);
        List preds = TMethods.toList((Object[])new Object[]{qb.equal((Expression)rootTitulo.get("provisao"), (Object)1), qb.lessThan((Expression)rootTitulo.get("dataVencimento"), (Comparable)periodoInicial), qb.equal((Expression)rootTitulo.get("pessoa"), (Expression)rootClient.get("pessoa")), qb.equal((Expression)rootCooperado.get("cliente"), (Expression)rootClient), qb.equal((Expression)rootCooperado.get("tipoCooperado"), (Object)tipoCooperado), qb.greaterThan((Expression)rootTitulo.get("valorSaldo"), (Comparable)Double.valueOf(0.0))});
        if (periodoEmissaoInicial != null && periodoEmissaoFinal != null) {
            preds.add(qb.between((Expression)rootTitulo.get("dataEmissao"), (Comparable)periodoEmissaoInicial, (Comparable)periodoEmissaoFinal));
        }
        if (TMethods.isWithData(meiosPagamentos)) {
            preds.add(qb.in((Expression)rootTitulo.get("meioPagamento")).getExpression().in(meiosPagamentos));
        }
        criteria.where(preds.toArray(new Predicate[0]));
        List result = this.getEntityManager().createQuery(criteria).getResultList();
        return result;
    }

    public List<Titulo> titulosAbertoMesesAnterioresCliente(ClassificacaoClientes classificacaoClientes, Date dataVencimentoInicial, Date dataEmissaoInicial, Date dataEmissaoFinal, List<MeioPagamento> meiosPagamentos, CategoriaPessoa categoriaPessoa, Short tipoCliente, Short utilizarClassificacaoTitulo) {
        Object hql = " select distinct titulo  from Titulo titulo  inner join titulo.meioPagamento m inner join Cliente cliente on(cliente.pessoa = titulo.pessoa) inner join cliente.faturamento clienteFat left join Cooperado coop on(coop.cliente = cliente) where  titulo.provisao = :realizado  and  titulo.dataVencimento < :dataVencimento  and  titulo.valorSaldo > 0  and coop is null";
        if (TMethods.isWithData(meiosPagamentos)) {
            hql = (String)hql + " m in(:meiosPagamento)";
        }
        if (ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and titulo.classificacaoPessoa = :classificacao";
        }
        if (ToolMethods.isEquals((Object)tipoCliente, (Object)1)) {
            hql = (String)hql + " and clienteFat.categoriaPessoa = :categoria";
        } else if (!ToolMethods.isEquals((Object)utilizarClassificacaoTitulo, (Object)1)) {
            hql = (String)hql + " and cliente.classificacaoClientes = :classificacao";
        }
        if (dataEmissaoInicial != null && dataEmissaoFinal != null) {
            hql = (String)hql + " and titulo.dataEmissao between :dataEmissaoInicial and :dataEmissaoFinal";
        }
        org.hibernate.query.Query q = this.query((String)hql);
        if (ToolMethods.isEquals((Object)tipoCliente, (Object)1)) {
            q.setParameter("categoria", (Object)categoriaPessoa);
        } else {
            q.setParameter("classificacao", (Object)classificacaoClientes);
        }
        q.setParameter("realizado", (Object)1);
        q.setDate("dataVencimento", dataVencimentoInicial);
        if (TMethods.isWithData(meiosPagamentos)) {
            q.setParameter("meiosPagamento", meiosPagamentos);
        }
        if (dataEmissaoInicial != null && dataEmissaoFinal != null) {
            q.setDate("dataEmissaoInicial", dataEmissaoInicial);
            q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        }
        return q.list();
    }

    public Titulo findTituloFechamentoAdiantamentoViagem(FechamentoAdiantamentoViagem vo) {
        Criteria criteria = this.criteria();
        criteria.add(this.eq("adiantamentoViagemFechamento.identificador", vo.getIdentificador()));
        criteria.setMaxResults(1);
        return (Titulo)criteria.uniqueResult();
    }
}

