/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoTransportadorImpl
extends DaoGenericEntityImpl<Transportador, Long> {
    public Transportador findByCNPJ(String cnpj) {
        String query = "select distinct m   from Transportador m  where m.pessoa.complemento.cnpj = :cnpj";
        Query q = this.query(query);
        q.setString("cnpj", cnpj);
        q.setMaxResults(1);
        return (Transportador)q.uniqueResult();
    }

    public Transportador findByCNPJAtivo(String cnpj) {
        String query = "select distinct m   from Transportador m  where m.pessoa.complemento.cnpj = :cnpj and   m.pessoa.ativo = :ativo";
        Query q = this.query(query);
        q.setString("cnpj", cnpj);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (Transportador)q.uniqueResult();
    }

    public Transportador findByPessoa(Pessoa pessoa) {
        return (Transportador)this.toUnique(this.restrictions(this.eq("pessoa", pessoa)));
    }
}

