/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.basementorvalidator.others.cpfcnpj.ValidadeCPFCNPJ;
import com.touchcomp.touchvomodel.res.DTOUnidadeFatClienteRes;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoUnidadeFatClienteImpl
extends DaoGenericEntityImpl<UnidadeFatCliente, Long> {
    public UnidadeFatCliente getCNPJInscEst(String cnpj, String inscEst) {
        inscEst = ToolString.removerZerosAEsquerda((String)inscEst);
        Query q = this.query(" select distinct f  from UnidadeFatCliente f where  trim(LEADING 0 FROM f.pessoa.complemento.inscEst) = :inscEst and f.pessoa.complemento.cnpj = :cnpj");
        q.setParameter("inscEst", (Object)inscEst);
        q.setParameter("cnpj", (Object)cnpj);
        q.setMaxResults(1);
        try {
            return (UnidadeFatCliente)q.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public UnidadeFatCliente getCNPJInscEstAtivo(String cnpj, String inscEst) {
        inscEst = ToolString.removerZerosAEsquerda((String)inscEst);
        Query q = this.query(" select distinct f  from UnidadeFatCliente f where  trim(LEADING 0 FROM f.pessoa.complemento.inscEst) = :inscEst and f.pessoa.complemento.cnpj = :cnpj and f.pessoa.ativo = :ativo and f.cliente.ativo = :ativo");
        q.setParameter("inscEst", (Object)inscEst);
        q.setParameter("cnpj", (Object)cnpj);
        q.setParameter("ativo", (Object)1);
        q.setMaxResults(1);
        try {
            return (UnidadeFatCliente)q.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public UnidadeFatCliente getCNPJ(String cnpj) {
        Query q = this.query(" select distinct f  from UnidadeFatCliente f  where f.pessoa.complemento.cnpj = :cnpj and f.cliente.ativo = :ativo and f.pessoa.ativo = :ativo");
        q.setString("cnpj", cnpj);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (UnidadeFatCliente)q.uniqueResult();
    }

    public UnidadeFatCliente findFirstClienteAtivoPorUF(UnidadeFederativa uf) {
        Query q = this.query(" select distinct f  from UnidadeFatCliente f where f.pessoa.ativo = :ativo and f.pessoa.endereco.cidade.uf = :uf");
        q.setEntity("uf", (Object)uf);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (UnidadeFatCliente)q.uniqueResult();
    }

    public UnidadeFatCliente findFirstUnidFatClientePorCliente(Cliente cliente) {
        Query q = this.query("FROM UnidadeFatCliente c  WHERE c.cliente = :cliente");
        q.setEntity("cliente", (Object)cliente);
        q.setMaxResults(1);
        return (UnidadeFatCliente)q.uniqueResult();
    }

    public UnidadeFatCliente findUnidadeFatByPessoa(Pessoa pessoa) {
        Query q = this.query(" select distinct f  from UnidadeFatCliente f where f.pessoa = :pessoa");
        q.setEntity("pessoa", (Object)pessoa);
        q.setMaxResults(1);
        return (UnidadeFatCliente)q.uniqueResult();
    }

    public UnidadeFatCliente getByCnpjCepAtiva(String cnpj, String cep) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "pes");
        crit.createAlias("pes.endereco", "end");
        crit.createAlias("pes.complemento", "comp");
        return (UnidadeFatCliente)this.toUnique(this.restrictions(crit, this.eq("end.cep", cep), this.eq("comp.cnpj", cnpj), this.eq("pes.ativo", (short)1)));
    }

    public UnidadeFatCliente getByCnpjRaizCepAtiva(String cnpj, String cep) {
        cep = ((String)cep).substring(0, 5) + "%";
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "pes");
        crit.createAlias("pes.endereco", "end");
        crit.createAlias("pes.complemento", "comp");
        return (UnidadeFatCliente)this.toUnique(this.restrictions(crit, this.like("end.cep", cep), this.eq("comp.cnpj", cnpj), this.eq("pes.ativo", (short)1)));
    }

    public UnidadeFatCliente getByCnpjUnidPadraoAtiva(String cnpj, String cep) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "pes");
        crit.createAlias("pes.endereco", "end");
        crit.createAlias("pes.complemento", "comp");
        return (UnidadeFatCliente)this.toUnique(this.restrictions(crit, this.eq("unidadeFatPadrao", (short)1), this.eq("comp.cnpj", cnpj), this.eq("pes.ativo", (short)1)));
    }

    public List<UnidadeFatCliente> getAltCriados(Date lastDateSync) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "c");
        crit.createAlias("p.endereco", "e");
        crit.add(this.or(this.greatherEqual("dataAtualizacao", lastDateSync), this.greatherEqual("p.dataAtualizacao", lastDateSync), this.greatherEqual("c.dataAtualizacao", lastDateSync), this.greatherEqual("e.dataAtualizacao", lastDateSync)));
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    public List<DTOUnidadeFatClienteRes> findByDescricao(String descricao) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "co");
        crit.createAlias("cliente", "c");
        crit.createAlias("c.pessoa", "cp");
        crit.add(this.eq("p.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        crit.add(this.eq("c.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        crit.add(this.eq("cp.ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        Disjunction dis = Restrictions.disjunction();
        if (TString.isAIntNumber((String)descricao)) {
            dis.add(this.eq("c.identificador", Long.valueOf(descricao)));
        }
        if (ValidadeCPFCNPJ.isCPFCNPJ((String)descricao)) {
            dis.add(this.ilike("co.cnpj", descricao));
        }
        if (descricao.length() <= 25) {
            dis.add(this.eq("c.codigoCliente", descricao));
        }
        if (descricao.length() >= 50) {
            descricao = ToolString.cut((String)descricao, (int)50);
        }
        if (descricao.startsWith(" ")) {
            dis.add(this.ilike("p.nome", TString.removeStartSpaces((String)descricao)));
        } else {
            dis.add(this.ilikeRight("p.nome", descricao));
        }
        crit.add((Criterion)dis);
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"c.identificador"), "idCliente");
        select.add((Projection)Projections.property((String)"identificador"), "identificador");
        select.add((Projection)Projections.property((String)"p.nome"), "nome");
        select.add((Projection)Projections.property((String)"p.nomeFantasia"), "nomeFantasia");
        select.add((Projection)Projections.property((String)"co.cnpj"), "cnpj");
        select.add((Projection)Projections.property((String)"co.inscEst"), "inscricaoEstadual");
        select.add((Projection)Projections.property((String)"c.codigoCliente"), "codigoCliente");
        select.add((Projection)Projections.property((String)"p.identificador"), "pessoaIdentificador");
        crit.setProjection((Projection)select);
        List<Map<String, Object>> ret = this.toHashList(crit);
        LinkedList<DTOUnidadeFatClienteRes> res = new LinkedList<DTOUnidadeFatClienteRes>();
        for (Map<String, Object> map : ret) {
            DTOUnidadeFatClienteRes dto = new DTOUnidadeFatClienteRes();
            dto.setClienteIdentificador((Long)map.get("idCliente"));
            dto.setIdentificador((Long)map.get("identificador"));
            dto.setNome((String)map.get("nome"));
            dto.setNomeFantasia((String)map.get("nomeFantasia"));
            dto.setCnpj((String)map.get("cnpj"));
            dto.setInscricaoEstadual((String)map.get("inscricaoEstadual"));
            dto.setCodigoCliente((String)map.get("codigoCliente"));
            dto.setPessoaIdentificador((Long)map.get("pessoaIdentificador"));
            res.add(dto);
        }
        return res;
    }
}

