/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Date;
import java.util.List;
import javax.persistence.NoResultException;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.CriteriaSpecification;
import org.springframework.stereotype.Repository;

@Repository
public class DaoUnidadeFatFornecedorImpl
extends DaoGenericEntityImpl<UnidadeFatFornecedor, Long> {
    public UnidadeFatFornecedor getFirstByCnpjCPF(String cnpjCpf) {
        org.hibernate.query.Query q = this.query("select distinct u FROM UnidadeFatFornecedor u inner join u.fornecedor f WHERE f.pessoa.complemento.cnpj = :cnpjCpf order by u.identificador");
        q.setString("cnpjCpf", cnpjCpf);
        q.setMaxResults(1);
        return (UnidadeFatFornecedor)this.toUnique((Query)q);
    }

    public UnidadeFatFornecedor getFirstByCnpjCPFAtivo(String cnpjCpf) {
        org.hibernate.query.Query q = this.query("SELECT DISTINCT u FROM UnidadeFatFornecedor u INNER JOIN u.fornecedor f WHERE f.pessoa.complemento.cnpj = :cnpjCpf AND u.pessoa.ativo = :ativo AND f.ativo = :ativo order by u.identificador");
        q.setString("cnpjCpf", cnpjCpf);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (UnidadeFatFornecedor)this.toUnique((Query)q);
    }

    public UnidadeFatFornecedor getCNPJInscEstAtivo(String cnpj, String inscEst) {
        return this.getUnidadeFatFornCNPJInscEstAtivo(cnpj, inscEst);
    }

    public UnidadeFatFornecedor findFirstUnidFatClientePorCliente(Fornecedor fornecedor) {
        org.hibernate.query.Query q = this.query("FROM UnidadeFatFornecedor f  WHERE f.fornecedor = :fornecedor");
        q.setEntity("fornecedor", (Object)fornecedor);
        q.setMaxResults(1);
        return (UnidadeFatFornecedor)q.uniqueResult();
    }

    public UnidadeFatFornecedor findUnidadeFatByPessoa(Pessoa pessoa) {
        org.hibernate.query.Query q = this.query(" select distinct f  from UnidadeFatFornecedor f where f.pessoa = :pessoa");
        q.setEntity("pessoa", (Object)pessoa);
        q.setMaxResults(1);
        return (UnidadeFatFornecedor)q.uniqueResult();
    }

    public List<UnidadeFatFornecedor> getAltCriados(Date lastDateSync) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "c");
        crit.createAlias("p.endereco", "e");
        crit.add(this.or(this.greatherEqual("dataAtualizacao", lastDateSync), this.greatherEqual("p.dataAtualizacao", lastDateSync), this.greatherEqual("c.dataAtualizacao", lastDateSync), this.greatherEqual("e.dataAtualizacao", lastDateSync)));
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    private UnidadeFatFornecedor getUnidadeFatFornCNPJInscEstAtivo(String cnpj, String inscEst) {
        inscEst = ToolString.removerZerosAEsquerda((String)inscEst);
        String query = "SELECT distinct f FROM UnidadeFatFornecedor f WHERE  trim(LEADING 0 FROM f.pessoa.complemento.inscEst) = :inscEst AND f.pessoa.complemento.cnpj = :cnpj AND f.pessoa.ativo = :ativo";
        org.hibernate.query.Query q = this.query(query);
        q.setParameter("inscEst", (Object)inscEst);
        q.setParameter("cnpj", (Object)cnpj);
        q.setParameter("ativo", (Object)1);
        q.setMaxResults(1);
        try {
            return (UnidadeFatFornecedor)q.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }
}

