/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.criterion.Order;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoUnidadeFederativaImpl
extends DaoGenericEntityImpl<UnidadeFederativa, Long> {
    public UnidadeFederativa getBySigla(String uf) {
        uf = uf != null ? uf.toUpperCase() : null;
        return (UnidadeFederativa)this.toUnique(this.restrictions(this.eq("sigla", uf)));
    }

    public List<UnidadeFederativa> getUFsOrdenadasByDescricao() {
        return this.toList(this.order(this.criteria(), "descricao"));
    }

    public UnidadeFederativa getByCodIBGE(String codIbge) {
        return (UnidadeFederativa)this.toUnique(this.restrictions(this.eq("codIbge", codIbge)));
    }

    public List<UnidadeFederativa> getUFsOrdenadasByPais(Long idPais) {
        return this.toList(this.restrictions(this.eq("pais.identificador", idPais)).addOrder(Order.asc((String)"sigla")));
    }

    public List<UnidadeFederativa> getUFsOrdenadasByCodIbgePais(String codIbgePais) {
        Query q = this.query("SELECT u FROM UnidadeFederativa u INNER JOIN u.pais p WHERE p.codIbge = :codIbgePais");
        q.setParameter("codIbgePais", (Object)codIbgePais);
        return q.list();
    }
}

