/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.List;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import org.hibernate.Criteria;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoUsuarioBasicoImpl
extends DaoGenericEntityImpl<UsuarioBasico, Long> {
    public List<UsuarioBasico> getUsuarios(Long idGrupo) {
        Criteria crit = this.criteria();
        crit.createAlias("empresas", "emp");
        crit.createAlias("emp.grupo", "gr");
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return this.toList(this.restrictions(crit, this.eq("gr.identificador", idGrupo)));
    }

    public List<UsuarioBasico> getUsuariosAtivos() {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "pes");
        crit.addOrder(Order.asc((String)"pes.nome"));
        return this.toList(this.restrictions(crit, this.eq("pes.ativo", (short)1)));
    }

    public UsuarioBasico getUsuarioByEmailCpfCnpj(String email, String cpfCnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "pes");
        crit.createAlias("pes.complemento", "comp");
        crit.createAlias("comp.emails", "e");
        crit.addOrder(Order.asc((String)"pes.nome"));
        return (UsuarioBasico)this.toUnique(this.restrictions(crit, this.eq("ativo", (short)1), this.eq("e.ativo", (short)1), this.eq("pes.ativo", (short)1), this.eq("e.email", email), this.eq("comp.cnpj", cpfCnpj)));
    }

    public boolean existeEmailAtivoMaisUsuario() {
        String query = "select count(u.identificador) from UsuarioBasico u inner join u.pessoa p inner join p.complemento c inner join c.emails e group by e.email having count(u.identificador)>1 ";
        Long count = (Long)this.query(query).setMaxResults(1).uniqueResult();
        return count != null && count > 0L;
    }

    public UsuarioBasico getUsuarioByLogin(String login) {
        Criteria crit = this.criteria();
        crit.createAlias("login", "l");
        crit.createAlias("pessoa", "pes");
        return (UsuarioBasico)this.toUnique(this.restrictions(crit, this.eq("ativo", (short)1), this.eq("pes.ativo", (short)1), this.eq("l.login", String.valueOf(login).toUpperCase())));
    }

    public UsuarioBasico getByLogin(String userName) {
        Criteria c = this.criteria();
        c.createAlias("login", "l");
        c.add((Criterion)Restrictions.eq((String)"l.login", (Object)userName.toUpperCase()));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        return (UsuarioBasico)this.toUnique(c);
    }

    public UsuarioBasico getByPessoa(Pessoa pessoa) {
        return (UsuarioBasico)this.toUnique(this.restrictions(this.eq("pessoa", pessoa)));
    }

    public UsuarioBasico getEager(Long idUsuario) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Fetch f = builder.joinFetch("pessoa");
        Fetch c = builder.joinFetch((FetchParent)f, "complemento");
        Fetch e = builder.joinFetch((FetchParent)f, "endereco");
        Fetch u = builder.joinFetch("usuario");
        Fetch uc = builder.joinFetch((FetchParent)u, "usuarioConfiguracoes");
        builder.equal("identificador", idUsuario);
        return (UsuarioBasico)builder.getUniqueResult();
    }
}

