/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.NodoUsuario;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SetorUsuario;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoUsuarioImpl
extends DaoGenericEntityImpl<Usuario, Long> {
    public Usuario findByLogin(String userName) {
        Criteria c = this.criteria();
        c.createAlias("usuarioBasico", "u");
        c.createAlias("u.login", "l");
        c.add((Criterion)Restrictions.eq((String)"l.login", (Object)userName.toUpperCase()));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        Usuario found = (Usuario)c.uniqueResult();
        return found;
    }

    public List<Usuario> getUsuarios(Long idGrupo) {
        Criteria crit = this.criteria();
        crit.createAlias("usuarioBasico", "u");
        crit.createAlias("u.empresas", "emp");
        crit.createAlias("emp.grupo", "gr");
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return this.toList(this.restrictions(crit, this.eq("gr.identificador", idGrupo)));
    }

    public List<Usuario> getUsuariosAtivos() {
        Criteria crit = this.criteria();
        crit.createAlias("usuarioBasico", "u");
        crit.createAlias("u.pessoa", "pes");
        crit.addOrder(Order.asc((String)"pes.nome"));
        return this.toList(this.restrictions(crit, this.eq("pes.ativo", (short)1), this.eq("ativo", (short)1)));
    }

    public List<Usuario> getUsuarioRepresentanteAtivoByEmpresa(Empresa emp) {
        org.hibernate.query.Query q = this.query("select\nu\nfrom Usuario u\ninner join Representante r on (u.usuarioBasico.pessoa = r.pessoa)\ninner join r.representanteEmpresa re\n\tinner join re.empresa emp\nwhere (emp.identificador = :idEmpresa)\nand (re.ativo = :sim)\norder by u.usuarioBasico.pessoa.nome");
        q.setShort("sim", EnumConstantsMentorSimNao.SIM.getValue());
        q.setLong("idEmpresa", emp.getIdentificador().longValue());
        return this.toList((Query)q);
    }

    public List<Usuario> getUsuariosAtivosBySetor(SetorUsuario s) {
        Criteria c = this.criteria();
        c.createAlias("usuarioBasico", "ub");
        c.createAlias("ub.pessoa", "p");
        return this.toList(this.restrictions(c, this.eq("ativo", (short)1), this.eq("p.ativo", (short)1), this.eq("setorUsuario", s)));
    }

    public List<Usuario> getUsuarioNodo(List<Nodo> listNodo) {
        CriteriaBuilder builder = this.criteriaBuilder(Usuario.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromUsuario = crit.from(Usuario.class);
        Root fromNodoUsuario = crit.from(NodoUsuario.class);
        Join jUsuario = fromNodoUsuario.join("usuario", JoinType.INNER);
        Join jNodo = fromNodoUsuario.join("nodo", JoinType.INNER);
        crit.select((Selection)fromUsuario).distinct(true);
        exps.add(builder.equal((Expression)fromUsuario.get("identificador"), (Expression)jUsuario.get("identificador")));
        exps.add(builder.equal((Expression)fromUsuario.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(jNodo.in(listNodo));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public Usuario getEager(Long idUsuario) {
        String query = "select u from Usuario u JOIN FETCH u.usuarioBasico ub JOIN FETCH u.usuarioConfiguracoes uc JOIN FETCH ub.pessoa p  JOIN FETCH p.complemento c JOIN FETCH p.endereco e where u.identificador = :idUsuario";
        org.hibernate.query.Query hql = this.query(query);
        hql.setParameter("idUsuario", (Object)idUsuario);
        hql.setMaxResults(1);
        return (Usuario)hql.uniqueResult();
    }

    @Override
    public Usuario get(UsuarioBasico ub) {
        String query = "from Usuario u where u.usuarioBasico=:usuario";
        org.hibernate.query.Query hql = this.query(query);
        hql.setParameter("usuario", (Object)ub);
        hql.setMaxResults(1);
        return (Usuario)hql.uniqueResult();
    }

    @Override
    public Usuario get(Pessoa pessoa) {
        String query = "from Usuario u where u.usuarioBasico.pessoa=:pessoa";
        org.hibernate.query.Query hql = this.query(query);
        hql.setParameter("pessoa", (Object)pessoa);
        hql.setMaxResults(1);
        return (Usuario)hql.uniqueResult();
    }

    public List<Map<String, Object>> getIdsUsuariosAtivos() {
        String query = "select distinct u.identificador as ID_USUARIO, p.nome as NOME_USUARIO from Usuario u  inner join u.usuarioBasico ub inner join ub.pessoa p where p.ativo = :sim";
        org.hibernate.query.Query q = this.query(query);
        q.setShort("sim", (short)1);
        return this.toHashList((Query)q);
    }
}

