/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.bi.EnumConstTipoRepositorioBI;
import com.touchcomp.basementor.constants.enums.businessintelligence.EnumConstBITipoPublicidade;
import com.touchcomp.basementor.model.vo.VersaoRepositorioBI;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoVersaoRepositorioBIImpl
extends DaoGenericEntityImpl<VersaoRepositorioBI, Long> {
    public VersaoRepositorioBI get(String serialBI, Long numeroVersaoRep, Long numeroVersao) {
        Criteria c = this.criteria();
        c.createAlias("repositorioBI", "rep");
        c.createAlias("rep.importacaoBi", "imp");
        c.add((Criterion)Restrictions.eq((String)"numeroVersao", (Object)numeroVersao));
        c.add((Criterion)Restrictions.eq((String)"rep.numeroVersao", (Object)numeroVersaoRep));
        c.add((Criterion)Restrictions.eq((String)"imp.serialLocalBI", (Object)serialBI));
        return (VersaoRepositorioBI)c.uniqueResult();
    }

    public VersaoRepositorioBI get(String serialBI, Long numeroVersaoRep, Long numeroVersao, String baseCnpj, EnumConstTipoRepositorioBI tipo) {
        Criteria c = this.criteria();
        c.createAlias("repositorioBI", "rep");
        c.createAlias("rep.importacaoBi", "imp");
        c.createAlias("imp.clientesVinculados", "c", JoinType.LEFT_OUTER_JOIN);
        c.add((Criterion)Restrictions.eq((String)"numeroVersao", (Object)numeroVersao));
        c.add((Criterion)Restrictions.eq((String)"rep.numeroVersao", (Object)numeroVersaoRep));
        c.add((Criterion)Restrictions.eq((String)"imp.serialLocalBI", (Object)serialBI));
        c.add((Criterion)Restrictions.eq((String)"imp.tipoRepositorioBI", (Object)tipo.getValue()));
        c.add(this.or(this.eq("imp.tipoPublicidadeBI", EnumConstBITipoPublicidade.BI_PUBLICO.getValue()), this.and(this.eq("imp.tipoPublicidadeBI", EnumConstBITipoPublicidade.BI_PRIVADO.getValue()), this.eq("c.baseCNPJ", baseCnpj))));
        return (VersaoRepositorioBI)c.uniqueResult();
    }

    public List<Map<String, Object>> getVersoesMap(Long idRepositorio, Integer nrVersaoEstruturaBI) {
        String hql = " select distinct  v.numeroVersao as NR_VERSAO, v.dataEnvio as DATA_ENVIO,  v.descricaoAlteracoes as ALTERACOES from VersaoRepositorioBI v  inner join v.repositorioBI r  where r.identificador = :idRepositorio  and v.publicado = :sim and (v.inativo is null or v.inativo = :nao) and v.nrVersaoEstruturaBI>=:nrVersaoEstruturaBI order by r.descricao";
        return this.query(hql).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).setLong("idRepositorio", idRepositorio.longValue()).setInteger("nrVersaoEstruturaBI", nrVersaoEstruturaBI.intValue()).setLong("sim", 1L).setLong("nao", 0L).list();
    }

    public List<Map<String, Object>> getRepositoriosAtivos() {
        String hql = " select distinct i.descricao as DESCRICAO_BI, i.serialLocalBI as SERIAL_BI, i.numeroControle as NR_CONTROLE_BI, i.inativo as INATIVO_IMPORTACAO_BI, r.numeroVersao as NUMERO_VERSAO_REP, r.inativo as INATIVO_REP, v.inativo as INATIVO_VERSAO, v.numeroVersao as NUMERO_VERSAO_VER, v.motivoInativo as MOTIVO_INATIVAR_VER, v.versaoBIPadraoCliente as VERSAO_PADRAO_CLIENTE, v.descricaoAlteracoes as ALTERACOES from RepositorioBi r  inner join r.importacaoBi i  inner join r.versaosRepositorioBI v  where v.publicado = :sim";
        return this.query(hql).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).setShort("sim", (short)1).list();
    }
}

