/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.websocket.EnumConstStatusMessageWebSocket;
import com.touchcomp.basementor.model.vo.WebSocketMessage;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoWebSocketMessageImpl
extends DaoGenericEntityImpl<WebSocketMessage, Long> {
    public WebSocketMessage getByUid(String uid) {
        Criteria crit = this.criteria();
        crit.add(this.eq("uid", uid));
        crit.setMaxResults(1);
        return (WebSocketMessage)this.toUnique(crit);
    }

    public List<WebSocketMessage> listMessagesToResend(Integer maxTentativasEnvio, Integer tempoReenvio, String canal) {
        Criteria crit = this.criteria();
        crit.add(this.notEqual("status", EnumConstStatusMessageWebSocket.PROCESSADO.getValue()));
        crit.add(this.less("tentativasEnvio", maxTentativasEnvio));
        crit.add(this.less("dataUltimoEnvio", ToolDate.previousDays((Date)new Date(), (int)10, (int)tempoReenvio)));
        crit.add(this.eq("canal", canal));
        return crit.list();
    }

    public Integer deleteOldMessages(Integer days) {
        CriteriaBuilder builder = this.criteriaBuilder();
        CriteriaDelete cq = builder.createCriteriaDelete(WebSocketMessage.class);
        Root root = cq.from(WebSocketMessage.class);
        cq.where((Expression)builder.lessThan((Expression)root.get("dataCadastro"), (Comparable)ToolDate.previousDays((Date)new Date(), (int)days)));
        return this.getEntityManager().createQuery(cq).executeUpdate();
    }

    public Integer updateMessagesTentativasExc(Integer maxTentativas) {
        CriteriaBuilder builder = this.criteriaBuilder();
        CriteriaUpdate cq = builder.createCriteriaUpdate(WebSocketMessage.class);
        Root root = cq.from(WebSocketMessage.class);
        cq.set(root.get("status"), (Object)EnumConstStatusMessageWebSocket.TENTATIVAS_EXCEDIDAS.getValue());
        cq.where((Expression)builder.greaterThanOrEqualTo((Expression)root.get("tentativasEnvio"), (Comparable)maxTentativas));
        return this.getEntityManager().createQuery(cq).executeUpdate();
    }
}

