/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoWmsPedidoImpl
extends DaoGenericEntityImpl<WmsPedido, Long> {
    public WmsPedido get(Long idSolicitacao, Grupo grupoUsuarios) {
        Criteria crit = this.criteria();
        crit.createAlias("statusPedido", "stat");
        crit.createAlias("stat.gruposUsuarios", "gr");
        return (WmsPedido)this.toUnique(this.restrictions(crit, this.eq("identificador", idSolicitacao), this.eq("gr.grupo", grupoUsuarios)));
    }

    public List<WmsPedido> getPedidos(Short filtrarData, Date dataInicial, Date dataFinal, Long idStatusPedido, Grupo grupoUsuarios, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.createAlias("statusPedido", "s");
        crit.createAlias("s.gruposUsuarios", "gr");
        if (ToolMethods.isAffirmative((Number)filtrarData)) {
            crit.add(this.between("dataSolicitacao", dataInicial, dataFinal));
        }
        crit.add(this.eq("s.identificador", idStatusPedido));
        crit.add(this.eq("gr.grupo", grupoUsuarios));
        crit.add(this.eq("empresa", empresa));
        return this.toList(crit);
    }

    public int atualizarSituacaoPedidos(WmsPedido pedido) {
        CriteriaBuilder cb = this.getSession().getCriteriaBuilder();
        CriteriaUpdate update = cb.createCriteriaUpdate(this.getEntityClass());
        Root e = update.from(WmsPedido.class);
        update.set("statusPedido", (Object)pedido.getStatusPedido());
        update.where((Expression)cb.equal((Expression)e.get("identificador"), (Object)pedido.getIdentificador()));
        return this.getSession().createQuery(update).executeUpdate();
    }
}

