/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.impl.WmsEstatisticasEndereco;
import com.touchcomp.basementor.model.impl.WmsSaldoEstoque;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.resulttransformer.ResultTransfEstatisticasEnderecosWMS;
import com.touchcomp.basementorservice.dao.resulttransformer.ResultTransfSaldoEstoqueBasicoWMS;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.EstatisticasWmsParams;
import com.touchcomp.basementorservice.service.impl.wmssaldoestoque.SaldoEstoqueWmsParams;
import java.util.List;
import java.util.Map;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoWmsSaldoEstoque
extends DaoGenericImpl {
    ResultTransformer RESULT_TRANSF_MAP = AliasToEntityMapResultTransformer.INSTANCE;
    ResultTransfSaldoEstoqueBasicoWMS RESULT_TRANSF_BASICO = new ResultTransfSaldoEstoqueBasicoWMS();
    ResultTransfEstatisticasEnderecosWMS RESULT_TRANSF_STAT = new ResultTransfEstatisticasEnderecosWMS();

    public List<WmsEstatisticasEndereco> findSaldoWMSEstatisticas(EstatisticasWmsParams params) {
        NativeQuery q = this.sqlQuery(" select  s.R_ID_EMPRESA as ID_EMPRESA, S.R_ID_WMS_ENDERECO AS ID_WMS_ENDERECO, S.R_WMS_ENDERECO AS WMS_ENDERECO, S.R_WMS_COD_ENDERECO AS WMS_COD_ENDERECO, S.R_SCORE_ENDERECO as SCORE_ENDERECO, S.R_PESO_UTILIZADO AS PESO_UTILIZADO, S.R_PESO_MAXIMO AS PESO_MAXIMO, S.R_PESO_DISPONIVEL AS PESO_DISPONIVEL, S.R_VOLUME_UTILIZADO AS VOLUME_UTILIZADO, S.R_VOLUME_MAXIMO AS VOLUME_MAXIMO, S.R_VOLUME_DISPONIVEL AS VOLUME_DISPONIVEL, S.R_PERC_UTIL_VOLUME AS PERC_UTIL_VOLUME, S.R_PERC_UTIL_PESO AS PERC_UTIL_PESO, S.R_ID_GRADES_VINCULADAS as ID_GRADES_VINCULADAS from  PROCTO_EST_WMS_CONS_SAL_E_STAT( :P_ID_EMPRESA_INICIAL, :P_ID_EMPRESA_FINAL, :P_CODIGO_ENDERECO_WMS_IN, :P_CODIGO_ENDERECO_WMS_FIM, :P_TIPO_ANALISE_STAT, :P_TIPO_DISPONIBILIDADE, :P_CARREGAR_GRADES_VINCULADAS) s order by S.R_SCORE_ENDERECO");
        q.setParameter("P_ID_EMPRESA_INICIAL", (Object)params.getIdEmpresaIn());
        q.setParameter("P_ID_EMPRESA_FINAL", (Object)params.getIdEmpresaFim());
        q.setParameter("P_CODIGO_ENDERECO_WMS_IN", (Object)params.getCodEndWmsIn());
        q.setParameter("P_CODIGO_ENDERECO_WMS_FIM", (Object)params.getCodEndWmsFim());
        q.setParameter("P_TIPO_ANALISE_STAT", (Object)params.getTipoStat().getValue());
        q.setParameter("P_TIPO_DISPONIBILIDADE", (Object)params.getTipodisp().getValue());
        q.setParameter("P_CARREGAR_GRADES_VINCULADAS", (Object)(params.getCarregarCaractVincEndereco() != false ? (short)1 : 0));
        q.setResultTransformer((ResultTransformer)this.RESULT_TRANSF_STAT);
        List l = q.list();
        return l;
    }

    public List<WmsSaldoEstoque> findSaldoWMS(SaldoEstoqueWmsParams params) {
        return this.findSaldoWMSInternal(params, this.RESULT_TRANSF_BASICO);
    }

    public List<Map<String, Object>> findSaldoWMSMap(SaldoEstoqueWmsParams params) {
        return this.findSaldoWMSInternal(params, this.RESULT_TRANSF_MAP);
    }

    private List findSaldoWMSInternal(SaldoEstoqueWmsParams params, ResultTransformer resultTransf) {
        NativeQuery q = this.sqlQuery("select S.R_ID_EMPRESA as ID_EMPRESA, S.R_DATA_SALDO as DATA_SALDO, S.R_SALDO_QTD as SALDO_QTD,\n       S.R_QTD_ENTRADA_DIA as QTD_ENTRADA_DIA, S.R_QTD_SAIDA_DIA as QTD_SAIDA_DIA, S.R_ID_PRODUTO as ID_PRODUTO,\n       p.nome as NOME_PRODUTO, p.codigo_auxiliar as CODIGO_AUXILIAR, u.sigla as SIGLA_UN_PROD,\n       e.id_especie as ID_ESPECIE, e.nome as ESPECIE, se.id_sub_especie as ID_SUB_ESPECIE,\n       se.nome as SUB_ESPECIE, f.id_fabricante as ID_FABRICANTE, f.nome as FABRICANTE,\n       S.R_ID_LOTE_FABRICACAO as ID_LOTE_FABRICACAO, s.r_lote_fabricacao as LOTE_FABRICACAO,\n       s.r_data_fabricacao as DATA_FAB_LOTE, s.r_data_validade as DATA_VAL_LOTE, g.id_grade_cor as ID_GRADE_COR,\n       cc.nome as GRADE_COR, S.R_ID_WMS_ENDERECO as ID_WMS_ENDERECO, s.r_wms_endereco as WMS_ENDERECO,\n       s.r_wms_cod_endereco as WMS_COD_ENDERECO, S.R_SALDO_QTD_ANTERIOR_RES as SALDO_QTD_ANTERIOR_RES,\n       S.R_SALDO_QTD_RES as SALDO_QTD_RES, S.R_QTD_ENTRADA_DIA_RES as QTD_ENTRADA_DIA_RES,\n       S.R_QTD_SAIDA_DIA_RES as QTD_SAIDA_DIA_RES, S.R_SALDO_QTD_DISPONIVEL as SALDO_QTD_DISPONIVEL,\n       S.R_SCORE_ENDERECO as SCORE_ENDERECO, S.R_PESO_UTILIZADO as PESO_UTILIZADO,\n       S.R_VOLUME_UTILIZADO as VOLUME_UTILIZADO\nfrom PROCTO_EST_WMS_CONS_SALDO_EST(:P_DATA_POSICAO_SALDO,\n:P_ID_PRODUTO_INICIAL, :P_ID_PRODUTO_FINAL,\n:P_ID_GRADE_COR_INICIAL, :P_ID_GRADE_COR_FINAL,\n:P_ID_ESPECIE_INICIAL, :P_ID_ESPECIE_FINAL,\n:P_ID_SUB_ESP_INICIAL, :P_ID_SUB_ESP_FINAL,\n:P_ID_FAB_INICIAL, :P_ID_FAB_FINAL,\n:P_ID_EMPRESA_INICIAL, :P_ID_EMPRESA_FINAL,\n:P_CODIGO_ENDERECO_WMS_IN, :P_CODIGO_ENDERECO_WMS_FIM,\n:P_ID_L_FABRICACAO, :P_TIPO_SALDO, :P_TIPO_SALDO_QTD,:P_ID_CENTRO_ESTOQUE) S\nleft join produto p on p.id_produto = s.r_id_produto\nleft join unidade_medida u on u.id_unidade_medida = p.id_unidade_medida\nleft join especie e on e.id_especie = p.id_especie\nleft join sub_especie se on se.id_sub_especie = p.id_sub_especie\nleft join fabricante f on f.id_fabricante = p.id_fabricante\nleft join grade_cor g on g.id_grade_cor = s.r_id_grade_cor\nleft join cor cc on cc.id_cor = g.id_cor\norder by s.r_score_endereco");
        q.setDate("P_DATA_POSICAO_SALDO", params.getDataSaldo());
        if (this.isZero(params.getIdEmpresaIn(), params.getIdEmpresaFim())) {
            q.setParameter("P_ID_EMPRESA_INICIAL", null);
            q.setParameter("P_ID_EMPRESA_FINAL", null);
        } else {
            q.setParameter("P_ID_EMPRESA_INICIAL", (Object)params.getIdEmpresaIn());
            q.setParameter("P_ID_EMPRESA_FINAL", (Object)params.getIdEmpresaFim());
        }
        if (this.isZero(params.getIdProdutoIn(), params.getIdProdutoFim())) {
            q.setParameter("P_ID_PRODUTO_INICIAL", null);
            q.setParameter("P_ID_PRODUTO_FINAL", null);
        } else {
            q.setParameter("P_ID_PRODUTO_INICIAL", (Object)params.getIdProdutoIn());
            q.setParameter("P_ID_PRODUTO_FINAL", (Object)params.getIdProdutoFim());
        }
        if (this.isZero(params.getIdGradeCorIn(), params.getIdGradeCorFim())) {
            q.setParameter("P_ID_GRADE_COR_INICIAL", null);
            q.setParameter("P_ID_GRADE_COR_FINAL", null);
        } else {
            q.setParameter("P_ID_GRADE_COR_INICIAL", (Object)params.getIdGradeCorIn());
            q.setParameter("P_ID_GRADE_COR_FINAL", (Object)params.getIdGradeCorFim());
        }
        if (this.isZero(params.getIdEspecieIn(), params.getIdEspecieFim())) {
            q.setParameter("P_ID_ESPECIE_INICIAL", null);
            q.setParameter("P_ID_ESPECIE_FINAL", null);
        } else {
            q.setParameter("P_ID_ESPECIE_INICIAL", (Object)params.getIdEspecieIn());
            q.setParameter("P_ID_ESPECIE_FINAL", (Object)params.getIdEspecieFim());
        }
        if (this.isZero(params.getIdSubespecieIn(), params.getIdSubespecieFim())) {
            q.setParameter("P_ID_SUB_ESP_INICIAL", null);
            q.setParameter("P_ID_SUB_ESP_FINAL", null);
        } else {
            q.setParameter("P_ID_SUB_ESP_INICIAL", (Object)params.getIdSubespecieIn());
            q.setParameter("P_ID_SUB_ESP_FINAL", (Object)params.getIdSubespecieFim());
        }
        if (this.isZero(params.getIdFabricanteIn(), params.getIdFabricanteFim())) {
            q.setParameter("P_ID_FAB_INICIAL", null);
            q.setParameter("P_ID_FAB_FINAL", null);
        } else {
            q.setParameter("P_ID_FAB_INICIAL", (Object)params.getIdFabricanteIn());
            q.setParameter("P_ID_FAB_FINAL", (Object)params.getIdFabricanteFim());
        }
        if (this.isZero(params.getCodEndWmsIn(), params.getCodEndWmsFim())) {
            q.setParameter("P_CODIGO_ENDERECO_WMS_IN", null);
            q.setParameter("P_CODIGO_ENDERECO_WMS_FIM", null);
        } else {
            q.setParameter("P_CODIGO_ENDERECO_WMS_IN", (Object)params.getCodEndWmsIn());
            q.setParameter("P_CODIGO_ENDERECO_WMS_FIM", (Object)params.getCodEndWmsFim());
        }
        if (this.isZero(params.getIdLoteFabricacao())) {
            q.setParameter("P_ID_L_FABRICACAO", null);
        } else {
            q.setParameter("P_ID_L_FABRICACAO", (Object)params.getIdLoteFabricacao());
        }
        if (this.isZero(params.getIdCentroEstoque())) {
            q.setParameter("P_ID_CENTRO_ESTOQUE", null);
        } else {
            q.setParameter("P_ID_CENTRO_ESTOQUE", (Object)params.getIdCentroEstoque());
        }
        q.setParameter("P_TIPO_SALDO", (Object)params.getTipoSaldo().getValue());
        q.setParameter("P_TIPO_SALDO_QTD", (Object)params.getTipoSaldoQtd().getValue());
        q.setResultTransformer(resultTransf);
        List l = q.list();
        return l;
    }

    private boolean isZero(Long ... itens) {
        if (itens == null) {
            return false;
        }
        boolean isAllZero = true;
        for (Long item : itens) {
            isAllZero = isAllZero && item != null && item == 0L;
        }
        return isAllZero;
    }

    private boolean isZero(String idProdutoIn, String idProdutoFim) {
        return idProdutoIn != null && idProdutoIn.equalsIgnoreCase("0") && idProdutoFim != null && idProdutoFim.equalsIgnoreCase("0");
    }
}

