/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl.businessintelligence;

import com.touchcomp.basementor.model.impl.BusinessIntelligenceTemp;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.dao.impl.businessintelligence.DaoBusinessIntelligencePrefImpl;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.impl.businessintelligence.DadosBILocais;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.businessintelligencesincronizacao.DTOBusinessIntelligenceItem;
import com.touchcomp.touchvomodel.vo.businessintelligencesincronizacao.DTOBusinessIntelligenceItemDet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.hql.internal.ast.ASTQueryTranslatorFactory;
import org.hibernate.hql.spi.QueryTranslator;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoBusinessIntelligenceImpl
extends DaoGenericEntityImpl<BusinessIntelligence, Long> {
    public List<BusinessIntelligenceTemp> findBIsUsuario(Long idEmpresa, Long idGrupoUsuarios) {
        Query q = this.query("select distinct b.identificador as ID_BI, b.numeroBI as NUMERO_BI, b.descricao as DESCRICAO, b.observacao as OBSERVACAO from BusinessIntelligence b inner join b.businessIntelligenceInf bi left join bi.grupos bg left join bg.grupo g left join bi.empresas be left join be.empresa e where g.identificador=:grupo and ( bi.filtrarEmpresa = :nao or e.identificador = :empresa ) and b.ativo = :sim order by b.descricao");
        q.setLong("grupo", idGrupoUsuarios.longValue());
        q.setLong("empresa", idEmpresa.longValue());
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List tmp = q.list();
        LinkedList<BusinessIntelligenceTemp> ret = new LinkedList<BusinessIntelligenceTemp>();
        for (HashMap h : tmp) {
            String descricao = (String)h.get("DESCRICAO");
            String observacao = (String)h.get("OBSERVACAO");
            Long id = (Long)h.get("ID_BI");
            Long numero = (Long)h.get("NUMERO_BI");
            BusinessIntelligenceTemp b = new BusinessIntelligenceTemp(Boolean.valueOf(false));
            b.setDescricao(descricao);
            b.setNumeroBI(numero);
            b.setIdentificador(id);
            b.setObservacao(observacao);
            ret.add(b);
        }
        return ret;
    }

    public List<BusinessIntelligenceTemp> findBIsNodo(Long idNodo, Long idEmpresa, Long idGrupo) {
        AuxCriteriaBuilder crit = this.queryBuilder(this.getEntityClass());
        crit.select(new AuxCriteriaBuilder.Pair("identificador", "ID_BI"), new AuxCriteriaBuilder.Pair("numeroBI", "NUMERO_BI"), new AuxCriteriaBuilder.Pair("descricao", "DESCRICAO"), new AuxCriteriaBuilder.Pair("observacao", "OBSERVACAO"));
        Join jBIInf = crit.join("businessIntelligenceInf");
        Join jBNodos = jBIInf.join("nodos", JoinType.LEFT);
        Join jNodos = jBNodos.join("nodo");
        Join jBGrupos = jBIInf.join("grupos", JoinType.LEFT);
        Join jGrupos = jBGrupos.join("grupo");
        Join jBEmpresas = jBIInf.join("empresas", JoinType.LEFT);
        Join jEmpresas = jBEmpresas.join("empresa", JoinType.LEFT);
        if (TMethods.isWithData((Number)idGrupo)) {
            crit.equal((From)jGrupos, "identificador", idGrupo);
        }
        if (TMethods.isWithData((Number)idNodo)) {
            crit.equal((From)jNodos, "identificador", idNodo);
        }
        crit.or(crit.getEqual((From)jBIInf, "filtrarEmpresa", (short)0), crit.getEqual((From)jEmpresas, "identificador", idEmpresa));
        crit.orderAsc("descricao");
        crit.setDistinct(true);
        List<Map<String, Object>> tmp = crit.getResultMap();
        LinkedList<BusinessIntelligenceTemp> ret = new LinkedList<BusinessIntelligenceTemp>();
        for (Map<String, Object> h : tmp) {
            String descricao = (String)h.get("DESCRICAO");
            String observacao = (String)h.get("OBSERVACAO");
            Long id = (Long)h.get("ID_BI");
            Long numero = (Long)h.get("NUMERO_BI");
            BusinessIntelligenceTemp b = new BusinessIntelligenceTemp(Boolean.valueOf(false));
            b.setDescricao(descricao);
            b.setNumeroBI(numero);
            b.setIdentificador(id);
            b.setObservacao(observacao);
            ret.add(b);
        }
        return ret;
    }

    public List<BusinessIntelligence> findBIsIdUsuario(Long idUsuario) {
        Query q = this.query("select distinct b from BusinessIntelligence b inner join b.businessIntelligenceInf bi inner join bi.gruposb g inner join bg.grupo g inner join g.usuarios u where u.identificador=:idUsuario order by b.descricao");
        q.setLong("idUsuario", idUsuario.longValue());
        return q.list();
    }

    @Override
    public boolean delete(BusinessIntelligence entity) {
        DaoBusinessIntelligencePrefImpl prefs = (DaoBusinessIntelligencePrefImpl)ConfApplicationContext.getBean(DaoBusinessIntelligencePrefImpl.class);
        prefs.deletePrefs(entity);
        boolean aux = super.delete(entity);
        return aux;
    }

    public String hqlToSql(String hqlQueryString) {
        ASTQueryTranslatorFactory translatorFactory = new ASTQueryTranslatorFactory();
        SessionFactoryImplementor factory = this.getSessionFactory().getSessionFactory();
        QueryTranslator translator = translatorFactory.createQueryTranslator(hqlQueryString, hqlQueryString, Collections.EMPTY_MAP, factory, null);
        translator.compile(Collections.EMPTY_MAP, false);
        String sqlString = translator.getSQLString();
        return sqlString;
    }

    public List<DTOBusinessIntelligenceItem> getVersoesLocaisBI() {
        AuxCriteriaBuilder crit = this.queryBuilder(this.getEntityClass());
        crit.select(new AuxCriteriaBuilder.Pair("identificador", "ID_BI"), new AuxCriteriaBuilder.Pair("numeroBI", "NUMERO_BI"), new AuxCriteriaBuilder.Pair("descricao", "DESCRICAO"), new AuxCriteriaBuilder.Pair("observacao", "OBSERVACAO"), new AuxCriteriaBuilder.Pair("numeroVersao", "NUMERO_VERSAO"), new AuxCriteriaBuilder.Pair("numeroVersaoRep", "NUMERO_VERSAO_REP"), new AuxCriteriaBuilder.Pair("serialLocalBI", "SERIAL_LOCAL"), new AuxCriteriaBuilder.Pair("ativo", "ATIVO"), new AuxCriteriaBuilder.Pair("motivoInativacao", "MOTIVO_INATIVACAO"));
        crit.where(crit.equal("naoVersionarAuto", (short)0));
        List<Map<String, Object>> data = crit.getResultMap();
        LinkedList<DTOBusinessIntelligenceItem> temp = new LinkedList<DTOBusinessIntelligenceItem>();
        for (Map<String, Object> m : data) {
            String descricao = (String)m.get("DESCRICAO");
            String observacao = (String)m.get("OBSERVACAO");
            Long identificador = (Long)m.get("ID_BI");
            Long numeroBI = (Long)m.get("NUMERO_BI");
            Long numeroVersao = (Long)m.get("NUMERO_VERSAO");
            Long numeroVersaoRep = (Long)m.get("NUMERO_VERSAO_REP");
            String serialLocalBI = (String)m.get("SERIAL_LOCAL");
            Short ativo = (Short)m.get("ATIVO");
            String motivoInativacao = (String)m.get("MOTIVO_INATIVACAO");
            Optional<DTOBusinessIntelligenceItem> found = temp.stream().filter(i -> TMethods.isEquals((Object)i.getSerialLocalBI(), (Object)serialLocalBI)).findFirst();
            DTOBusinessIntelligenceItem item = found.isPresent() ? found.get() : new DTOBusinessIntelligenceItem();
            item.setDescricao(descricao);
            item.setNumeroControle(numeroBI);
            item.setSerialLocalBI(serialLocalBI);
            DTOBusinessIntelligenceItemDet det = new DTOBusinessIntelligenceItemDet();
            det.setAtivo(ativo);
            det.setDescricao(descricao);
            det.setIdentificador(identificador);
            det.setMotivoInativacao(motivoInativacao);
            det.setNumeroVersao(numeroVersao);
            det.setNumeroVersaoRep(numeroVersaoRep);
            det.setObservacao(observacao);
            item.getDetalhes().add(det);
            temp.add(item);
        }
        return temp;
    }

    public List<GenericMapValues<DadosBILocais>> getBILocais() {
        Query c = this.query("select b.serialLocalBI,b.numeroBI,b.numeroVersaoRep,max(b.numeroVersao),b.identificador,b.descricao,b.observacao from BusinessIntelligence b where b.ativo =1 and b.naoVersionarAuto<>1 and b.numeroBI>0 group by b.numeroBI,b.serialLocalBI,b.numeroVersaoRep,b.numeroVersao,b.identificador,b.descricao,b.observacao");
        List found = c.getResultList();
        LinkedList<GenericMapValues<DadosBILocais>> ret = new LinkedList<GenericMapValues<DadosBILocais>>();
        for (Object[] obj : found) {
            GenericMapValues<DadosBILocais> d = new GenericMapValues<DadosBILocais>();
            d.putString(DadosBILocais.SERIAL_BI, (String)obj[0]);
            d.putString(DadosBILocais.NUMERO_BI, String.valueOf(obj[1]));
            d.putLong(DadosBILocais.VERSAO_REP, (Long)obj[2]);
            d.putLong(DadosBILocais.VERSAO, (Long)obj[3]);
            d.putLong(DadosBILocais.IDENTIFICADOR, (Long)obj[4]);
            d.putString(DadosBILocais.DESCRICAO, String.valueOf(obj[5]));
            d.putString(DadosBILocais.OBSERVACAO, String.valueOf(obj[6]));
            ret.add(d);
        }
        return ret;
    }

    public List<BusinessIntelligence> getBIsToDiscontinue() {
        ArrayList<BusinessIntelligence> toArq = new ArrayList<BusinessIntelligence>();
        Criteria c = this.criteria();
        ProjectionList p = Projections.projectionList();
        p.add((Projection)Projections.count((String)"numeroVersao"));
        p.add((Projection)Projections.max((String)"numeroVersao"));
        p.add((Projection)Projections.property((String)"numeroBI"));
        p.add((Projection)Projections.groupProperty((String)"numeroBI"));
        c.setProjection((Projection)p);
        List result = c.list();
        for (Object[] fields : result) {
            if (fields.length <= 1) continue;
            Long ocurrences = (Long)fields[0];
            Long lastBIVersion = (Long)fields[1];
            Long numeroBI = (Long)fields[2];
            if (ocurrences <= 1L || numeroBI == null) continue;
            Criteria cb = this.criteria();
            cb.add(this.notEqual("numeroVersao", lastBIVersion));
            cb.add(this.eq("numeroBI", numeroBI));
            toArq.addAll(cb.list());
        }
        return toArq;
    }

    public BusinessIntelligence getBI(Long numeroBI, Long versaoRep, Long versao) {
        return (BusinessIntelligence)this.toUnique(this.restrictions(this.criteria(), this.eq("numeroBI", numeroBI), this.eq("numeroVersaoRep", versaoRep), this.eq("numeroVersao", versao)));
    }
}

