/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl.businessintelligence;

import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligencePref;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoBusinessIntelligencePrefImpl
extends DaoGenericEntityImpl<BusinessIntelligencePref, Long> {
    public List<BusinessIntelligencePref> getAllByBIGlobal(BusinessIntelligence businessIntelligence) {
        return this.toList(this.order(this.restrictions(this.eq("businessIntelligence", businessIntelligence), this.eq("tipo", EnumConstBusinessIntelligencePref.PREF_GLOBAL.value)), "descricao"));
    }

    public List<BusinessIntelligencePref> getAllByBIAndUser(BusinessIntelligence businessIntelligence, Usuario user) {
        return this.toList(this.order(this.restrictions(this.eq("businessIntelligence", businessIntelligence), this.eq("usuario", user), this.eq("tipo", EnumConstBusinessIntelligencePref.PREF_POR_USUARIO.value)), "descricao"));
    }

    public void deletePrefs(BusinessIntelligence entity) {
        Query q = this.query("delete from BusinessIntelligencePref b where b.businessIntelligence =:bi");
        q.setEntity("bi", (Object)entity);
        q.executeUpdate();
    }

    public BusinessIntelligencePref getPrefDefaultUser(BusinessIntelligence bi, Long idUsuario) {
        return (BusinessIntelligencePref)this.toUnique(this.order(this.restrictions(this.eq("businessIntelligence", bi), this.eq("usuario.identificador", idUsuario), this.eq("tipo", EnumConstBusinessIntelligencePref.PREF_POR_USUARIO.value), this.eq("preferenciaPadrao", (short)1)), "descricao"));
    }

    public BusinessIntelligencePref getPrefDefaultGlobal(Long idBI) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jBI = builder.join("businessIntelligence");
        builder.equal((From)jBI, "identificador", idBI);
        builder.equal("tipo", EnumConstBusinessIntelligencePref.PREF_GLOBAL.getValue());
        builder.equal("preferenciaPadrao", (short)1);
        builder.orderAsc("descricao");
        return (BusinessIntelligencePref)builder.getUniqueResult();
    }

    public List<BusinessIntelligencePref> getPrefsBIUsuario(Long idBI, Long idUsuarioLogado) {
        Criteria crit = this.criteria();
        crit.add(this.eq("businessIntelligence.identificador", idBI));
        crit.add(this.eq("usuario.identificador", idUsuarioLogado));
        return crit.list();
    }

    public List<BusinessIntelligencePref> getPrefDefaultGlobal(Long idBI, EnumConstTipoSistema tipo) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jBI = builder.join("businessIntelligence");
        builder.equal((From)jBI, "identificador", idBI);
        builder.equal("tipo", EnumConstBusinessIntelligencePref.PREF_GLOBAL.getValue());
        builder.orderAsc("descricao");
        return builder.getResultEnt();
    }
}

