/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl.database;

import com.touchcomp.basementor.model.impl.MapaVinculacoesRegistrosBD;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementortools.tools.string.ToolString;
import com.touchcomp.touchvomodel.temp.database.DTODBIndex;
import com.touchcomp.touchvomodel.temp.database.DTODBProcess;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoFirebird
extends DaoGenericImpl {
    public List<DTODBIndex> getIndex() {
        NativeQuery q = this.sqlQuery("select r.rdb$index_name as INDEX_NAME, r.rdb$relation_name as TABLE_RELATION from rdb$indices  r");
        List data = q.list();
        LinkedList<DTODBIndex> ret = new LinkedList<DTODBIndex>();
        for (Object[] objects : data) {
            ret.add(new DTODBIndex((String)objects[0], (String)objects[1]));
        }
        return ret;
    }

    public List<DTODBIndex> getIndex(String table) {
        NativeQuery q = this.sqlQuery("select r.rdb$index_name as INDEX_NAME, r.rdb$relation_name as TABLE_RELATION from rdb$indices r where r.rdb$relation_name = :table");
        q.setString("table", table);
        List data = q.list();
        LinkedList<DTODBIndex> ret = new LinkedList<DTODBIndex>();
        for (Object[] objects : data) {
            ret.add(new DTODBIndex((String)objects[0], (String)objects[1]));
        }
        return ret;
    }

    public void recomputeIndex(List<DTODBIndex> indexes) {
        for (DTODBIndex ind : indexes) {
            NativeQuery q = this.sqlQuery("ALTER INDEX " + ToolString.trim((String)ind.getIndexName()) + " ACTIVE;");
            q.executeUpdate();
        }
        this.getSession().flush();
    }

    public int cancelRunningProcess(Long id) {
        NativeQuery q = this.sqlQuery(" delete from mon$statements\n where mon$attachment_id <> current_connection and mon$attachment_id=:id");
        q.setLong("id", id.longValue());
        return q.executeUpdate();
    }

    public List<DTODBProcess> getRunningProcess() {
        NativeQuery q = this.sqlQuery(" SELECT cast(ATT.MON$USER as varchar(500)) as F_USER,\n      cast(ATT.MON$REMOTE_ADDRESS as varchar(500)) AS F_ADDRESS,\n      cast(STMT.MON$SQL_TEXT as varchar(25000)) AS F_QUERY_STR,\n      cast(STMT.MON$TIMESTAMP as timestamp) as F_DATA_INICIO,\n      STMT.MON$ATTACHMENT_ID AS F_ID_STATEMENT ,\n      MON$REMOTE_HOST as F_REMOTE_HOST,\n      MON$REMOTE_OS_USER as F_REMOTE_OS_USER,\n      MON$ATTACHMENT_NAME AS F_ATTACHMENT_NAME\n FROM MON$ATTACHMENTS ATT\n   JOIN MON$STATEMENTS STMT\n     ON ATT.MON$ATTACHMENT_ID = STMT.MON$ATTACHMENT_ID\n WHERE ATT.MON$ATTACHMENT_ID <> CURRENT_CONNECTION\n   AND STMT.MON$STATE = 1     ");
        List data = q.list();
        LinkedList<DTODBProcess> ret = new LinkedList<DTODBProcess>();
        for (Object[] objects : data) {
            DTODBProcess d = new DTODBProcess();
            d.setUsuario((String)objects[0]);
            d.setEnderecoIP((String)objects[1]);
            d.setQueryComando((String)objects[2]);
            d.setDataInicio((Date)objects[3]);
            d.setIdProcesso(Long.valueOf(((BigInteger)objects[4]).longValue()));
            d.setNomeHost((String)objects[5]);
            d.setUsuarioHost((String)objects[6]);
            d.setNomeConexaoBanco((String)objects[7]);
            ret.add(d);
        }
        return ret;
    }

    public void desvinculaRegistrosForeignKeys(String table) {
        NativeQuery q = this.sqlQuery("execute procedure PROCTO_DESVINCULA_DADOS_TAB(:table_name);");
        q.setParameter("table_name", (Object)table);
        q.executeUpdate();
        this.getSession().flush();
    }

    public List<MapaVinculacoesRegistrosBD> getMapaVinculacaoTabela(String table, Long idRegistroPesq) {
        if (idRegistroPesq == null) {
            idRegistroPesq = 0L;
        }
        NativeQuery q = this.sqlQuery("select R_FIELD_NAME,R_TABLE_NAME,R_ID_REGISTRO_VINC,R_ID_REGISTRO,R_PRIMARY_KEY_NAME from PROCTO_MAPA_VINC_DADOS_TAB(:table_name,:id_registro)");
        q.setParameter("table_name", (Object)table);
        q.setParameter("id_registro", (Object)idRegistroPesq);
        List data = q.getResultList();
        LinkedList<MapaVinculacoesRegistrosBD> ret = new LinkedList<MapaVinculacoesRegistrosBD>();
        for (Object[] object : data) {
            String nomeCampo = (String)object[0];
            String tableName = (String)object[1];
            Number idRegVinc = (Number)object[2];
            Number idRegistro = (Number)object[3];
            String nomeCampoChave = (String)object[4];
            MapaVinculacoesRegistrosBD m = new MapaVinculacoesRegistrosBD();
            m.setIdRegistro(Long.valueOf(idRegistro.longValue()));
            m.setTabela(tableName);
            m.setNomeCampo(nomeCampo);
            m.setNomeCampoChavePrimaria(nomeCampoChave);
            m.setIdRegistroVinculado(Long.valueOf(idRegVinc.longValue()));
            ret.add(m);
        }
        return ret;
    }

    public void setDefaultId(Long identificador, List<MapaVinculacoesRegistrosBD> mapaVinculacoes) {
        for (MapaVinculacoesRegistrosBD mapa : mapaVinculacoes) {
            NativeQuery q = this.sqlQuery("update " + mapa.getTabela() + " set " + mapa.getNomeCampo() + "=:idNovoValor where " + mapa.getNomeCampoChavePrimaria() + " = :idRegistro");
            q.setParameter("idNovoValor", (Object)identificador);
            q.setParameter("idRegistro", (Object)mapa.getIdRegistro());
            q.executeUpdate();
        }
    }
}

