/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl.searchentities;

import com.touchcomp.basementor.model.impl.VOSmartSearchClassField;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.SearchClassFieldResItem;
import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.searchclass.CompSmartSearchClass;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.impl.searchentities.BaseFindMethods;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.stringformat.ToolStringFormater;
import com.touchcomp.touchvomodel.web.WebDTOAutoCompleteEntitiesFilterRes;
import com.touchcomp.touchvomodel.web.WebDTOEntityRes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;

public class BaseFindAutoCompRes
extends BaseFindMethods {
    private String ID_ENTITY_FIELD_ALIAS = "identificador";
    final CompSmartSearchClass compSmartSearchClass;
    private static final int MAX_RESULTS_PER_REQUEST = 30;

    public BaseFindAutoCompRes(DaoGenericImpl dao, CompSmartSearchClass compSmartSearchClass) {
        super(dao);
        this.compSmartSearchClass = compSmartSearchClass;
    }

    public List<WebDTOEntityRes> getAutoCompleteEntitiesRes(WebDTOAutoCompleteEntitiesFilterRes searchType, SearchClass search, Nodo nodo, Map<String, Object> defValues, Map<String, String> otherValues) throws ExceptionReflection {
        LinkedList<String> aliases = new LinkedList<String>();
        Criteria c = this.prepareCrit(search, nodo, defValues, aliases, otherValues, searchType.getDesabilitaFiltroFixo(), null);
        List<VOSmartSearchClassField> found = this.compSmartSearchClass.getSearchFieldSmartSearch(search, searchType.getStrTyped());
        if (found == null) {
            throw new ExceptionErroProgramacao("Nao foi configurado(Smart Search) sobre a classe: " + search.getVoClass());
        }
        for (VOSmartSearchClassField f : found) {
            if (!(ToolMethods.isStrWithData((String)f.getTyped()) & f.getTyped().startsWith(" "))) continue;
            f.setFindCrit(EnumConstantsCriteria.ILIKE);
        }
        this.addResFields(c, search, aliases);
        this.addOrderField(c, search, aliases);
        this.addRestrictions(c, aliases, found);
        c.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        if (searchType.getPage() != null) {
            c.setFirstResult(searchType.getPage() * 30);
            c.setMaxResults(30);
        }
        List data = c.list();
        return this.convertArrayToTempEntityRes(search, data);
    }

    private void addResFields(Criteria c, SearchClass search, List<String> aliases) {
        ProjectionList list = Projections.projectionList();
        list.add(Projections.alias((Projection)Projections.id(), (String)this.ID_ENTITY_FIELD_ALIAS));
        for (SearchClassFieldResItem field : search.getSearchFieldsRes().getFields()) {
            if (!ToolMethods.isAffirmative((Number)field.getAtivo())) continue;
            String fieldName = field.getPathFieldDesc();
            if (!ToolMethods.isStrWithData((String)fieldName) && (fieldName = field.getPathField()).lastIndexOf(".") > 0) {
                fieldName = fieldName.substring(fieldName.lastIndexOf(".") + 1);
            }
            if (!TMethods.isStrWithData((String)field.getPathField())) continue;
            String ret = this.createAliases(c, field.getPathField(), "aux", aliases);
            list.add(Projections.alias((Projection)Projections.property((String)ret), (String)fieldName));
        }
        c.setProjection((Projection)list);
    }

    private WebDTOEntityRes convertArrayToTempEntityRes(SearchClass search, Map<String, Object> map) {
        String desc;
        HashMap<String, String> temp = new HashMap<String, String>();
        for (String key : map.keySet()) {
            Object ob = map.get(key);
            if (ob == null) {
                ob = "";
            }
            temp.put(key, String.valueOf(ob));
        }
        String descRes = desc = ToolStringFormater.format((String)search.getSearchFieldsRes().getMascara(), temp);
        if (ToolMethods.isStrWithData((String)search.getSearchFieldsRes().getMascaraRes()) && !ToolMethods.isEquals((Object)search.getSearchFieldsRes().getMascaraRes(), (Object)search.getSearchFieldsRes().getMascara())) {
            descRes = ToolStringFormater.format((String)search.getSearchFieldsRes().getMascaraRes(), temp);
        }
        WebDTOEntityRes t = new WebDTOEntityRes();
        t.setIdentificador(Long.valueOf(((Number)map.get(this.ID_ENTITY_FIELD_ALIAS)).longValue()));
        t.setId(t.getIdentificador());
        t.setDescricao(desc);
        t.setDescricaoRes(descRes);
        t.setOtherValues(temp);
        return t;
    }

    private List<WebDTOEntityRes> convertArrayToTempEntityRes(SearchClass search, List<Map<String, Object>> data) {
        LinkedList<WebDTOEntityRes> res = new LinkedList<WebDTOEntityRes>();
        data.forEach(i -> res.add(this.convertArrayToTempEntityRes(search, (Map<String, Object>)i)));
        return res;
    }

    private void addOrderField(Criteria c, SearchClass search, List<String> aliases) {
        if (!ToolMethods.isStrWithData((String)search.getCampoOrdenacao())) {
            return;
        }
        ProjectionList list = Projections.projectionList();
        list.add(Projections.alias((Projection)Projections.id(), (String)this.ID_ENTITY_FIELD_ALIAS));
        if (TMethods.isStrWithData((String)search.getCampoOrdenacao())) {
            String ret = this.createAliases(c, search.getCampoOrdenacao(), "aux", aliases);
            c.addOrder(Order.asc((String)ret));
        }
    }
}

