/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl.searchentities;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.criteria.EnumConstBaseJunction;
import com.touchcomp.basementor.constants.enums.searchclass.EnumSearchType;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesPesquisaWeb;
import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.SearchClassField;
import com.touchcomp.basementor.model.vo.TokenQrCode;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.components.finder.model.TempSearchClassParams;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.impl.searchentities.BaseFindMethods;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Junction;
import org.hibernate.criterion.Order;

public class BaseFindTokensQrCode
extends BaseFindMethods {
    public BaseFindTokensQrCode(DaoGenericImpl daoGenericImpl) {
        super(daoGenericImpl);
    }

    public Object filter(SearchClass search, TokenQrCode token, String value) throws ExceptionReflection {
        LinkedList<String> aliases = new LinkedList<String>();
        TempSearchClassParams filter = this.getParams(token, value);
        Criteria crit = this.prepareFilterInternal(search, filter, null, aliases, new HashMap<String, Object>(), new HashMap<String, String>(), null);
        Object data = crit.uniqueResult();
        return data;
    }

    private TempSearchClassParams getParams(TokenQrCode token, String value) {
        TempSearchClassParams temp = new TempSearchClassParams();
        temp.setDesabilitaFiltroFixo(EnumConstantsMentorSimNao.SIM.getValue());
        temp.setEntityClass(token.getVoClass());
        temp.setTipoPesquisa(EnumSearchType.PESQUISA_NORMAL);
        TempSearchClassParams.TempSearchClassCriteria filter = new TempSearchClassParams.TempSearchClassCriteria();
        filter.setJunction(EnumConstBaseJunction.CONJUNCTION);
        TempSearchClassParams.TempSearchClassField field = new TempSearchClassParams.TempSearchClassField();
        field.setField(token.getCaminho());
        field.setRestrictionOption(EnumConstantsCriteria.EQUAL);
        field.setValue1(value);
        filter.getSearchFields().add(field);
        temp.getCriteriaJunctions().add(filter);
        return temp;
    }

    private Criteria prepareFilterInternal(SearchClass search, TempSearchClassParams filter, Nodo nodo, List<String> aliases, Map<String, Object> defValues, Map<String, String> otherValues, OpcoesPesquisaWeb opcoesPesquisa) throws ExceptionReflection {
        Criteria crit = this.prepareCrit(search, nodo, defValues, aliases, otherValues, null, null);
        for (TempSearchClassParams.TempSearchClassCriteria criteriaJunction : filter.getCriteriaJunctions()) {
            Junction junction = this.createJunction(criteriaJunction.getJunction());
            crit.add((Criterion)junction);
            for (TempSearchClassParams.TempSearchClassField searchField : criteriaJunction.getSearchFields()) {
                Optional<SearchClassField> found;
                String fieldClass = searchField.getFieldClass();
                if (fieldClass == null && (found = search.getSearchFields().stream().filter(i -> TMethods.isEquals((Object)i.getPathField(), (Object)searchField.getField())).findFirst()).isPresent()) {
                    fieldClass = found.get().getFieldClass();
                }
                this.addRestriction(crit, junction, searchField, "aux", aliases, searchField.getField(), fieldClass);
            }
        }
        crit.addOrder(Order.desc((String)this.getIdPropertyName(this.filterEntityClass(search.getVoClass()))));
        return crit;
    }
}

