/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.data;

import com.antkorwin.xsync.XSync;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.ConfigLogUsuarios;
import com.touchcomp.basementor.model.vo.ConfigLogUsuariosEmpresa;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.NFCeOpcoes;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesCtf;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoManifestoCte;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoTransp;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.OpcoesImpostos;
import com.touchcomp.basementor.model.vo.OpcoesIntegracaoPonto;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.OpcoesManutencEquip;
import com.touchcomp.basementor.model.vo.OpcoesMobile;
import com.touchcomp.basementor.model.vo.OpcoesPCP;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonio;
import com.touchcomp.basementor.model.vo.OpcoesPesquisaWeb;
import com.touchcomp.basementor.model.vo.OpcoesRelacionamento;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementor.model.vo.OpcoesTicketFiscal;
import com.touchcomp.basementor.model.vo.OpcoesValidacao;
import com.touchcomp.basementor.model.vo.OpcoesVendas;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementorexceptions.exceptions.impl.objectnotfound.ExceptionObjectNotFound;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.service.impl.configlogusuarios.ServiceConfigLogUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.configuracaocertificado.ServiceConfiguracaoCertificadoImpl;
import com.touchcomp.basementorservice.service.impl.empresa.ServiceEmpresaImpl;
import com.touchcomp.basementorservice.service.impl.empresarh.ServiceEmpresaRhImpl;
import com.touchcomp.basementorservice.service.impl.grupousuarios.ServiceGrupoUsuariosImpl;
import com.touchcomp.basementorservice.service.impl.nfceopcoes.ServiceNFCeOpcoesImpl;
import com.touchcomp.basementorservice.service.impl.opcoescomprasuprimentos.ServiceOpcoesCompraSuprimentosImpl;
import com.touchcomp.basementorservice.service.impl.opcoescontabeis.ServiceOpcoesContabeisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesctf.ServiceOpcoesCtfImpl;
import com.touchcomp.basementorservice.service.impl.opcoesesocial.ServiceOpcoesESocialImpl;
import com.touchcomp.basementorservice.service.impl.opcoesestoque.ServiceOpcoesEstoqueImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamento.ServiceOpcoesFaturamentoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamentomanifestocte.ServiceOpcoesFaturamentoManifestoCteImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamentonfse.ServiceOpcoesFaturamentoNFSeImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfaturamentotransp.ServiceOpcoesFaturamentoTranspImpl;
import com.touchcomp.basementorservice.service.impl.opcoesfinanceiras.ServiceOpcoesFinanceirasImpl;
import com.touchcomp.basementorservice.service.impl.opcoesgerenciais.ServiceOpcoesGerenciaisImpl;
import com.touchcomp.basementorservice.service.impl.opcoesimpostos.ServiceOpcoesImpostosImpl;
import com.touchcomp.basementorservice.service.impl.opcoesintegracaoponto.ServiceOpcoesIntegracaoPontoImpl;
import com.touchcomp.basementorservice.service.impl.opcoeslocacao.ServiceOpcoesLocacaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesmanutencequip.ServiceOpcoesManutencEquipImpl;
import com.touchcomp.basementorservice.service.impl.opcoesmobile.ServiceOpcoesMobileImpl;
import com.touchcomp.basementorservice.service.impl.opcoespatrimonio.ServiceOpcoesPatrimonioImpl;
import com.touchcomp.basementorservice.service.impl.opcoespcp.ServiceOpcoesPCPImpl;
import com.touchcomp.basementorservice.service.impl.opcoespesquisaweb.ServiceOpcoesPesquisaWebImpl;
import com.touchcomp.basementorservice.service.impl.opcoesrelacionamento.ServiceOpcoesRelacionamentoImpl;
import com.touchcomp.basementorservice.service.impl.opcoessistema.ServiceOpcoesSistemaImpl;
import com.touchcomp.basementorservice.service.impl.opcoesticketfiscal.ServiceOpcoesTicketFiscalImpl;
import com.touchcomp.basementorservice.service.impl.opcoesvalidacao.ServiceOpcoesValidacaoImpl;
import com.touchcomp.basementorservice.service.impl.opcoesvendas.ServiceOpcoesVendasImpl;
import com.touchcomp.basementorservice.service.impl.usuario.ServiceUsuarioImpl;
import com.touchcomp.basementorservice.service.impl.usuariobasico.ServiceUsuarioBasicoImpl;
import com.touchcomp.basementorservice.service.impl.wmsopcoes.ServiceWmsOpcoesImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.touchvomodel.vo.grupo.web.DTONodoGrupo;
import com.touchcomp.touchvomodel.vo.grupo.web.DTONodoGrupoList;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataCacheService
implements InterfaceStaticObjects {
    @Autowired
    private XSync<String> xSync;
    private final Map<Long, Grupo> mapGrupoUsuarios = new HashMap<Long, Grupo>();
    private final Map<Long, Empresa> mapEmpresas = new HashMap<Long, Empresa>();
    private final Map<Long, OpcoesCompraSuprimentos> mapOpcoesCompra = new HashMap<Long, OpcoesCompraSuprimentos>();
    private final Map<Long, OpcoesFinanceiras> mapOpcoesFinanceiras = new HashMap<Long, OpcoesFinanceiras>();
    private final Map<Long, OpcoesMobile> mapOpcoesMobile = new HashMap<Long, OpcoesMobile>();
    private final Map<Long, OpcoesEstoque> mapOpcoesEstoque = new HashMap<Long, OpcoesEstoque>();
    private final Map<Long, WmsOpcoes> mapWmsOpcoes = new HashMap<Long, WmsOpcoes>();
    private final Map<Long, OpcoesFaturamento> mapOpcoesFaturamento = new HashMap<Long, OpcoesFaturamento>();
    private final Map<Long, OpcoesLocacao> mapOpcoesLocacao = new HashMap<Long, OpcoesLocacao>();
    private final Map<Long, ConfiguracaoCertificado> mapCertificados = new HashMap<Long, ConfiguracaoCertificado>();
    private final Map<Long, OpcoesRelacionamento> mapOpcoesRelacionamento = new HashMap<Long, OpcoesRelacionamento>();
    private final Map<Long, OpcoesFaturamentoNFSe> mapOpcoesFatNFSe = new HashMap<Long, OpcoesFaturamentoNFSe>();
    private final Map<Long, OpcoesFaturamentoTransp> mapOpcoesTransp = new HashMap<Long, OpcoesFaturamentoTransp>();
    private final Map<Long, OpcoesVendas> mapOpcoesVendas = new HashMap<Long, OpcoesVendas>();
    private final Map<Long, OpcoesPCP> mapOpcoesPCP = new HashMap<Long, OpcoesPCP>();
    private final Map<Long, OpcoesManutencEquip> mapOpcoesManutencEquip = new HashMap<Long, OpcoesManutencEquip>();
    private final Map<Long, OpcoesFaturamentoManifestoCte> mapOpcoesFatManCTe = new HashMap<Long, OpcoesFaturamentoManifestoCte>();
    private final Map<Long, OpcoesPatrimonio> mapOpcoesPatrimonio = new HashMap<Long, OpcoesPatrimonio>();
    private final Map<Long, OpcoesGerenciais> mapOpcoesGerenciais = new HashMap<Long, OpcoesGerenciais>();
    private final Map<Long, OpcoesContabeis> mapOpcoesContabeis = new HashMap<Long, OpcoesContabeis>();
    private final Map<Long, NFCeOpcoes> mapOpcoesNFCe = new HashMap<Long, NFCeOpcoes>();
    private final Map<Long, OpcoesImpostos> mapOpcoesImpostos = new HashMap<Long, OpcoesImpostos>();
    private final Map<Long, OpcoesTicketFiscal> mapOpcoesTicketFiscal = new HashMap<Long, OpcoesTicketFiscal>();
    private final Map<Long, OpcoesESocial> mapOpcoesEsocial = new HashMap<Long, OpcoesESocial>();
    private final Map<Long, OpcoesSistema> mapOpcoesSistema = new HashMap<Long, OpcoesSistema>();
    private final Map<Long, OpcoesValidacao> mapOpcoesValidacao = new HashMap<Long, OpcoesValidacao>();
    private final Map<Long, ConfigLogUsuarios> mapConfigLogUsuarios = new HashMap<Long, ConfigLogUsuarios>();
    private final Map<Long, OpcoesIntegracaoPonto> mapOpcoesIntegracaoPonto = new HashMap<Long, OpcoesIntegracaoPonto>();
    private final Map<Long, OpcoesCtf> mapOpcoesCtf = new HashMap<Long, OpcoesCtf>();
    private final Map<Long, EmpresaRh> mapEmpresaRh = new HashMap<Long, EmpresaRh>();
    private final Map<Long, List<DTONodoGrupoList>> mapDTOGrupo = new HashMap<Long, List<DTONodoGrupoList>>();
    private final Map<Long, Usuario> mapUsuario = new HashMap<Long, Usuario>();
    private final Map<Long, UsuarioBasico> mapUsuarioBasico = new HashMap<Long, UsuarioBasico>();
    private final Map<Long, OpcoesPesquisaWeb> mapOpcoesPesquisaWeb = new HashMap<Long, OpcoesPesquisaWeb>();
    private final Long DEFAULT_ID_FAKE = 1L;

    public Map<Long, UsuarioBasico> getMapUsuarioBasico() {
        return this.mapUsuarioBasico;
    }

    public Map<Long, OpcoesPesquisaWeb> getMapOpcoesPesquisaWeb() {
        return this.mapOpcoesPesquisaWeb;
    }

    public Map<String, Map> getAllCachesMap() {
        HashMap<String, Map> r = new HashMap<String, Map>();
        r.put(this.getCacheName(Grupo.class), this.getMapGrupoUsuarios());
        r.put(this.getCacheName(DTONodoGrupo.class), this.getMapDTOGrupo());
        r.put(this.getCacheName(Empresa.class), this.getMapEmpresas());
        r.put(this.getCacheName(OpcoesCompraSuprimentos.class), this.getMapOpcoesCompra());
        r.put(this.getCacheName(OpcoesFinanceiras.class), this.getMapOpcoesFinanceiras());
        r.put(this.getCacheName(OpcoesMobile.class), this.getMapOpcoesMobile());
        r.put(this.getCacheName(OpcoesEstoque.class), this.getMapOpcoesEstoque());
        r.put(this.getCacheName(WmsOpcoes.class), this.getMapWmsOpcoes());
        r.put(this.getCacheName(OpcoesFaturamento.class), this.getMapOpcoesFaturamento());
        r.put(this.getCacheName(OpcoesLocacao.class), this.getMapOpcoesLocacao());
        r.put(this.getCacheName(ConfiguracaoCertificado.class), this.getMapCertificados());
        r.put(this.getCacheName(OpcoesRelacionamento.class), this.getMapOpcoesRelacionamento());
        r.put(this.getCacheName(OpcoesFaturamentoNFSe.class), this.getMapOpcoesFatNFSe());
        r.put(this.getCacheName(OpcoesFaturamentoTransp.class), this.getMapOpcoesTransp());
        r.put(this.getCacheName(OpcoesVendas.class), this.getMapOpcoesVendas());
        r.put(this.getCacheName(OpcoesPCP.class), this.getMapOpcoesPCP());
        r.put(this.getCacheName(OpcoesManutencEquip.class), this.getMapOpcoesManutencEquip());
        r.put(this.getCacheName(OpcoesFaturamentoManifestoCte.class), this.getMapOpcoesFatManCTe());
        r.put(this.getCacheName(OpcoesPatrimonio.class), this.getMapOpcoesPatrimonio());
        r.put(this.getCacheName(OpcoesGerenciais.class), this.getMapOpcoesGerenciais());
        r.put(this.getCacheName(OpcoesContabeis.class), this.getMapOpcoesContabeis());
        r.put(this.getCacheName(NFCeOpcoes.class), this.getMapOpcoesNFCe());
        r.put(this.getCacheName(OpcoesImpostos.class), this.getMapOpcoesImpostos());
        r.put(this.getCacheName(OpcoesTicketFiscal.class), this.getMapOpcoesTicketFiscal());
        r.put(this.getCacheName(OpcoesESocial.class), this.getMapOpcoesEsocial());
        r.put(this.getCacheName(OpcoesSistema.class), this.getMapOpcoesSistema());
        r.put(this.getCacheName(OpcoesValidacao.class), this.getMapOpcoesValidacao());
        r.put(this.getCacheName(OpcoesIntegracaoPonto.class), this.getMapOpcoesIntegracaoPonto());
        r.put(this.getCacheName(EmpresaRh.class), this.getMapEmpresaRh());
        r.put(this.getCacheName(OpcoesCtf.class), this.getMapOpcoesCtf());
        r.put(this.getCacheName(ConfigLogUsuarios.class), this.getMapConfigLogUsuarios());
        r.put(this.getCacheName(Usuario.class), this.getMapUsuario());
        r.put(this.getCacheName(UsuarioBasico.class), this.getMapUsuarioBasico());
        r.put(this.getCacheName(OpcoesPesquisaWeb.class), this.getMapOpcoesPesquisaWeb());
        return r;
    }

    public boolean reloadCache(String name) {
        Map aux = this.getAllCachesMap().get(name);
        if (aux != null) {
            aux.clear();
            return true;
        }
        return false;
    }

    public boolean reloadCache(Class clazz) {
        return this.reloadCache(this.getCacheName(clazz));
    }

    public boolean reloadCache(Class clazz, Long id) {
        Map aux = this.getAllCachesMap().get(this.getCacheName(clazz));
        if (aux != null) {
            aux.remove(id);
            return true;
        }
        return false;
    }

    public boolean reloadCache(Class clazz, Serializable key) {
        Map m = this.getAllCachesMap().get(this.getCacheName(clazz));
        if (m != null) {
            m.remove(key);
            return true;
        }
        return false;
    }

    public boolean reloadCache() {
        this.getMapGrupoUsuarios().clear();
        this.getDTOUserGroup().clear();
        this.getMapOpcoesCompra().clear();
        this.getMapEmpresas().clear();
        this.getMapOpcoesLocacao().clear();
        this.getMapOpcoesFinanceiras().clear();
        this.getMapOpcoesMobile().clear();
        this.getMapOpcoesEstoque().clear();
        this.getMapCertificados().clear();
        this.getMapWmsOpcoes().clear();
        this.getMapOpcoesFaturamento().clear();
        this.getMapOpcoesSistema().clear();
        this.getMapOpcoesValidacao().clear();
        this.getMapOpcoesFatNFSe().clear();
        this.getMapOpcoesTransp().clear();
        this.getMapOpcoesVendas().clear();
        this.getMapOpcoesPCP().clear();
        this.getMapOpcoesManutencEquip().clear();
        this.getMapOpcoesFatManCTe().clear();
        this.getMapOpcoesPatrimonio().clear();
        this.getMapOpcoesGerenciais().clear();
        this.getMapOpcoesContabeis().clear();
        this.getMapOpcoesNFCe().clear();
        this.getMapOpcoesImpostos().clear();
        this.getMapOpcoesTicketFiscal().clear();
        this.getMapOpcoesEsocial().clear();
        this.getMapConfigLogUsuarios().clear();
        this.getMapOpcoesIntegracaoPonto().clear();
        this.getMapEmpresaRh().clear();
        this.getMapOpcoesCtf().clear();
        this.getMapUsuario().clear();
        this.getMapUsuarioBasico().clear();
        this.getMapOpcoesPesquisaWeb().clear();
        this.loadBasicCache();
        return true;
    }

    public Usuario getUsuario(Long idUsuario) {
        Usuario found = this.getMapUsuario().get(idUsuario);
        if (found != null) {
            return found;
        }
        this.xSync.execute((Object)String.valueOf(idUsuario), () -> this.getMapUsuario().put(idUsuario, this.getServiceUsuarioImpl().getEager(idUsuario)));
        return this.getMapUsuario().get(idUsuario);
    }

    public UsuarioBasico getUsuarioBasico(Long idUsuario) {
        UsuarioBasico found = this.getMapUsuarioBasico().get(idUsuario);
        if (found != null) {
            return found;
        }
        this.xSync.execute((Object)String.valueOf(idUsuario), () -> this.getMapUsuarioBasico().put(idUsuario, this.getServiceUsuarioBasicoImpl().getEager(idUsuario)));
        return this.getMapUsuarioBasico().get(idUsuario);
    }

    public Grupo getUserGroup(Long idGrupoUsuario) {
        Grupo found = this.getMapGrupoUsuarios().get(idGrupoUsuario);
        if (found != null) {
            return found;
        }
        this.xSync.execute((Object)String.valueOf(idGrupoUsuario), () -> this.getMapGrupoUsuarios().put(idGrupoUsuario, (Grupo)this.getServiceGrupoUsuariosImpl().get(idGrupoUsuario)));
        return this.getMapGrupoUsuarios().get(idGrupoUsuario);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DTONodoGrupoList> getUserGroupPermissionsDTO(Long idGrupoUsuario) {
        Grupo found = this.getUserGroup(idGrupoUsuario);
        List<DTONodoGrupoList> data = this.getDTOUserGroup().get(idGrupoUsuario);
        if (data != null) {
            return data;
        }
        if (found == null) {
            return new LinkedList<DTONodoGrupoList>();
        }
        Grupo grupo = found;
        synchronized (grupo) {
            data = this.getServiceGrupoUsuariosImpl().getNodosDTO(idGrupoUsuario);
            this.getDTOUserGroup().put(idGrupoUsuario, data);
        }
        return data;
    }

    public OpcoesSistema getOpcoesSistema() {
        if (this.getMapOpcoesSistema().get(this.getDEFAULT_ID_FAKE()) != null) {
            return this.getMapOpcoesSistema().get(this.getDEFAULT_ID_FAKE());
        }
        this.getMapOpcoesSistema().put(this.getDEFAULT_ID_FAKE(), (OpcoesSistema)this.getServiceOpcoesSistemaImpl().getFirst());
        return this.getMapOpcoesSistema().get(this.getDEFAULT_ID_FAKE());
    }

    public OpcoesPesquisaWeb getOpcoesPesquisaWeb() {
        if (this.getMapOpcoesPesquisaWeb().get(this.getDEFAULT_ID_FAKE()) != null) {
            return this.getMapOpcoesPesquisaWeb().get(this.getDEFAULT_ID_FAKE());
        }
        this.getMapOpcoesPesquisaWeb().put(this.getDEFAULT_ID_FAKE(), (OpcoesPesquisaWeb)this.getServiceOpcoesPesquisaWebImpl().getFirst());
        return this.getMapOpcoesPesquisaWeb().get(this.getDEFAULT_ID_FAKE());
    }

    public OpcoesCompraSuprimentos getOpcoesCompraSuprimentos(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesCompraSuprimentos(empresa.getIdentificador());
    }

    public OpcoesCompraSuprimentos getOpcoesCompraSuprimentos(Long idEmpresa) {
        OpcoesCompraSuprimentos found = this.getMapOpcoesCompra().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesCompraSuprimentosImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesCompra().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0804.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0804.001", new Object[]{idEmpresa}));
    }

    public OpcoesValidacao getOpcoesValidacao() {
        if (this.getMapOpcoesValidacao().get(this.getDEFAULT_ID_FAKE()) != null) {
            return this.getMapOpcoesValidacao().get(this.getDEFAULT_ID_FAKE());
        }
        this.getMapOpcoesValidacao().put(this.getDEFAULT_ID_FAKE(), (OpcoesValidacao)this.getServiceOpcoesValidacaoEmpImpl().getFirst());
        return this.getMapOpcoesValidacao().get(this.getDEFAULT_ID_FAKE());
    }

    public OpcoesGerenciais getOpcoesGerenciais(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesGerenciais(empresa.getIdentificador());
    }

    public OpcoesGerenciais getOpcoesGerenciais(Long idEmpresa) {
        OpcoesGerenciais found = this.getMapOpcoesGerenciais().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesGerenciaisImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesGerenciais().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1512.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1512.001", new Object[]{idEmpresa}));
    }

    public OpcoesFaturamentoNFSe getOpcoesFaturamentoNFSe(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesFaturamentoNFSe(empresa.getIdentificador());
    }

    public OpcoesFaturamentoNFSe getOpcoesFaturamentoNFSe(Long idEmpresa) {
        OpcoesFaturamentoNFSe found = this.getMapOpcoesFatNFSe().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesFaturamentoNFSeImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesFatNFSe().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0763.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0763.001", new Object[]{idEmpresa}));
    }

    public OpcoesFaturamentoTransp getOpcoesFaturamentoTransporte(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesFaturamentoTransporte(empresa.getIdentificador());
    }

    public OpcoesFaturamentoTransp getOpcoesFaturamentoTransporte(Long idEmpresa) {
        OpcoesFaturamentoTransp found = this.getMapOpcoesTransp().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesFaturamentoTranspImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesTransp().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0483.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0483.001", new Object[]{idEmpresa}));
    }

    public OpcoesVendas getOpcoesVendas(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesVendas(empresa.getIdentificador());
    }

    public OpcoesVendas getOpcoesVendas(Long idEmpresa) {
        OpcoesVendas found = this.getMapOpcoesVendas().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesVendasImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesVendas().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0112.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0112.001", new Object[]{idEmpresa}));
    }

    public OpcoesIntegracaoPonto getOpcoesIntegracaoPonto(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesIntegracaoPonto(empresa.getIdentificador());
    }

    public OpcoesIntegracaoPonto getOpcoesIntegracaoPonto(Long idEmpresa) {
        OpcoesIntegracaoPonto found = this.getMapOpcoesIntegracaoPonto().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesIntegracaoPontoImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesIntegracaoPonto().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1933.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1933.001", new Object[]{idEmpresa}));
    }

    public EmpresaRh getEmpresaRh(Empresa empresa) {
        return empresa == null ? null : this.getEmpresaRh(empresa.getIdentificador());
    }

    public EmpresaRh getEmpresaRh(Long idEmpresa) {
        EmpresaRh found = this.getMapEmpresaRh().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceEmpresaRhImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapEmpresaRh().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1933.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1933.001", new Object[]{idEmpresa}));
    }

    public OpcoesPCP getOpcoesPCP(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesPCP(empresa.getIdentificador());
    }

    public OpcoesPCP getOpcoesPCP(Long idEmpresa) {
        OpcoesPCP found = this.getMapOpcoesPCP().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesPCPImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesPCP().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0112.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0112.001", new Object[]{idEmpresa}));
    }

    public OpcoesManutencEquip getOpcoesManutencaoEquip(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesManutencaoEquip(empresa.getIdentificador());
    }

    public OpcoesManutencEquip getOpcoesManutencaoEquip(Long idEmpresa) {
        OpcoesManutencEquip found = this.getMapOpcoesManutencEquip().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesManutencEquipImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesManutencEquip().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0787.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0787.001", new Object[]{idEmpresa}));
    }

    public OpcoesFaturamentoManifestoCte getOpcoesFaturamentoManifestoCte(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesFaturamentoManifestoCte(empresa.getIdentificador());
    }

    public OpcoesFaturamentoManifestoCte getOpcoesFaturamentoManifestoCte(Long idEmpresa) {
        OpcoesFaturamentoManifestoCte found = this.getMapOpcoesFatManCTe().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesFaturamentoManifestoCteImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesFatManCTe().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0931.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0931.001", new Object[]{idEmpresa}));
    }

    public OpcoesPatrimonio getOpcoesPatrimonio(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesPatrimonio(empresa.getIdentificador());
    }

    public OpcoesPatrimonio getOpcoesPatrimonio(Long idEmpresa) {
        OpcoesPatrimonio found = this.getMapOpcoesPatrimonio().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesPatrimonioImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesPatrimonio().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1122.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1122.001", new Object[]{idEmpresa}));
    }

    public OpcoesContabeis getOpcoesContabeis(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesContabeis(empresa.getIdentificador());
    }

    public OpcoesContabeis getOpcoesContabeis(Long idEmpresa) {
        OpcoesContabeis found = this.getMapOpcoesContabeis().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesContabeisImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesContabeis().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1757.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1757.001", new Object[]{idEmpresa}));
    }

    public NFCeOpcoes getOpcoesNFCe(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesNFCe(empresa.getIdentificador());
    }

    public NFCeOpcoes getOpcoesNFCe(Long idEmpresa) {
        NFCeOpcoes found = this.getMapOpcoesNFCe().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceNFCeOpcoesImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesNFCe().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1784.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1784.001", new Object[]{idEmpresa}));
    }

    public OpcoesImpostos getOpcoesImpostos(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesImpostos(empresa.getIdentificador());
    }

    public OpcoesImpostos getOpcoesImpostos(Long idEmpresa) {
        OpcoesImpostos found = this.getMapOpcoesImpostos().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesImpostosImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesImpostos().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1813.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1813.001", new Object[]{idEmpresa}));
    }

    public OpcoesTicketFiscal getOpcoesTicketFiscal(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesTicketFiscal(empresa.getIdentificador());
    }

    public OpcoesTicketFiscal getOpcoesTicketFiscal(Long idEmpresa) {
        OpcoesTicketFiscal found = this.getMapOpcoesTicketFiscal().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesTicketFiscalImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesTicketFiscal().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1820.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1820.001", new Object[]{idEmpresa}));
    }

    public OpcoesESocial getOpcoesESocial(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesESocial(empresa.getIdentificador());
    }

    public OpcoesESocial getOpcoesESocial(Long idEmpresa) {
        OpcoesESocial found = this.getMapOpcoesEsocial().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesESocialImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesEsocial().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1660.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1660.001", new Object[]{idEmpresa}));
    }

    public OpcoesFaturamento getOpcoesFaturamento(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesFaturamento(empresa.getIdentificador());
    }

    public OpcoesFaturamento getOpcoesFaturamento(Long idEmpresa) {
        OpcoesFaturamento found = this.getMapOpcoesFaturamento().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesFaturamentoImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesFaturamento().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0107.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0107.001", new Object[]{idEmpresa}));
    }

    public OpcoesLocacao getOpcoesLocacao(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesLocacao(empresa.getIdentificador());
    }

    public OpcoesLocacao getOpcoesLocacao(Long idEmpresa) {
        OpcoesLocacao found = this.getMapOpcoesLocacao().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesLocacaoImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesLocacao().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1264.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1264.001", new Object[]{idEmpresa}));
    }

    public ConfiguracaoCertificado getConfiguracaoCertificado(Empresa empresa) {
        return empresa == null ? null : this.getConfiguracaoCertificado(empresa.getIdentificador());
    }

    public ConfiguracaoCertificado getConfiguracaoCertificado(Long idEmpresa) {
        ConfiguracaoCertificado found = this.getMapCertificados().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceConfiguracaoCertificadoImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapCertificados().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1396.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1396.001", new Object[]{idEmpresa}));
    }

    public WmsOpcoes getWmsOpcoes(Empresa empresa) {
        return empresa == null ? null : this.getWmsOpcoes(empresa.getIdentificador());
    }

    public WmsOpcoes getWmsOpcoes(Long idEmpresa) {
        WmsOpcoes found = this.getMapWmsOpcoes().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceWmsOpcoesImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapWmsOpcoes().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1899.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1899.001", new Object[]{idEmpresa}));
    }

    public OpcoesFinanceiras getOpcoesFinanceiras(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesFinanceiras(empresa.getIdentificador());
    }

    public OpcoesFinanceiras getOpcoesFinanceiras(Long idEmpresa) {
        OpcoesFinanceiras found = this.getMapOpcoesFinanceiras().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesFinanceirasImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesFinanceiras().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0701.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0701.001", new Object[]{idEmpresa}));
    }

    public Empresa getEmpresa(Long idEmpresa) {
        Empresa found = this.getMapEmpresas().get(idEmpresa);
        if (found != null) {
            return found;
        }
        this.xSync.execute((Object)String.valueOf(idEmpresa), () -> this.getMapEmpresas().put(idEmpresa, this.getServiceEmpresaImpl().getEager(idEmpresa)));
        found = this.getMapEmpresas().get(idEmpresa);
        if (found != null) {
            return found;
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0049.001", new Object[]{idEmpresa}));
    }

    public ConfigLogUsuarios getConfigLogUsuarios(Empresa emp) {
        if (emp == null) {
            return null;
        }
        ConfigLogUsuarios found = this.getMapConfigLogUsuarios().get(emp.getIdentificador());
        return found;
    }

    public OpcoesMobile getOpcoesMobile(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesMobile(empresa.getIdentificador());
    }

    public OpcoesMobile getOpcoesMobile(Long idEmpresa) {
        OpcoesMobile found = this.getMapOpcoesMobile().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesMobileImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesMobile().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1282.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1282.001", new Object[]{idEmpresa}));
    }

    public OpcoesEstoque getOpcoesEstoque(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesEstoque(empresa.getIdentificador());
    }

    public OpcoesEstoque getOpcoesEstoque(Long idEmpresa) {
        OpcoesEstoque found = this.getMapOpcoesEstoque().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesEstoqueImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesEstoque().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1796.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1796.001", new Object[]{idEmpresa}));
    }

    public OpcoesRelacionamento getOpcoesRelacionamento(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesRelacionamento(empresa.getIdentificador());
    }

    public OpcoesRelacionamento getOpcoesRelacionamento(Long idEmpresa) {
        OpcoesRelacionamento found = this.getMapOpcoesRelacionamento().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesRelacionamentoImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesRelacionamento().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0134.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.0134.001", new Object[]{idEmpresa}));
    }

    public OpcoesCtf getOpcoesCtf(Empresa empresa) {
        return empresa == null ? null : this.getOpcoesCtf(empresa.getIdentificador());
    }

    public OpcoesCtf getOpcoesCtf(Long idEmpresa) {
        OpcoesCtf found = this.getMapOpcoesCtf().get(idEmpresa);
        if (found != null) {
            return found;
        }
        Empresa empresa = this.getEmpresa(idEmpresa);
        if (empresa != null) {
            Empresa empresa2 = empresa;
            synchronized (empresa2) {
                found = this.getServiceOpcoesCtfImpl().getByIdEmpresa(idEmpresa);
                if (found != null) {
                    this.getMapOpcoesCtf().put(idEmpresa, found);
                    return found;
                }
                throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1820.001", new Object[]{idEmpresa}));
            }
        }
        throw new ExceptionObjectNotFound(new ExcepCodeDetail("E.ERP.1820.001", new Object[]{idEmpresa}));
    }

    public Map<Long, Empresa> getMapEmpresas() {
        return this.mapEmpresas;
    }

    public Map<Long, OpcoesCompraSuprimentos> getMapOpcoesCompra() {
        return this.mapOpcoesCompra;
    }

    public Map<Long, OpcoesFinanceiras> getMapOpcoesFinanceiras() {
        return this.mapOpcoesFinanceiras;
    }

    public Map<Long, OpcoesMobile> getMapOpcoesMobile() {
        return this.mapOpcoesMobile;
    }

    public Map<Long, OpcoesEstoque> getMapOpcoesEstoque() {
        return this.mapOpcoesEstoque;
    }

    public Map<Long, WmsOpcoes> getMapWmsOpcoes() {
        return this.mapWmsOpcoes;
    }

    public Map<Long, OpcoesFaturamento> getMapOpcoesFaturamento() {
        return this.mapOpcoesFaturamento;
    }

    public Map<Long, ConfiguracaoCertificado> getMapCertificados() {
        return this.mapCertificados;
    }

    public Map<Long, OpcoesRelacionamento> getMapOpcoesRelacionamento() {
        return this.mapOpcoesRelacionamento;
    }

    public Map<Long, OpcoesFaturamentoNFSe> getMapOpcoesFatNFSe() {
        return this.mapOpcoesFatNFSe;
    }

    public Map<Long, OpcoesFaturamentoTransp> getMapOpcoesTransp() {
        return this.mapOpcoesTransp;
    }

    public Map<Long, OpcoesVendas> getMapOpcoesVendas() {
        return this.mapOpcoesVendas;
    }

    public Map<Long, OpcoesPCP> getMapOpcoesPCP() {
        return this.mapOpcoesPCP;
    }

    public Map<Long, OpcoesManutencEquip> getMapOpcoesManutencEquip() {
        return this.mapOpcoesManutencEquip;
    }

    public Map<Long, OpcoesSistema> getMapOpcoesSistema() {
        return this.mapOpcoesSistema;
    }

    public Map<Long, OpcoesValidacao> getMapOpcoesValidacao() {
        return this.mapOpcoesValidacao;
    }

    public Map<Long, OpcoesFaturamentoManifestoCte> getMapOpcoesFatManCTe() {
        return this.mapOpcoesFatManCTe;
    }

    public Map<Long, OpcoesPatrimonio> getMapOpcoesPatrimonio() {
        return this.mapOpcoesPatrimonio;
    }

    public Map<Long, OpcoesGerenciais> getMapOpcoesGerenciais() {
        return this.mapOpcoesGerenciais;
    }

    public Map<Long, OpcoesContabeis> getMapOpcoesContabeis() {
        return this.mapOpcoesContabeis;
    }

    public Map<Long, NFCeOpcoes> getMapOpcoesNFCe() {
        return this.mapOpcoesNFCe;
    }

    public Map<Long, OpcoesImpostos> getMapOpcoesImpostos() {
        return this.mapOpcoesImpostos;
    }

    public Map<Long, OpcoesTicketFiscal> getMapOpcoesTicketFiscal() {
        return this.mapOpcoesTicketFiscal;
    }

    public Map<Long, OpcoesESocial> getMapOpcoesEsocial() {
        return this.mapOpcoesEsocial;
    }

    public Map<Long, OpcoesLocacao> getMapOpcoesLocacao() {
        return this.mapOpcoesLocacao;
    }

    public Map<Long, ConfigLogUsuarios> getMapConfigLogUsuarios() {
        return this.mapConfigLogUsuarios;
    }

    public Map<Long, OpcoesIntegracaoPonto> getMapOpcoesIntegracaoPonto() {
        return this.mapOpcoesIntegracaoPonto;
    }

    public Map<Long, EmpresaRh> getMapEmpresaRh() {
        return this.mapEmpresaRh;
    }

    public Map<Long, OpcoesCtf> getMapOpcoesCtf() {
        return this.mapOpcoesCtf;
    }

    public void loadBasicCache() {
        List data = this.getServiceLogUsuarioImpl().findAll();
        for (ConfigLogUsuarios conf : data) {
            for (ConfigLogUsuariosEmpresa confEmp : conf.getEmpresas()) {
                this.getMapConfigLogUsuarios().put(confEmp.getEmpresa().getIdentificador(), conf);
            }
        }
    }

    public Map<Long, Grupo> getMapGrupoUsuarios() {
        return this.mapGrupoUsuarios;
    }

    private String getCacheName(Class aClass) {
        return aClass.getSimpleName();
    }

    public Map<Long, List<DTONodoGrupoList>> getDTOUserGroup() {
        return this.getMapDTOGrupo();
    }

    public Map<Long, Usuario> getMapUsuario() {
        return this.mapUsuario;
    }

    public ServiceGrupoUsuariosImpl getServiceGrupoUsuariosImpl() {
        return (ServiceGrupoUsuariosImpl)Context.get(ServiceGrupoUsuariosImpl.class);
    }

    public ServiceUsuarioImpl getServiceUsuarioImpl() {
        return (ServiceUsuarioImpl)Context.get(ServiceUsuarioImpl.class);
    }

    public ServiceUsuarioBasicoImpl getServiceUsuarioBasicoImpl() {
        return (ServiceUsuarioBasicoImpl)Context.get(ServiceUsuarioBasicoImpl.class);
    }

    public ServiceOpcoesPesquisaWebImpl getServiceOpcoesPesquisaWebImpl() {
        return (ServiceOpcoesPesquisaWebImpl)Context.get(ServiceOpcoesPesquisaWebImpl.class);
    }

    public ServiceOpcoesSistemaImpl getServiceOpcoesSistemaImpl() {
        return (ServiceOpcoesSistemaImpl)Context.get(ServiceOpcoesSistemaImpl.class);
    }

    public ServiceOpcoesCompraSuprimentosImpl getServiceOpcoesCompraSuprimentosImpl() {
        return (ServiceOpcoesCompraSuprimentosImpl)Context.get(ServiceOpcoesCompraSuprimentosImpl.class);
    }

    public ServiceOpcoesGerenciaisImpl getServiceOpcoesGerenciaisImpl() {
        return (ServiceOpcoesGerenciaisImpl)Context.get(ServiceOpcoesGerenciaisImpl.class);
    }

    public ServiceOpcoesFaturamentoNFSeImpl getServiceOpcoesFaturamentoNFSeImpl() {
        return (ServiceOpcoesFaturamentoNFSeImpl)Context.get(ServiceOpcoesFaturamentoNFSeImpl.class);
    }

    public ServiceOpcoesFaturamentoTranspImpl getServiceOpcoesFaturamentoTranspImpl() {
        return (ServiceOpcoesFaturamentoTranspImpl)Context.get(ServiceOpcoesFaturamentoTranspImpl.class);
    }

    public ServiceOpcoesVendasImpl getServiceOpcoesVendasImpl() {
        return (ServiceOpcoesVendasImpl)Context.get(ServiceOpcoesVendasImpl.class);
    }

    public ServiceOpcoesPCPImpl getServiceOpcoesPCPImpl() {
        return (ServiceOpcoesPCPImpl)Context.get(ServiceOpcoesPCPImpl.class);
    }

    public ServiceOpcoesFaturamentoManifestoCteImpl getServiceOpcoesFaturamentoManifestoCteImpl() {
        return (ServiceOpcoesFaturamentoManifestoCteImpl)Context.get(ServiceOpcoesFaturamentoManifestoCteImpl.class);
    }

    public ServiceOpcoesPatrimonioImpl getServiceOpcoesPatrimonioImpl() {
        return (ServiceOpcoesPatrimonioImpl)Context.get(ServiceOpcoesPatrimonioImpl.class);
    }

    public ServiceOpcoesContabeisImpl getServiceOpcoesContabeisImpl() {
        return (ServiceOpcoesContabeisImpl)Context.get(ServiceOpcoesContabeisImpl.class);
    }

    public ServiceNFCeOpcoesImpl getServiceNFCeOpcoesImpl() {
        return (ServiceNFCeOpcoesImpl)Context.get(ServiceNFCeOpcoesImpl.class);
    }

    public ServiceOpcoesImpostosImpl getServiceOpcoesImpostosImpl() {
        return (ServiceOpcoesImpostosImpl)Context.get(ServiceOpcoesImpostosImpl.class);
    }

    public ServiceOpcoesTicketFiscalImpl getServiceOpcoesTicketFiscalImpl() {
        return (ServiceOpcoesTicketFiscalImpl)Context.get(ServiceOpcoesTicketFiscalImpl.class);
    }

    public ServiceOpcoesESocialImpl getServiceOpcoesESocialImpl() {
        return (ServiceOpcoesESocialImpl)Context.get(ServiceOpcoesESocialImpl.class);
    }

    public ServiceOpcoesFaturamentoImpl getServiceOpcoesFaturamentoImpl() {
        return (ServiceOpcoesFaturamentoImpl)Context.get(ServiceOpcoesFaturamentoImpl.class);
    }

    public ServiceOpcoesLocacaoImpl getServiceOpcoesLocacaoImpl() {
        return (ServiceOpcoesLocacaoImpl)Context.get(ServiceOpcoesLocacaoImpl.class);
    }

    public ServiceConfiguracaoCertificadoImpl getServiceConfiguracaoCertificadoImpl() {
        return (ServiceConfiguracaoCertificadoImpl)Context.get(ServiceConfiguracaoCertificadoImpl.class);
    }

    public ServiceOpcoesFinanceirasImpl getServiceOpcoesFinanceirasImpl() {
        return (ServiceOpcoesFinanceirasImpl)Context.get(ServiceOpcoesFinanceirasImpl.class);
    }

    public ServiceEmpresaImpl getServiceEmpresaImpl() {
        return (ServiceEmpresaImpl)Context.get(ServiceEmpresaImpl.class);
    }

    public ServiceConfigLogUsuariosImpl getServiceLogUsuarioImpl() {
        return (ServiceConfigLogUsuariosImpl)Context.get(ServiceConfigLogUsuariosImpl.class);
    }

    public ServiceWmsOpcoesImpl getServiceWmsOpcoesImpl() {
        return (ServiceWmsOpcoesImpl)Context.get(ServiceWmsOpcoesImpl.class);
    }

    public ServiceOpcoesEstoqueImpl getServiceOpcoesEstoqueImpl() {
        return (ServiceOpcoesEstoqueImpl)Context.get(ServiceOpcoesEstoqueImpl.class);
    }

    public ServiceOpcoesRelacionamentoImpl getServiceOpcoesRelacionamentoImpl() {
        return (ServiceOpcoesRelacionamentoImpl)Context.get(ServiceOpcoesRelacionamentoImpl.class);
    }

    public ServiceOpcoesManutencEquipImpl getServiceOpcoesManutencEquipImpl() {
        return (ServiceOpcoesManutencEquipImpl)Context.get(ServiceOpcoesManutencEquipImpl.class);
    }

    public ServiceOpcoesMobileImpl getServiceOpcoesMobileImpl() {
        return (ServiceOpcoesMobileImpl)Context.get(ServiceOpcoesMobileImpl.class);
    }

    public ServiceOpcoesValidacaoImpl getServiceOpcoesValidacaoEmpImpl() {
        return (ServiceOpcoesValidacaoImpl)Context.get(ServiceOpcoesValidacaoImpl.class);
    }

    public ServiceOpcoesIntegracaoPontoImpl getServiceOpcoesIntegracaoPontoImpl() {
        return (ServiceOpcoesIntegracaoPontoImpl)Context.get(ServiceOpcoesIntegracaoPontoImpl.class);
    }

    public ServiceEmpresaRhImpl getServiceEmpresaRhImpl() {
        return (ServiceEmpresaRhImpl)Context.get(ServiceEmpresaRhImpl.class);
    }

    public ServiceOpcoesCtfImpl getServiceOpcoesCtfImpl() {
        return (ServiceOpcoesCtfImpl)Context.get(ServiceOpcoesCtfImpl.class);
    }

    public Map<Long, List<DTONodoGrupoList>> getMapDTOGrupo() {
        return this.mapDTOGrupo;
    }

    public Long getDEFAULT_ID_FAKE() {
        return this.DEFAULT_ID_FAKE;
    }
}

