/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.database.interceptors;

import com.touchcomp.basementorservice.database.interceptors.DatabaseBaseInterceptor;
import com.touchcomp.basementorservice.database.interceptors.impl.DatabaseLogInterceptor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class DatabaseInterceptor
extends EmptyInterceptor {
    private static DatabaseInterceptor instance;
    LinkedList<DatabaseBaseInterceptor> listeners = new LinkedList();

    private DatabaseInterceptor() {
    }

    public static DatabaseInterceptor getInstance() {
        if (instance == null) {
            instance = new DatabaseInterceptor();
            instance.addInterceptor(new DatabaseLogInterceptor());
        }
        return instance;
    }

    public void addInterceptor(DatabaseBaseInterceptor base) {
        if (!this.listeners.contains(base)) {
            this.listeners.add(base);
        }
    }

    public void removeInterceptor(DatabaseBaseInterceptor base) {
        this.listeners.remove(base);
    }

    public void postFlush(Iterator entities) {
        for (DatabaseBaseInterceptor b : this.listeners) {
            b.postFlush(entities);
        }
        super.postFlush(entities);
    }

    public void beforeTransactionCompletion(Transaction tx) {
        for (DatabaseBaseInterceptor b : this.listeners) {
            b.beforeTransactionCompletion(tx);
        }
        super.beforeTransactionCompletion(tx);
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        for (DatabaseBaseInterceptor b : this.listeners) {
            b.onDelete(entity, id, state, propertyNames, types);
        }
        super.onDelete(entity, id, state, propertyNames, types);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        for (DatabaseBaseInterceptor b : this.listeners) {
            b.onSave(entity, id, state, propertyNames, types);
        }
        return super.onSave(entity, id, state, propertyNames, types);
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        boolean aux = super.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        for (DatabaseBaseInterceptor b : this.listeners) {
            b.onFlushDirty(entity, id, currentState, previousState, propertyNames, types);
        }
        return aux;
    }

    public void afterTransactionCompletion(Transaction tx) {
        for (DatabaseBaseInterceptor b : this.listeners) {
            b.afterTransactionCompletion(tx);
        }
        super.afterTransactionCompletion(tx);
    }
}

