/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.database.interceptors.impl;

import com.touchcomp.basementor.constants.enums.logacoesusuario.EnumConstLogAcoesUsuarioOp;
import com.touchcomp.basementor.model.interfaces.InterfaceCurrentInfoProvider;
import com.touchcomp.basementor.model.interfaces.InterfaceStaticObjects;
import com.touchcomp.basementor.model.vo.ConexaoUsuario;
import com.touchcomp.basementor.model.vo.ConfigLogUsuarios;
import com.touchcomp.basementor.model.vo.ConfigLogUsuariosClasses;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LocalTicketAtSolReab;
import com.touchcomp.basementor.model.vo.LocalTicketAtendPrevisoes;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouch;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchFile;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchLog;
import com.touchcomp.basementor.model.vo.LogConexaoUsuario;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.NodoGrupo;
import com.touchcomp.basementor.model.vo.NodoUsuario;
import com.touchcomp.basementor.model.vo.SearchClass;
import com.touchcomp.basementor.model.vo.SearchClassField;
import com.touchcomp.basementor.model.vo.SearchClassFieldRes;
import com.touchcomp.basementor.model.vo.SearchClassFieldResItem;
import com.touchcomp.basementor.model.vo.SearchClassUserPref;
import com.touchcomp.basementor.model.vo.SearchClassUserPrefCol;
import com.touchcomp.basementor.model.vo.SearchClassUserPrefField;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorexceptions.exceptions.impl.zip.ExceptionZip;
import com.touchcomp.basementorlogacoes.model.LogAcoesUsuario;
import com.touchcomp.basementorlogacoes.service.impl.logusuario.ServiceLogAcoesUsuarioImpl;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.database.interceptors.DatabaseBaseInterceptor;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.json.ToolJson;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.string.TString;
import com.touchcomp.touchvomodel.vo.logacoesusuario.web.DTOLogAcoesUsuario;
import java.awt.GraphicsEnvironment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.LinkedBlockingQueue;
import org.hibernate.Transaction;
import org.hibernate.type.Type;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.RequestContextHolder;

public class DatabaseLogInterceptor
implements DatabaseBaseInterceptor,
TransactionSynchronization {
    final String NAME = "config.log.usuarios";
    private ServiceLogAcoesUsuarioImpl serviceLog;
    private InterfaceStaticObjects dataCache;
    private InterfaceCurrentInfoProvider currentInfo;
    private final LinkedBlockingQueue<LogAcoesUsuario> logsToSave = new LinkedBlockingQueue();
    private static final TLogger logger = TLogger.get(DatabaseLogInterceptor.class);
    private LinkedList classes;
    private ThreadLocal threadLocal;
    private boolean flagSaveTransactionComplete = false;

    @Override
    public void postFlush(Iterator entities) {
        if (this.getLogsToSave().isEmpty()) {
            return;
        }
        if (this.threadLocal == null || !this.threadLocal.isAlive()) {
            this.threadLocal = new ThreadLocal();
            this.threadLocal.start();
        }
    }

    @Override
    public void beforeTransactionCompletion(Transaction tx) {
        this.setFlagSaveTransactionComplete(false);
    }

    public void afterCompletion(int status) {
        if (TMethods.isEquals((Object)1, (Object)status)) {
            this.getLogsToSave().clear();
        }
    }

    @Override
    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.initTransactionRegister();
        if (!this.isGerarLogClassesFixas(entity.getClass())) {
            return;
        }
        if (!this.isLoadedSharedData() || this.getCurrentInfo() == null || this.getCurrentInfo().getCurrentUsuario() == null || this.getCurrentInfo().getCurrentEmpresa() == null) {
            return;
        }
        Usuario user = this.getCurrentInfo().getCurrentUsuario();
        Empresa emp = this.getCurrentInfo().getCurrentEmpresa();
        ConfigLogUsuarios config = this.getDataCache().getConfigLogUsuarios(emp);
        if (this.isGenerateLogConfigUsuarios(entity, config)) {
            return;
        }
        if (config != null && !TMethods.isAffirmative((Number)config.getGerarLogDelete())) {
            return;
        }
        boolean detLog = false;
        if (config != null) {
            detLog = TMethods.isAffirmative((Number)config.getGerarLogDetalhadoDelete());
        }
        try {
            this.createAndAddLogDelete(detLog, user, entity, EnumConstLogAcoesUsuarioOp.DELETE, id, state, propertyNames);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException("Houve um problema ao gerar os logs de usuarios.");
        }
    }

    @Override
    public void onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        try {
            this.initTransactionRegister();
            if (!this.isGerarLogClassesFixas(entity.getClass())) {
                return;
            }
            if (!this.isLoadedSharedData() || this.getCurrentInfo() == null || this.getCurrentInfo().getCurrentUsuario() == null || this.getCurrentInfo().getCurrentEmpresa() == null) {
                return;
            }
            Usuario user = this.getCurrentInfo().getCurrentUsuario();
            Empresa emp = this.getCurrentInfo().getCurrentEmpresa();
            ConfigLogUsuarios config = this.getDataCache().getConfigLogUsuarios(emp);
            if (this.isGenerateLogConfigUsuarios(entity, config)) {
                return;
            }
            if (config != null && !TMethods.isAffirmative((Number)config.getGerarLogInsert())) {
                return;
            }
            boolean detLog = false;
            if (config != null) {
                detLog = TMethods.isAffirmative((Number)config.getGerarLogDetalhadoInsert());
            }
            this.createAndAddLogInsert(detLog, user, entity, EnumConstLogAcoesUsuarioOp.INSERT, id, state, propertyNames);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException("Houve um problema ao gerar os logs de usuarios.");
        }
    }

    @Override
    public void onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        try {
            this.initTransactionRegister();
            if (!this.isGerarLogClassesFixas(entity.getClass())) {
                return;
            }
            if (previousState == null || currentState == null) {
                return;
            }
            if (!this.isLoadedSharedData() || this.getCurrentInfo() == null || this.getCurrentInfo().getCurrentUsuario() == null || this.getCurrentInfo().getCurrentEmpresa() == null) {
                return;
            }
            Usuario user = this.getCurrentInfo().getCurrentUsuario();
            Empresa emp = this.getCurrentInfo().getCurrentEmpresa();
            ConfigLogUsuarios config = this.getDataCache().getConfigLogUsuarios(emp);
            if (config != null && !TMethods.isAffirmative((Number)config.getGerarLogEditar())) {
                return;
            }
            if (this.isGenerateLogConfigUsuarios(entity, config)) {
                return;
            }
            this.createAndAddLogUpd(user, entity, EnumConstLogAcoesUsuarioOp.UPDATE, id, previousState, currentState, propertyNames);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException("Houve um problema ao gerar os logs de usuarios.");
        }
    }

    LogAcoesUsuario getLog(Usuario user, EnumConstLogAcoesUsuarioOp operacao, Object entity, Serializable id) {
        LogAcoesUsuario l = new LogAcoesUsuario();
        if (user != null) {
            l.setIdUsuario(user.getIdentificador());
        }
        l.setDataLog(new Date());
        l.setDescricao(TString.cut((String)String.valueOf(entity), (int)2000));
        if (id instanceof Number) {
            l.setIdEntidade(Long.valueOf(((Number)id).longValue()));
        }
        l.setPathClass(TString.cut((String)entity.getClass().getSimpleName(), (int)1000));
        l.setTipoOperacaoLog(Short.valueOf(operacao.getValue()));
        return l;
    }

    void createAndAddLogDelete(boolean detLog, Usuario user, Object entity, EnumConstLogAcoesUsuarioOp op, Serializable id, Object[] state, String[] propertyNames) throws Exception {
        try {
            LogAcoesUsuario l = this.getLog(user, op, entity, id);
            if (detLog) {
                ArrayList<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet> detalhes = new ArrayList<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet>();
                for (int i = 0; i < propertyNames.length; ++i) {
                    DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet det;
                    Object obj = state[i];
                    if (obj != null && Collection.class.isAssignableFrom(obj.getClass()) || (det = this.getDetLog(null, obj, propertyNames[i])) == null) continue;
                    detalhes.add(det);
                }
                l.setDetalhes(this.compressDetails(detalhes));
            }
            this.addLog(l);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException("Houve um problema ao gerar os logs de usuarios.");
        }
    }

    void createAndAddLogInsert(boolean detLog, Usuario user, Object entity, EnumConstLogAcoesUsuarioOp op, Serializable id, Object[] state, String[] propertyNames) throws Exception {
        try {
            LogAcoesUsuario l = this.getLog(user, op, entity, id);
            if (detLog) {
                ArrayList<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet> detalhes = new ArrayList<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet>();
                for (int i = 0; i < propertyNames.length; ++i) {
                    Object obj = state[i];
                    DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet det = this.getDetLog(obj, null, propertyNames[i]);
                    if (det == null) continue;
                    detalhes.add(det);
                }
                l.setDetalhes(this.compressDetails(detalhes));
            }
            this.addLog(l);
        }
        catch (Exception ex) {
            logger.error(ex.getClass(), (Throwable)ex);
            throw new RuntimeException("Houve um problema ao gerar os logs de usuarios.");
        }
    }

    void createAndAddLogUpd(Usuario user, Object entity, EnumConstLogAcoesUsuarioOp op, Serializable id, Object[] previousState, Object[] currentState, String[] propertyNames) throws Exception {
        ArrayList<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet> detalhes = new ArrayList<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet>();
        for (int i = 0; i < currentState.length; ++i) {
            Object valorAtual = currentState[i];
            Object valorAnterior = previousState[i];
            DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet det = this.getDetLog(valorAtual, valorAnterior, propertyNames[i]);
            if (det == null) continue;
            detalhes.add(det);
        }
        if (!detalhes.isEmpty()) {
            LogAcoesUsuario l = this.getLog(user, op, entity, id);
            l.setDetalhes(this.compressDetails(detalhes));
            this.addLog(l);
        }
    }

    private DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet getDetLog(Object valorAtual, Object valorAnterior, String field) {
        Class clazz = Object.class;
        if (valorAtual != null) {
            clazz = valorAtual.getClass();
        } else if (valorAnterior != null) {
            clazz = valorAnterior.getClass();
        }
        OpFinder opFinder = CompRestrictionsFactory.getRestrictions(clazz, (String)"dd-MM-yyyy HH:mm:ss.SSS");
        String vlrAtual = opFinder.convertValueToString(valorAtual);
        String vlrAnt = opFinder.convertValueToString(valorAnterior);
        if (TMethods.isEquals((Object)vlrAnt, (Object)vlrAtual)) {
            return null;
        }
        DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet d = new DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet();
        d.setValorAnterior(vlrAnt);
        d.setValorAtual(vlrAtual);
        d.setField(field);
        return d;
    }

    private boolean isGenerateLogConfigUsuarios(Object entity, ConfigLogUsuarios config) {
        if (config == null) {
            return true;
        }
        Optional<ConfigLogUsuariosClasses> found = config.getConfLogClasses().stream().filter(i -> TMethods.isEqualsIgnoreCase((String)entity.getClass().getCanonicalName(), (String)i.getClasse())).findFirst();
        return found.isPresent();
    }

    public int hashCode() {
        return "config.log.usuarios".hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DatabaseLogInterceptor)) {
            return super.equals(obj);
        }
        DatabaseLogInterceptor l = (DatabaseLogInterceptor)obj;
        return l.NAME.equalsIgnoreCase("config.log.usuarios");
    }

    @Override
    public void afterTransactionCompletion(Transaction tx) {
        this.flagSaveTransactionComplete = true;
    }

    private boolean isGerarLogClassesFixas(Class<? extends Object> aClass) {
        return !this.getClassesFixasNaoGeraLog().contains(aClass);
    }

    private List<Class> getClassesFixasNaoGeraLog() {
        if (this.classes == null) {
            this.classes = new LinkedList();
            this.classes.add(Nodo.class);
            this.classes.add(NodoUsuario.class);
            this.classes.add(NodoGrupo.class);
            this.classes.add(SearchClass.class);
            this.classes.add(SearchClassField.class);
            this.classes.add(SearchClassUserPref.class);
            this.classes.add(SearchClassUserPrefCol.class);
            this.classes.add(SearchClassUserPrefField.class);
            this.classes.add(SearchClassFieldRes.class);
            this.classes.add(SearchClassFieldResItem.class);
            this.classes.add(LocalTicketAtendTouch.class);
            this.classes.add(LocalTicketAtendTouchFile.class);
            this.classes.add(LocalTicketAtendTouchLog.class);
            this.classes.add(LocalTicketAtendPrevisoes.class);
            this.classes.add(LocalTicketAtSolReab.class);
            this.classes.add(ConexaoUsuario.class);
            this.classes.add(LogConexaoUsuario.class);
        }
        return this.classes;
    }

    private String compressDetails(List<DTOLogAcoesUsuario.DTOLogAcoesUsuarioDet> detalhes) throws ExceptionZip, ExceptionIO {
        String json = ToolJson.toJson(detalhes);
        json = TString.cut((String)json, (int)10000);
        return json;
    }

    private boolean isLoadedSharedData() {
        if (!GraphicsEnvironment.isHeadless()) {
            return true;
        }
        return RequestContextHolder.getRequestAttributes() != null;
    }

    private void addLog(LogAcoesUsuario l) throws InterruptedException {
        Optional<LogAcoesUsuario> found = this.getLogsToSave().stream().filter(i -> TMethods.isEquals((Object)i.getDescricao(), (Object)l.getDescricao()) && TMethods.isEquals((Object)i.getIdEntidade(), (Object)l.getIdEntidade()) && TMethods.isEquals((Object)i.getIdUsuario(), (Object)l.getIdUsuario())).findFirst();
        if (!found.isPresent()) {
            this.getLogsToSave().put(l);
        }
    }

    private void initTransactionRegister() {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)this);
    }

    public LinkedBlockingQueue<LogAcoesUsuario> getLogsToSave() {
        return this.logsToSave;
    }

    public InterfaceCurrentInfoProvider getCurrentInfo() {
        if (this.currentInfo == null) {
            this.currentInfo = (InterfaceCurrentInfoProvider)ConfApplicationContext.getBean(InterfaceCurrentInfoProvider.class);
        }
        return this.currentInfo;
    }

    public InterfaceStaticObjects getDataCache() {
        if (this.dataCache == null) {
            this.dataCache = (InterfaceStaticObjects)ConfApplicationContext.getBean(InterfaceStaticObjects.class);
        }
        return this.dataCache;
    }

    public ServiceLogAcoesUsuarioImpl getServiceLog() {
        if (this.serviceLog == null) {
            this.serviceLog = (ServiceLogAcoesUsuarioImpl)Context.get(ServiceLogAcoesUsuarioImpl.class);
        }
        return this.serviceLog;
    }

    public boolean isFlagSaveTransactionComplete() {
        return this.flagSaveTransactionComplete;
    }

    public void setFlagSaveTransactionComplete(boolean flagSaveTransactionComplete) {
        this.flagSaveTransactionComplete = flagSaveTransactionComplete;
    }

    private class ThreadLocal
    extends Thread {
        private ThreadLocal() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.saveLogs();
                        Thread.sleep(1000L);
                    }
                }
                catch (Throwable t) {
                    logger.error(t);
                    continue;
                }
                break;
            }
        }

        private void saveLogs() {
            if (DatabaseLogInterceptor.this.getLogsToSave().isEmpty()) {
                return;
            }
            if (!DatabaseLogInterceptor.this.isFlagSaveTransactionComplete()) {
                return;
            }
            LinkedList<LogAcoesUsuario> logs = new LinkedList<LogAcoesUsuario>();
            try {
                do {
                    int size = DatabaseLogInterceptor.this.getLogsToSave().size();
                    for (int i = 0; i < size; ++i) {
                        logs.add(DatabaseLogInterceptor.this.getLogsToSave().poll());
                    }
                    DatabaseLogInterceptor.this.getServiceLog().saveOrUpdate(logs);
                } while (!DatabaseLogInterceptor.this.getLogsToSave().isEmpty());
            }
            catch (Exception ex) {
                logger.error(ex.getClass(), (Throwable)ex);
            }
        }
    }
}

