/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.analiseprecovenda;

import com.touchcomp.basementor.constants.enums.analisecusto.EnumConstTipoCusto;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProd;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelFunEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelMatEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCelOutrosEnc;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCen;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdCenVar;
import com.touchcomp.basementor.model.vo.AnalisePrVendaProdEnc;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FaseProdutiva;
import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.ItemFormFasesProdutivas;
import com.touchcomp.basementor.model.vo.ItemFormulacaoFases;
import com.touchcomp.basementor.model.vo.ItemKitProd;
import com.touchcomp.basementor.model.vo.KitProdutos;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.RoteiroProducao;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.analiseprecovenda.SCompAnalisePrVendaProd;
import com.touchcomp.basementortools.tools.clone.ToolClone;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.number.ToolNumber;
import com.touchcomp.touchvomodel.vo.analiseprvendaprod.web.DTOAnalisePrVendaProd;
import com.touchcomp.touchvomodel.vo.analiseprvendaprod.web.DTOGraficoAnalisePrVendaCen;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperAnalisePrecoVenda
implements AbstractHelper<AnalisePrVendaProd> {
    private AnalisePrVendaProd analisePrVendaProd;
    @Autowired
    private SCompAnalisePrVendaProd scomp;

    public HelperAnalisePrecoVenda build(AnalisePrVendaProd agenciaValores) {
        this.analisePrVendaProd = agenciaValores;
        return this;
    }

    public AnalisePrVendaProd get() {
        return this.analisePrVendaProd;
    }

    public AnalisePrVendaProd cloneIt(AnalisePrVendaProd ana) throws ExceptionReflection {
        if (ana == null) {
            return null;
        }
        AnalisePrVendaProd n = (AnalisePrVendaProd)ToolClone.cloneEntity((Object)ana);
        for (AnalisePrVendaProdCen cenario : n.getCenarios()) {
            cenario.setAnalisePrVendaProd(n);
            for (AnalisePrVendaProdCenVar v : cenario.getVariaveis()) {
                v.setAnalisePrVendaProdCen(cenario);
            }
        }
        if (n.getAnalisePrVendaPCPEnc() == null) {
            return n;
        }
        AnalisePrVendaProdEnc anaEnc = n.getAnalisePrVendaPCPEnc();
        for (AnalisePrVendaProdCelEnc a : anaEnc.getItensCelulaAnalPreco()) {
            a.setAnalisePrVendaProdPCPEnc(anaEnc);
            for (AnalisePrVendaProdCelFunEnc itemFunCelula : a.getItemFunCelulas()) {
                itemFunCelula.setAnalisePrVendaProdCelPCPEnc(a);
            }
            for (AnalisePrVendaProdCelMatEnc itemMatCelula : a.getItemMatCelulas()) {
                itemMatCelula.setAnalisePrVendaProdCelPCPEnc(a);
            }
            for (AnalisePrVendaProdCelOutrosEnc itemOutros : a.getItemOutros()) {
                itemOutros.setAnalisePrVendaProdCelPCPEnc(a);
            }
        }
        return n;
    }

    public AnalisePrVendaProdCelEnc novaCelulaAnalise(CelulaProdutiva cp) {
        AnalisePrVendaProdCelEnc vo = new AnalisePrVendaProdCelEnc();
        vo.setCelulaProdutiva(cp);
        vo.setHorasExecucao(Double.valueOf(0.0));
        vo.setValorPrevisto(Double.valueOf(0.0));
        return vo;
    }

    public AnalisePrVendaProdCelMatEnc novoMaterialInfCelula(GradeCor gc) {
        AnalisePrVendaProdCelMatEnc vo = new AnalisePrVendaProdCelMatEnc();
        vo.setGradeCor(gc);
        vo.setTipoGradeInf(Short.valueOf((short)1));
        this.sugerirPesoMaterial(vo);
        return vo;
    }

    public AnalisePrVendaProdCelMatEnc novoMaterialInfCelula() {
        AnalisePrVendaProdCelMatEnc vo = new AnalisePrVendaProdCelMatEnc();
        vo.setTipoGradeInf(Short.valueOf((short)0));
        this.sugerirPesoMaterial(vo);
        return vo;
    }

    public void sugerirPesoMaterial(AnalisePrVendaProdCelMatEnc vo) {
        if (vo != null && vo.getGradeCor() != null) {
            vo.setPesoBruto(Double.valueOf((vo.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario() + vo.getGradeCor().getProdutoGrade().getProduto().getPesoEmbalagem()) * vo.getQuantidade()));
            vo.setPesoLiquido(Double.valueOf(vo.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario() * vo.getQuantidade()));
        }
    }

    public AnalisePrVendaProdCelMatEnc novoMaterialKitCelula(KitProdutos kitProd, ItemKitProd itemKit, Double quantidade) {
        AnalisePrVendaProdCelMatEnc itemMaterial = new AnalisePrVendaProdCelMatEnc();
        itemMaterial.setObservacao(kitProd.getDescricao());
        if (TMethods.isNotNull((Object)quantidade).booleanValue() && quantidade > 0.0) {
            itemMaterial.setQuantidade(Double.valueOf(itemKit.getQuantidade() != null ? itemKit.getQuantidade() * quantidade : 0.0));
            itemMaterial.setQuantidadeRef(Double.valueOf(itemKit.getQuantidadeRef() != null ? itemKit.getQuantidadeRef() * quantidade : 0.0));
        } else {
            itemMaterial.setQuantidade(Double.valueOf(itemKit.getQuantidade() != null ? itemKit.getQuantidade() : 0.0));
            itemMaterial.setQuantidadeRef(Double.valueOf(itemKit.getQuantidadeRef() != null ? itemKit.getQuantidadeRef() : 0.0));
        }
        itemMaterial.setGradeCor(itemKit.getGradeCor());
        itemMaterial.setAltura(itemKit.getAltura());
        itemMaterial.setComprimento(itemKit.getComprimento());
        itemMaterial.setLargura(itemKit.getLargura());
        itemMaterial.setPesoBruto(itemKit.getPesoBruto());
        itemMaterial.setPesoLiquido(itemKit.getPesoLiquido());
        itemMaterial.setVolume(itemKit.getVolume());
        itemMaterial.setObservacao(itemKit.getObservacao());
        itemMaterial.setProducaoPropria(itemKit.getProducaoPropria());
        itemMaterial.setTipoGradeInf(Short.valueOf((short)1));
        this.sugerirPesoMaterial(itemMaterial);
        return itemMaterial;
    }

    public AnalisePrVendaProdCelFunEnc novaFuncaoCelula(Funcao fun) {
        AnalisePrVendaProdCelFunEnc vo = new AnalisePrVendaProdCelFunEnc();
        vo.setFuncao(fun);
        vo.setTipoInfFuncao(Short.valueOf((short)1));
        vo.setValorUnitario(fun.getValorReferenciaHora());
        return vo;
    }

    public AnalisePrVendaProdCelFunEnc novaFuncaoCelula() {
        AnalisePrVendaProdCelFunEnc vo = new AnalisePrVendaProdCelFunEnc();
        vo.setTipoInfFuncao(Short.valueOf((short)0));
        return vo;
    }

    public AnalisePrVendaProdEnc recalcularVlrsPrevistosCel(AnalisePrVendaProdEnc vo, Double quantidade) {
        if (TMethods.isNull((Object)quantidade).booleanValue() || quantidade <= 0.0) {
            quantidade = 1.0;
        }
        if (TMethods.isWithData((Collection)vo.getItensCelulaAnalPreco())) {
            Double valorTotalCel = 0.0;
            for (AnalisePrVendaProdCelEnc i : vo.getItensCelulaAnalPreco()) {
                FaseProdutiva faseProdutiva;
                if ((TMethods.isNull((Object)i.getValorPrevisto()).booleanValue() || TMethods.isEquals((Object)i.getValorPrevisto(), (Object)0.0)) && TMethods.isNotNull((Object)i.getCelulaProdutiva()).booleanValue()) {
                    i.setValorPrevisto(i.getCelulaProdutiva().getValorCustoHora());
                }
                if ((TMethods.isNull((Object)i.getHorasSetup()).booleanValue() || TMethods.isEquals((Object)i.getHorasSetup(), (Object)0.0)) && TMethods.isNotNull((Object)i.getCelulaProdutiva()).booleanValue() && TMethods.isNotNull((Object)(faseProdutiva = this.getFaseProdutivaByCelula(i.getCelulaProdutiva(), i.getRoteiroProducao()))).booleanValue()) {
                    i.setHorasSetup(faseProdutiva.getTempoSetup());
                }
                i.setHorasTotais(Double.valueOf(i.getHorasExecucao() * quantidade + i.getHorasSetup()));
                i.setValorTotal(Double.valueOf(i.getHorasTotais() * i.getValorPrevisto()));
                valorTotalCel = valorTotalCel + i.getValorTotal();
            }
            vo.setValorTotalCel(valorTotalCel);
            vo.setValorTotal(Double.valueOf(vo.getValorTotalMat() + vo.getValorTotalCel() + vo.getValorTotalFunc() + vo.getValorTotalOutros()));
        }
        return vo;
    }

    private FaseProdutiva getFaseProdutivaByCelula(CelulaProdutiva celula, RoteiroProducao roteiro) {
        Optional<FaseProdutiva> aux;
        if (TMethods.isNotNull((Object)roteiro).booleanValue() && TMethods.isWithData((Collection)roteiro.getFasesProdutivas()) && (aux = roteiro.getFasesProdutivas().stream().filter(i -> TMethods.isEquals((Object)i.getCelulaProdutiva(), (Object)celula) && TMethods.isAffirmative((Number)i.getAtivo())).findFirst()).isPresent()) {
            return aux.get();
        }
        return null;
    }

    public AnalisePrVendaProdEnc calcularValorTotalOrcado(AnalisePrVendaProdEnc vo, Double quantidade) {
        if (TMethods.isNull((Object)quantidade).booleanValue() || quantidade <= 0.0) {
            quantidade = 1.0;
        }
        Double valorMat = 0.0;
        Double valorCel = 0.0;
        Double valorFunc = 0.0;
        Double valorOutros = 0.0;
        Double pesoBruto = 0.0;
        Double pesoLiquido = 0.0;
        Double pesoBrutoMat = 0.0;
        Double pesoLiquidoMat = 0.0;
        if (TMethods.isWithData((Collection)vo.getItensCelulaAnalPreco())) {
            for (AnalisePrVendaProdCelEnc it : vo.getItensCelulaAnalPreco()) {
                valorCel = valorCel + it.getValorTotal();
                for (AnalisePrVendaProdCelMatEnc ob : it.getItemMatCelulas()) {
                    this.sugerirPesoMaterial(ob);
                    this.recalcularValoresMaterial(ob, quantidade);
                    valorMat = valorMat + ob.getValorTotal();
                    pesoBruto = pesoBruto + ob.getPesoBruto();
                    pesoLiquido = pesoLiquido + ob.getPesoLiquido();
                    pesoBrutoMat = pesoBrutoMat + ob.getPesoBruto();
                    pesoLiquidoMat = pesoLiquidoMat + ob.getPesoLiquido();
                }
                valorFunc = valorFunc + this.calcularTotalizadoresFuncoes(it, quantidade);
                valorOutros = valorOutros + this.calcularTotalizadoresOutros(it, quantidade);
            }
        }
        if (!TMethods.isAffirmative((Number)vo.getInformarValores())) {
            vo.setValorTotal(Double.valueOf(valorCel + valorFunc + valorMat + valorOutros));
            vo.setValorTotalCel(valorCel);
            vo.setValorTotalFunc(valorFunc);
            vo.setValorTotalOutros(valorOutros);
            vo.setValorTotalMat(valorMat);
        }
        if (!TMethods.isAffirmative((Number)vo.getInformarPeso())) {
            vo.setPesoBruto(pesoBruto);
            vo.setPesoLiquido(pesoLiquido);
        }
        vo.setPesoBrutoMateriais(pesoBrutoMat);
        vo.setPesoLiquidoMateriais(pesoLiquidoMat);
        return vo;
    }

    public List<AnalisePrVendaProdCen> getCenariosEscolhidos(AnalisePrVendaProd vo) throws ExceptionInvalidData {
        if (BaseMethods.isWithData(vo.getCenarios())) {
            List<AnalisePrVendaProdCen> cenariosEscolhidos = vo.getCenarios().stream().filter(i -> TMethods.isAffirmative((Number)i.getCenarioEscolhido())).toList();
            if (!BaseMethods.isWithData(cenariosEscolhidos)) {
                throw new ExceptionInvalidData("E.ERP.2015.005", new Object[0]);
            }
            if (cenariosEscolhidos.size() > 1) {
                throw new ExceptionInvalidData("E.ERP.2015.006", new Object[0]);
            }
            return cenariosEscolhidos;
        }
        throw new ExceptionInvalidData("E.ERP.2015.005", new Object[0]);
    }

    public AnalisePrVendaProd recalcularValoresAnalise(AnalisePrVendaProd vo) throws ExceptionInvalidData {
        List<AnalisePrVendaProdCen> cenariosEscolhidos = this.getCenariosEscolhidos(vo);
        if (TMethods.isNull((Object)vo.getQuantidade()).booleanValue() || vo.getQuantidade() <= 0.0) {
            vo.setQuantidade(Double.valueOf(1.0));
        }
        vo.setValorTotal(cenariosEscolhidos.getFirst().getResultado());
        return vo;
    }

    public AnalisePrVendaProd recalcularAnaliseSubAnalises(AnalisePrVendaProd vo) throws ExceptionInvalidData {
        List<AnalisePrVendaProdCen> cenariosEscolhidos = this.getCenariosEscolhidos(vo);
        if (TMethods.isNull((Object)vo.getQuantidade()).booleanValue() || vo.getQuantidade() <= 0.0) {
            vo.setQuantidade(Double.valueOf(1.0));
        }
        vo.setValorTotal(cenariosEscolhidos.getFirst().getResultado());
        if (TMethods.isWithData((Collection)vo.getAnalises())) {
            for (AnalisePrVendaProd ana : vo.getAnalises()) {
                cenariosEscolhidos = this.getCenariosEscolhidos(ana);
                ana.setValorTotal(cenariosEscolhidos.getFirst().getResultado());
                if (!TMethods.isNotNull((Object)ana.getQuantidade()).booleanValue()) continue;
                this.calcularValorTotalOrcado(ana.getAnalisePrVendaPCPEnc(), ana.getQuantidade());
            }
        }
        return vo;
    }

    public Double calcularTotalizadoresOutros(AnalisePrVendaProdCelEnc it, Double quantidade) {
        Double valorTotalOutros = 0.0;
        for (AnalisePrVendaProdCelOutrosEnc ob : it.getItemOutros()) {
            if (TMethods.isEquals((Object)quantidade, (Object)1.0)) {
                ob.setValor(Double.valueOf(ToolNumber.asZeroIfNull((Double)ob.getValorUnitario()) * ToolNumber.asZeroIfNull((Double)ob.getQuantidade())));
                ob.setValorTotal(ob.getValor());
            } else {
                if (TMethods.isAffirmative((Number)ob.getAplicarQuantidadeAnalisada())) {
                    ob.setQuantidade(Double.valueOf(ob.getQuantidade() * quantidade));
                }
                ob.setValorTotal(Double.valueOf(ob.getValorUnitario() * ob.getQuantidade()));
            }
            valorTotalOutros = valorTotalOutros + ob.getValorTotal();
        }
        return valorTotalOutros;
    }

    public Double calcularTotalizadoresFuncoes(AnalisePrVendaProdCelEnc it, Double quantidade) {
        Double valorTotalFuncoes = 0.0;
        for (AnalisePrVendaProdCelFunEnc ob : it.getItemFunCelulas()) {
            if (TMethods.isEquals((Object)quantidade, (Object)1.0)) {
                ob.setValor(Double.valueOf(ToolNumber.asZeroIfNull((Double)ob.getValorUnitario()) * ToolNumber.asZeroIfNull((Double)ob.getQuantidade())));
                ob.setValorTotal(ob.getValor());
            } else {
                if (TMethods.isAffirmative((Number)ob.getConsiderarQtdAnalisada())) {
                    ob.setQuantidade(Double.valueOf(ob.getQuantidade() * quantidade));
                }
                ob.setValorTotal(Double.valueOf(ob.getValorUnitario() * ob.getQuantidade()));
            }
            valorTotalFuncoes = valorTotalFuncoes + ob.getValorTotal();
        }
        return valorTotalFuncoes;
    }

    public AnalisePrVendaProdCelMatEnc recalcularValoresMaterial(AnalisePrVendaProdCelMatEnc vo, Double quantidade) {
        if (TMethods.isNull((Object)vo).booleanValue()) {
            return null;
        }
        if (TMethods.isEquals((Object)quantidade, (Object)1.0)) {
            vo.setValor(Double.valueOf(ToolNumber.asZeroIfNull((Double)vo.getValorUnitario()) * ToolNumber.asZeroIfNull((Double)vo.getQuantidade())));
            vo.setValorTotal(vo.getValor());
        } else {
            if (TMethods.isAffirmative((Number)vo.getConsiderarQtdAnalisada())) {
                vo.setQuantidade(Double.valueOf(vo.getQuantidade() * quantidade));
            }
            vo.setValorTotal(Double.valueOf(vo.getValorUnitario() * vo.getQuantidade()));
        }
        this.sugerirPesoMaterial(vo);
        if (TMethods.isNotNull((Object)vo.getComprimento()).booleanValue() && TMethods.isNotNull((Object)vo.getAltura()).booleanValue() && TMethods.isNotNull((Object)vo.getLargura()).booleanValue()) {
            vo.setVolume(Double.valueOf(vo.getComprimento() * vo.getAltura() * vo.getLargura()));
        }
        return vo;
    }

    public void buildGraficos(AnalisePrVendaProd ana, AnalisePrVendaProdCen cen, DTOAnalisePrVendaProd.DTOAnalisePrVendaProdCen dto) {
        DTOGraficoAnalisePrVendaCen custoXvenda = this.buildChartCustoVenda(cen);
        DTOGraficoAnalisePrVendaCen composicaoCusto = this.buildChartComposicaoCusto(ana);
        dto.setCustoXVenda(custoXvenda);
        dto.setComposicaoCustos(composicaoCusto);
    }

    private DTOGraficoAnalisePrVendaCen buildChartCustoVenda(AnalisePrVendaProdCen cen) {
        DTOGraficoAnalisePrVendaCen custoXvenda = new DTOGraficoAnalisePrVendaCen();
        custoXvenda.setTitle("Custo vs Venda");
        Double totalCusto = 0.0;
        for (AnalisePrVendaProdCenVar va : cen.getVariaveis()) {
            if (!TMethods.isEquals((Object)va.getDescricao(), (Object)"valor_custo_pcp_analise") && !TMethods.isEquals((Object)va.getDescricao(), (Object)"custo_pcp_linha_prod_prod_ult_custo") && !TMethods.isEquals((Object)va.getDescricao(), (Object)"custo_pcp_linha_prod_prod_pr_medio")) continue;
            totalCusto = totalCusto + va.getValor();
        }
        DTOGraficoAnalisePrVendaCen.DataSet valorCusto = new DTOGraficoAnalisePrVendaCen.DataSet();
        valorCusto.setLabel("Valor Custo");
        valorCusto.setValue(ToolFormatter.arrredondarNumero((Double)totalCusto, (int)2));
        DTOGraficoAnalisePrVendaCen.DataSet valorVenda = new DTOGraficoAnalisePrVendaCen.DataSet();
        valorVenda.setLabel("Valor venda");
        valorVenda.setValue(ToolFormatter.arrredondarNumero((Double)cen.getResultado(), (int)2));
        custoXvenda.setDatasets(new LinkedList());
        custoXvenda.getDatasets().add(valorCusto);
        custoXvenda.getDatasets().add(valorVenda);
        return custoXvenda;
    }

    private DTOGraficoAnalisePrVendaCen buildChartComposicaoCusto(AnalisePrVendaProd ana) {
        DTOGraficoAnalisePrVendaCen composicaoCusto = new DTOGraficoAnalisePrVendaCen();
        composicaoCusto.setTitle("Composi\u00e7\u00e3o Custos");
        DTOGraficoAnalisePrVendaCen.DataSet celulas = new DTOGraficoAnalisePrVendaCen.DataSet();
        celulas.setLabel("Celulas(Indireto)");
        celulas.setValue(ToolFormatter.arrredondarNumero((Double)ana.getAnalisePrVendaPCPEnc().getValorTotalCel(), (int)2));
        DTOGraficoAnalisePrVendaCen.DataSet funcoes = new DTOGraficoAnalisePrVendaCen.DataSet();
        funcoes.setLabel("Funcoes(HH)");
        funcoes.setValue(ToolFormatter.arrredondarNumero((Double)ana.getAnalisePrVendaPCPEnc().getValorTotalFunc(), (int)2));
        DTOGraficoAnalisePrVendaCen.DataSet materiais = new DTOGraficoAnalisePrVendaCen.DataSet();
        materiais.setLabel("Materiais");
        materiais.setValue(ToolFormatter.arrredondarNumero((Double)ana.getAnalisePrVendaPCPEnc().getValorTotalMat(), (int)2));
        DTOGraficoAnalisePrVendaCen.DataSet outros = new DTOGraficoAnalisePrVendaCen.DataSet();
        outros.setLabel("Outros");
        outros.setValue(ToolFormatter.arrredondarNumero((Double)ana.getAnalisePrVendaPCPEnc().getValorTotalOutros(), (int)2));
        composicaoCusto.setDatasets(new LinkedList());
        composicaoCusto.getDatasets().add(celulas);
        composicaoCusto.getDatasets().add(funcoes);
        composicaoCusto.getDatasets().add(materiais);
        composicaoCusto.getDatasets().add(outros);
        return composicaoCusto;
    }

    public void processarFormulacaoFases(AnalisePrVendaProdEnc analisePrVendaProdPCPEnc, FormulacaoFases formulacao, RoteiroProducao roteiro, Empresa empresa, OpcoesFaturamento opcoesFaturamento, Double quantidade, EnumConstTipoCusto tipoCusto) {
        if (TMethods.isNull((Object)analisePrVendaProdPCPEnc).booleanValue()) {
            analisePrVendaProdPCPEnc = new AnalisePrVendaProdEnc();
        }
        analisePrVendaProdPCPEnc.getItensCelulaAnalPreco().clear();
        analisePrVendaProdPCPEnc.setFormulacaoFases(formulacao);
        analisePrVendaProdPCPEnc.setRoteiroProducao(roteiro);
        if (TMethods.isWithData((Collection)formulacao.getItemFormulacaoFases())) {
            Integer index = 0;
            for (ItemFormulacaoFases it : formulacao.getItemFormulacaoFases()) {
                AnalisePrVendaProdCelEnc gr = new AnalisePrVendaProdCelEnc();
                gr.setCelulaProdutiva(it.getFaseProdutiva().getCelulaProdutiva());
                gr.setIndice(index);
                gr.setHorasSetup(it.getFaseProdutiva().getTempoSetup());
                gr.setHorasExecucao(Double.valueOf(quantidade * it.getFaseProdutiva().getQtdePorHora()));
                gr.setHorasTotais(Double.valueOf(gr.getHorasExecucao() + gr.getHorasSetup()));
                gr.setValorPrevisto(it.getFaseProdutiva().getCelulaProdutiva().getValorCustoHora());
                gr.setValorTotal(Double.valueOf(gr.getHorasTotais() * gr.getValorPrevisto()));
                gr.setAnalisePrVendaProdPCPEnc(analisePrVendaProdPCPEnc);
                analisePrVendaProdPCPEnc.getItensCelulaAnalPreco().add(gr);
                for (ItemFormFasesProdutivas aux : it.getItensFormFasesProdutivas()) {
                    AnalisePrVendaProdCelMatEnc m = new AnalisePrVendaProdCelMatEnc();
                    m.setGradeCor(aux.getGradeCor());
                    m.setQuantidade(Double.valueOf(quantidade * aux.getQuantidade()));
                    m.setLargura(aux.getLargura());
                    m.setComprimento(aux.getComprimento());
                    m.setAltura(aux.getAltura());
                    m.setVolume(aux.getVolume());
                    this.scomp.buscarValorUnitarioMaterial(m, empresa, opcoesFaturamento, tipoCusto);
                    m.setAnalisePrVendaProdCelPCPEnc(gr);
                    gr.getItemMatCelulas().add(m);
                    this.sugerirPeso(m);
                }
                Integer n = index;
                index = index + 1;
            }
        }
    }

    private void sugerirPeso(AnalisePrVendaProdCelMatEnc i) {
        if (TMethods.isNotNull((Object)i.getGradeCor()).booleanValue()) {
            i.setPesoBruto(Double.valueOf((i.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario() + i.getGradeCor().getProdutoGrade().getProduto().getPesoEmbalagem()) * i.getQuantidade()));
            i.setPesoLiquido(Double.valueOf(i.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario() * i.getQuantidade()));
        }
    }
}

