/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.apuracaocustomensal;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.evento.EnumConstEventoParamFolha;
import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.ApuracaoCustoProvisao;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.EmpresaRh;
import com.touchcomp.basementor.model.vo.ItemCustoMensalColaborador;
import com.touchcomp.basementor.model.vo.ItemMovimentoFolha;
import com.touchcomp.basementor.model.vo.MovimentoFolha;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.itemprovisaodec.ServiceItemProvisaoDecImpl;
import com.touchcomp.basementorservice.service.impl.itemprovisaoferias.ServiceItemProvisaoFeriasImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperApuracaoCustoMensal
implements AbstractHelper<ApuracaoCustoProvisao> {
    ApuracaoCustoProvisao apuracao;
    @Autowired
    ServiceItemProvisaoDecImpl serviceItProvisaoDec;
    @Autowired
    ServiceItemProvisaoFeriasImpl serviceItProvisaoFerias;

    public ApuracaoCustoProvisao get() {
        return this.apuracao;
    }

    public HelperApuracaoCustoMensal build(ApuracaoCustoProvisao data) {
        this.apuracao = data;
        return this;
    }

    public List<ItemCustoMensalColaborador> calcularCustoMensalPorColaborador(List<MovimentoFolha> movsFolha, EmpresaRh empresaRh, Double percentualDesoneracao, Date periodoFinal) {
        ArrayList<ItemCustoMensalColaborador> ret = new ArrayList<ItemCustoMensalColaborador>();
        if (movsFolha != null) {
            for (MovimentoFolha vo : movsFolha) {
                Double vrBcInss = vo.getBcInssSalario() + vo.getBcInssFerias();
                Double vrFgtsSalario = vo.getVrFgtsSalario();
                ItemCustoMensalColaborador item = new ItemCustoMensalColaborador();
                item.setVlrCustoMensal(this.getValorCustoIndividual(vo));
                item.setInssEmpresa(this.getVlrInssEmpresa(vrBcInss, percentualDesoneracao, empresaRh));
                item.setVlrInssTerceiros(this.getVlrInssTerceiros(vrBcInss, empresaRh, vo.getColaborador()));
                item.setVlrFgts(vrFgtsSalario);
                item.setVlrMultaRecisao(this.getValorMultaRecisao(vrFgtsSalario));
                item.setVlrAvisoIndenizado(this.getValorAvisoIndenizado(vrBcInss, empresaRh));
                item.setColaborador(vo.getColaborador());
                item.setCentroCusto(vo.getColaborador().getCentroCusto());
                Double provisaoDec = 0.0;
                Double provisaoFerias = 0.0;
                if (vo.getAberturaPeriodo().getTipoCalculo().getTipoFolha().equals(EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue())) {
                    provisaoDec = this.getVlrProvisaoDec(vo.getColaborador(), periodoFinal);
                    provisaoFerias = this.getVlrProvisaoFerias(vo.getColaborador(), periodoFinal);
                }
                item.setProvisaoDec(provisaoDec);
                item.setProvisaoFerias(provisaoFerias);
                Double totalCustoColaborador = item.getVlrCustoMensal() + item.getVlrFgts() + item.getInssEmpresa() + item.getVlrInssTerceiros() + item.getVlrMultaRecisao() + item.getVlrAvisoIndenizado() + item.getProvisaoDec() + item.getProvisaoFerias();
                item.setTotalCustoColaborador(ToolFormatter.arrredondarNumero((Double)totalCustoColaborador, (int)2));
                ret.add(item);
            }
        }
        return ret;
    }

    public Double getVlrProvisaoDec(Colaborador colaborador, Date periodo) {
        return ToolFormatter.arrredondarNumero((Double)this.serviceItProvisaoDec.getVlrMensalColaboradorNoPeriodo(colaborador, periodo), (int)2);
    }

    public Double getVlrProvisaoFerias(Colaborador colaborador, Date periodo) {
        return ToolFormatter.arrredondarNumero((Double)this.serviceItProvisaoFerias.getVlrMensalColaboradorNoPeriodo(colaborador, periodo), (int)2);
    }

    public Double getVlrInssEmpresa(Double bcInss, Double percDesoneracao, EmpresaRh empresaRh) {
        if (percDesoneracao == 100.0) {
            return 0.0;
        }
        Double inss = bcInss * (empresaRh.getPercEmpresa() / 100.0);
        inss = inss * ((100.0 - percDesoneracao) / 100.0);
        return ToolFormatter.arrredondarNumero((Double)inss, (int)2);
    }

    public Double getVlrInssTerceiros(Double bcInss, EmpresaRh empresaRh, Colaborador colaborador) {
        if (!colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.EMPREGADO.getValue()) && !colaborador.getTipoColaborador().getIdentificador().equals(EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())) {
            return 0.0;
        }
        Double indiceFat = empresaRh.getIndiceFAP();
        Double percRat = empresaRh.getPercRat();
        Double rat = ToolFormatter.arrredondarNumero((Double)(bcInss * indiceFat * (percRat / 100.0)), (int)2);
        Double parteTerceiro = ToolFormatter.arrredondarNumero((Double)(bcInss * empresaRh.getPercTerceiros() / 100.0), (int)2);
        return ToolFormatter.arrredondarNumero((Double)(rat + parteTerceiro), (int)2);
    }

    public Double getValorMultaRecisao(Double vlrFgts) {
        return ToolFormatter.arrredondarNumero((Double)(vlrFgts * 0.4), (int)2);
    }

    public Double getValorAvisoIndenizado(Double vlrCusteio, EmpresaRh empresaRh) {
        Double percAvisoIndenizado = empresaRh.getPercDescontoAvisoIndenizadoCusteio();
        return ToolFormatter.arrredondarNumero((Double)(vlrCusteio * (percAvisoIndenizado / 100.0)), (int)2);
    }

    public Double getValorCustoIndividual(MovimentoFolha mov) {
        Double valorCusto = 0.0;
        for (ItemMovimentoFolha item : mov.getItensMovimentoFolha()) {
            if (item.getEventoColaborador().getTipoCalculoEvento().getCompoeCustoColaborador().equals(EnumConstantsMentorSimNao.SIM.getValue()) && item.getEventoColaborador().getTipoCalculoEvento().getEvento().getTipoEvento().equals(EnumConstEventoParamFolha.EVENTO_PROVENTO.getValue())) {
                valorCusto = valorCusto + item.getValor();
                continue;
            }
            if (!item.getEventoColaborador().getTipoCalculoEvento().getCompoeCustoColaborador().equals(EnumConstantsMentorSimNao.SIM.getValue())) continue;
            valorCusto = valorCusto - item.getValor();
        }
        return ToolFormatter.arrredondarNumero((Double)valorCusto, (int)2);
    }
}

