/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.arquivamentodoc;

import com.touchcomp.basementor.constants.enums.opcoessistema.EnumConstOpSistemaOp;
import com.touchcomp.basementor.helper.AbstractHelperVO;
import com.touchcomp.basementor.interfaces.EnumOpDinamicasInterface;
import com.touchcomp.basementor.model.vo.ArquivamentoDoc;
import com.touchcomp.basementor.model.vo.ArquivamentoDocItens;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.OpcoesSistema;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorrules.opcoesdinamicas.CompOpcoes;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoessistema.HelperOpcoesSistema;
import com.touchcomp.basementorservice.service.UtilServiceClass;
import com.touchcomp.basementorservice.service.impl.fileuploaddownload.DTOUploadDownloadFileConfig;
import com.touchcomp.basementortools.tools.file.ToolFile;
import com.touchcomp.basementortools.tools.image.ToolImage;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.awt.Dimension;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperArquivamentoDoc
implements AbstractHelperVO<ArquivamentoDoc> {
    private ArquivamentoDoc arquivamentoDoc;
    @Autowired
    private HelperOpcoesSistema helperOpcoesSistema;
    private static final int MAX_SIZE_FILE_MB = 10;

    public ArquivamentoDoc get() {
        return this.arquivamentoDoc;
    }

    public HelperArquivamentoDoc build(ArquivamentoDoc data) {
        this.arquivamentoDoc = data;
        return this;
    }

    public boolean acceptFile(File f, OpcoesSistema opcoes) {
        double megabytes;
        String size = (String)CompOpcoes.getOption(this.helperOpcoesSistema.getItens(), (EnumOpDinamicasInterface)EnumConstOpSistemaOp.TAMANHO_MAXIMO_ARQUIVOS_ANEXOS_SISTEMA, String.class);
        double sizeMB = 10.0;
        if (ToolMethods.isStrWithData((String)ToolString.onlyNumbers((String)size))) {
            sizeMB = Double.parseDouble(size);
        }
        return (megabytes = ToolFile.getSizeMb((File)f)) <= sizeMB;
    }

    public File resizeImage(File f, OpcoesSistema opcoes) throws ExceptionInvalidData, ExceptionIO {
        if (!ToolFile.isImage((File)f)) {
            return f;
        }
        String dimensionInf = (String)CompOpcoes.getOption(this.helperOpcoesSistema.getItens(), (EnumOpDinamicasInterface)EnumConstOpSistemaOp.DIMENSOES_MAXIMAS_IMAGEM_ANEXOS, String.class);
        if (!ToolMethods.isStrWithData((String)dimensionInf)) {
            return f;
        }
        String[] dimension = ToolString.splitString((String)dimensionInf, (char[])new char[0]);
        if (dimension.length != 2) {
            throw new ExceptionInvalidData("E.GEN.000067", new Object[]{dimensionInf});
        }
        String width = ToolString.onlyNumbers((String)dimension[0]);
        String heigth = ToolString.onlyNumbers((String)dimension[1]);
        if (!ToolMethods.isStrWithData((String)width)) {
            throw new ExceptionInvalidData("E.GEN.000067", new Object[]{dimensionInf});
        }
        if (!ToolMethods.isStrWithData((String)heigth)) {
            throw new ExceptionInvalidData("E.GEN.000067", new Object[]{dimensionInf});
        }
        Dimension din = new Dimension(Integer.parseInt(width), Integer.parseInt(heigth));
        return ToolImage.resizeImageKeepAspectRatio((File)f, (Dimension)din);
    }

    public ArquivamentoDocItens getNovoItem(File f) {
        ArquivamentoDocItens item = new ArquivamentoDocItens();
        item.setNomeArquivo(ToolFile.removeIlegalChars((String)f.getName()));
        item.setDescricao(ToolFile.removeIlegalChars((String)f.getName()));
        item.setPathArquivo(f.getAbsolutePath());
        return item;
    }

    public ArquivamentoDoc getNovoArquivamento(String descricao, String voClass, Long idRegistro, Empresa empresa) {
        String fullPath = UtilServiceClass.getFullPathEntity(voClass);
        ArquivamentoDoc arquiva = new ArquivamentoDoc();
        arquiva.setDescricao(descricao);
        arquiva.setEmpresa(empresa);
        arquiva.setIdRegistro(idRegistro);
        arquiva.setVoClass(fullPath);
        return arquiva;
    }

    public ArquivamentoDocItens getNovoItem(DTOUploadDownloadFileConfig.DTOItem chave) {
        ArquivamentoDocItens item = new ArquivamentoDocItens();
        item.setDescricao(chave.getFileName());
        item.setNomeArquivo(chave.getFileName());
        item.setPathArquivo(chave.getChave());
        return item;
    }

    public ArquivamentoDoc getNovoArquivamento(String descricao, String voClass, Long idRegistro, Empresa empresa, Nodo nodo) {
        ArquivamentoDoc arquiva = this.getNovoArquivamento(descricao, voClass, idRegistro, empresa);
        arquiva.setNodo(nodo);
        return arquiva;
    }
}

