/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.baixatitulos;

import com.touchcomp.basementor.constants.enums.baixatitulo.EnumConstTipoBaixaTitulos;
import com.touchcomp.basementor.model.vo.BaixaTitulo;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.ContasBaixa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EmpresaFinanceiro;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeisBaixaTitulos;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorexceptions.exceptions.model.ExcepCodeDetail;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.titulo.HelperTitulos;
import com.touchcomp.basementorservice.service.impl.opcoescontabeisbaixatitulos.ServiceOpcoesContabeisBaixaTitulosImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperBaixaTitulos
implements AbstractHelper<BaixaTitulo> {
    private BaixaTitulo baixaTitulos;
    @Autowired
    private HelperTitulos helperTitulos;
    @Autowired
    private ServiceOpcoesContabeisBaixaTitulosImpl serviceOpcoesContabeisBaixaTitulosImpl;
    HashMap hashMapOpContBaixaTitulos = new HashMap();

    public HelperBaixaTitulos build(BaixaTitulo baixaTitulo) {
        this.baixaTitulos = baixaTitulo;
        return this;
    }

    public BaixaTitulo get() {
        return this.baixaTitulos;
    }

    public Double calcularVrJuros() {
        return this.calcularVrJuros(new Date());
    }

    public void calcAndSetVrJuros(Date dataBase) {
        Double vr = this.calcularVrJuros(dataBase);
        this.baixaTitulos.setVrJuros(vr);
    }

    public Double calcularVrJuros(Date dataBase) {
        return this.helperTitulos.build(this.baixaTitulos.getTitulo()).calcularVrJuros(dataBase);
    }

    public Double calcularVrMulta() {
        return this.calcularVrMulta(new Date());
    }

    public void calcAndSetVrMulta(Date dataBase) {
        Double vr = this.calcularVrMulta(dataBase);
        this.baixaTitulos.setVrMulta(vr);
    }

    public Double calcularVrMulta(Date dataBase) {
        return this.helperTitulos.build(this.baixaTitulos.getTitulo()).calcularVrMulta(dataBase);
    }

    public Double calcularVrDesconto(Date dataBase) {
        return this.helperTitulos.build(this.baixaTitulos.getTitulo()).calcularVrDesconto(dataBase);
    }

    public void calcAndSetVrDesconto(Date dataBase) {
        if (this.baixaTitulos.getVrDesconto() <= 0.0) {
            Double vr = this.calcularVrDesconto(dataBase);
            this.baixaTitulos.setVrDesconto(vr);
        }
    }

    public void calcValores(Date dataBase) {
        this.calcAndSetVrJuros(dataBase);
        this.calcAndSetVrMulta(dataBase);
        this.calcAndSetVrDesconto(dataBase);
    }

    public BaixaTitulo novaBaixaTitulos(Titulo titulo, EnumConstTipoBaixaTitulos origemBaix, Double valorBaixa, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) {
        BaixaTitulo b = new BaixaTitulo();
        b.setTitulo(titulo);
        b.setVrAbatimento(titulo.getVrAbatimento());
        b.setVrDespBancariaPaga(titulo.getValorDespBancPaga());
        if (b.getVrDesconto() == null) {
            b.setVrDesconto(Double.valueOf(0.0));
        }
        b.setVrIOFPago(Double.valueOf(titulo.getVrIofPago() != null ? titulo.getVrIofPago() : 0.0));
        b.setValor(titulo.getValorSaldo());
        b.setVrDesconto(titulo.getDescontoFinanceiro());
        b.setValor(valorBaixa);
        b.setValorAdicional(titulo.getValorAdicional());
        b.setVrMultaEmbutido(this.calcularMultaEmbutida(b, titulo));
        b.setVrJurosEmbutido(this.calcularJurosEmbutidos(b, titulo));
        b.setVrTaxaCartao(titulo.getValorTaxaCartao());
        this.build(b);
        this.createAndSetContasBaixa(titulo, origemBaix, empresa, opGer);
        return b;
    }

    public BaixaTitulo novaBaixaTitulosRetornoCNAB(Titulo titulo, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, EnumConstTipoBaixaTitulos origemBaix, Double valorBaixa, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) {
        BaixaTitulo b = new BaixaTitulo();
        b.setTitulo(titulo);
        b.setVrAbatimento(titulo.getVrAbatimento());
        b.setVrDespBancariaPaga(titulo.getValorDespBancPaga());
        if (b.getVrDesconto() == null) {
            b.setVrDesconto(Double.valueOf(0.0));
        }
        b.setVrIOFPago(Double.valueOf(titulo.getVrIofPago() != null ? titulo.getVrIofPago() : 0.0));
        b.setValor(titulo.getValorSaldo());
        b.setVrDesconto(titulo.getDescontoFinanceiro());
        b.setValorAdicional(titulo.getValorAdicional());
        b.setVrMultaEmbutido(this.calcularMultaEmbutida(b, titulo));
        b.setVrJurosEmbutido(this.calcularJurosEmbutidos(b, titulo));
        b.setVrTaxaCartao(titulo.getValorTaxaCartao());
        this.build(b);
        this.createAndSetContasBaixa(titulo, origemBaix, empresa, opGer);
        return b;
    }

    public BaixaTitulo novaBaixaTitulosCalcValores(Titulo titulo, Date dataBase, EnumConstTipoBaixaTitulos origemBaix, Double valorBaixa, EmpresaFinanceiro empresaFinanceiro, Empresa empresa, OpcoesGerenciais opGer) {
        BaixaTitulo b = this.novaBaixaTitulos(titulo, origemBaix, valorBaixa, empresaFinanceiro, empresa, opGer);
        this.calcValores(dataBase);
        return b;
    }

    public void updateContaBaixa(OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesGerenciais opGer) {
        ContasBaixa c = new ContasBaixa();
        this.definePlanosConta(c, this.baixaTitulos, opcoesContabeisBaixaTitulos, EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_PADRAO);
        this.defineCentrosCusto(c, this.baixaTitulos, opcoesContabeisBaixaTitulos, opGer);
        this.baixaTitulos.setContasBaixa(c);
    }

    public void createAndSetContasBaixa(Titulo t, EnumConstTipoBaixaTitulos origemBaixa, Empresa empresa, OpcoesGerenciais opGer) {
        ContasBaixa c = this.baixaTitulos.getContasBaixa();
        if (c == null) {
            c = new ContasBaixa();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(t.getPagRec());
        sb.append("-");
        sb.append(t.getTipoDoc().getIdentificador());
        sb.append("-");
        sb.append(this.getStringClassifPessoa(t.getClassificacaoPessoa()));
        sb.append("-");
        sb.append(1);
        sb.append("-");
        sb.append(empresa.getIdentificador());
        String chave = sb.toString();
        OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos = null;
        if (this.hashMapOpContBaixaTitulos != null && this.hashMapOpContBaixaTitulos.get(chave) != null) {
            opcoesContabeisBaixaTitulos = (OpcoesContabeisBaixaTitulos)this.hashMapOpContBaixaTitulos.get(chave);
        } else {
            opcoesContabeisBaixaTitulos = this.serviceOpcoesContabeisBaixaTitulosImpl.findOpcaoContabilBaixaTituloComFormaPagCache(t.getPagRec(), t.getTipoDoc(), t.getClassificacaoPessoa(), (short)1, empresa);
            this.hashMapOpContBaixaTitulos.put(chave, opcoesContabeisBaixaTitulos);
        }
        if (opcoesContabeisBaixaTitulos == null) {
            throw new ExceptionRuntimeBase(new ExcepCodeDetail("E.ERP.0318.001"));
        }
        this.definePlanosConta(c, this.baixaTitulos, opcoesContabeisBaixaTitulos, origemBaixa);
        this.defineCentrosCusto(c, this.baixaTitulos, opcoesContabeisBaixaTitulos, opGer);
        this.baixaTitulos.setContasBaixa(c);
    }

    private void defineCentrosCusto(ContasBaixa c, BaixaTitulo baixa, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, OpcoesGerenciais opGer) {
        if (opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao() != null) {
            c.setCentroCustoAbatimento(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoAt(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoCartorio(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoCofins(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoContrSoc(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoDesc(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoDespBanc(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoIof(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoJuros(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoMulta(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoPis(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoIR(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoVrAdicional(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoFaltaPagamento(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
            c.setCentroCustoTaxaCartao(opcoesContabeisBaixaTitulos.getCentroCustoLiquidacao());
        } else if (opGer != null && TMethods.isAffirmative((Number)opGer.getLancarCentroCusto()) && baixa.getTitulo().getLancCtbGerencial() != null && !baixa.getTitulo().getLancCtbGerencial().isEmpty() && ((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto() != null) {
            c.setCentroCustoAbatimento(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoAt(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoCartorio(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoCofins(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoContrSoc(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoDesc(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoDespBanc(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoIof(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoJuros(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoMulta(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoPis(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoVrAdicional(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoFaltaPagamento(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoIR(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
            c.setCentroCustoTaxaCartao(((LancamentoCtbGerencial)baixa.getTitulo().getLancCtbGerencial().get(0)).getCentroCusto());
        }
    }

    private void definePlanosConta(ContasBaixa c, BaixaTitulo baixa, OpcoesContabeisBaixaTitulos opcoesContabeisBaixaTitulos, EnumConstTipoBaixaTitulos origemBaixa) {
        if (baixa.getTitulo().getPagRec() == 1) {
            c.setPlanoConta(baixa.getTitulo().getPlanoConta());
            c.setPlanoContaJuros(opcoesContabeisBaixaTitulos.getPlanoContaJuros1());
            c.setPlanoContaTaxaCartao(opcoesContabeisBaixaTitulos.getPcCartaoCredito());
            c.setPlanoContaDesc(opcoesContabeisBaixaTitulos.getPlanoContaDesc1());
            c.setPlanoContaAbatimento(opcoesContabeisBaixaTitulos.getPcAbatimentosRecebidos());
            c.setPlanoContaAtualMonRecebida(opcoesContabeisBaixaTitulos.getPlanoContaAt1());
            c.setPlanoContaAtualMonPaga(opcoesContabeisBaixaTitulos.getPlanoContaAt2());
            if (origemBaixa != null && origemBaixa.equals((Object)EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB)) {
                c.setPlanoContaDespBancCnabPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabPag());
                c.setPlanoContaDespBancCnabRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabRec());
            } else {
                c.setPlanoContaDespBancPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBan2());
                c.setPlanoContaDespBancRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBan1());
            }
            c.setPlanoContaIofPag(opcoesContabeisBaixaTitulos.getPcIOFPagos());
            c.setPlanoContaIofRec(opcoesContabeisBaixaTitulos.getPcIOFRecebidos());
            c.setPlanoContaMulta(opcoesContabeisBaixaTitulos.getPlanoContaMulta1());
            c.setPlanoContaPis(opcoesContabeisBaixaTitulos.getPlanoPis1());
            c.setPlanoContaCofins(opcoesContabeisBaixaTitulos.getPlanoConfins1());
            c.setPlanoContaContrSoc(opcoesContabeisBaixaTitulos.getPlanoContrSoc1());
            c.setPlanoContaMultaEmb(opcoesContabeisBaixaTitulos.getPcMultaEmbutidaRec());
            c.setPlanoContaJurosEmb(opcoesContabeisBaixaTitulos.getPcJurosEmbutidoRec());
            c.setPlanoContaAntecipacao(opcoesContabeisBaixaTitulos.getPlanoContaBaixaAntRec());
            c.setPlanoContaDescontosEmb(opcoesContabeisBaixaTitulos.getPcDescEmbutidoRec());
            c.setPlanoContaCartorioPag(opcoesContabeisBaixaTitulos.getPlanoDespesaCartorioPag());
            c.setPlanoContaCartorioRec(opcoesContabeisBaixaTitulos.getPlanoDespesaCartorioRec());
            c.setPlanoContaValorAdd(opcoesContabeisBaixaTitulos.getPcVrAdicionalRecebido());
            c.setPlanoContaIR(opcoesContabeisBaixaTitulos.getPlanoContaIRRec());
            c.setPlanoContaGerencialTaxaCartao(opcoesContabeisBaixaTitulos.getPlanoGerencialCartaoCredito());
            c.setPlanoContaGerencialJuros(opcoesContabeisBaixaTitulos.getPlanoContaJuros1Gerencial());
            c.setPlanoContaGerencialDesc(opcoesContabeisBaixaTitulos.getPlanoContaDesc2Gerencial());
            c.setPlanoContaGerencialAbatimento(opcoesContabeisBaixaTitulos.getPlanoAbatimentoRecebimentoGerencial());
            c.setPlanoContaGerencialAtualMonRecebida(opcoesContabeisBaixaTitulos.getPlanoContaAt1Gerencial());
            c.setPlanoContaGerencialAtualMonPaga(opcoesContabeisBaixaTitulos.getPlanoContaAt2Gerencial());
            if (origemBaixa != null && origemBaixa.equals((Object)EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB)) {
                c.setPlanoContaGerencialDespBancCnabPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabGerencialPag());
                c.setPlanoContaGerencialDespBancCnabRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabGerencialRec());
            } else {
                c.setPlanoContaGerencialDespBancPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBan2Gerencial());
                c.setPlanoContaGerencialDespBancRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBan1Gerencial());
            }
            c.setPlanoContaGerencialIofPag(opcoesContabeisBaixaTitulos.getPlanoIOFPagamentoGerencial());
            c.setPlanoContaGerencialIofRec(opcoesContabeisBaixaTitulos.getPlanoIOFRecebimentoGerencial());
            c.setPlanoContaGerencialMulta(opcoesContabeisBaixaTitulos.getPlanoContaMulta1Gerencial());
            c.setPlanoContaGerencialPis(opcoesContabeisBaixaTitulos.getPlanoPis1Gerencial());
            c.setPlanoContaGerencialCofins(opcoesContabeisBaixaTitulos.getPlanoConfins1Gerencial());
            c.setPlanoContaGerencialContrSoc(opcoesContabeisBaixaTitulos.getPlanoContrSoc1Gerencial());
            c.setPlanoContaGerencialCartorioPag(opcoesContabeisBaixaTitulos.getPlanoGerencialDespCartorioPag());
            c.setPlanoContaGerencialCartorioRec(opcoesContabeisBaixaTitulos.getPlanoGerencialDespCartorioRec());
            c.setPlanoContaGerencialVrAdd(opcoesContabeisBaixaTitulos.getPlanoGerencialVrAdicionalRecebido());
            c.setPlanoContaGerencialIR(opcoesContabeisBaixaTitulos.getPlanoGerencialIRRec());
        } else {
            c.setPlanoConta(baixa.getTitulo().getPlanoConta());
            c.setPlanoContaTaxaCartao(opcoesContabeisBaixaTitulos.getPcCartaoCredito());
            c.setPlanoContaJuros(opcoesContabeisBaixaTitulos.getPlanoContaJuros2());
            c.setPlanoContaDesc(opcoesContabeisBaixaTitulos.getPlanoContaDesc2());
            c.setPlanoContaAbatimento(opcoesContabeisBaixaTitulos.getPcAbatimentosPagos());
            c.setPlanoContaAtualMonRecebida(opcoesContabeisBaixaTitulos.getPlanoContaAt1());
            c.setPlanoContaAtualMonPaga(opcoesContabeisBaixaTitulos.getPlanoContaAt2());
            if (origemBaixa != null && origemBaixa.equals((Object)EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB)) {
                c.setPlanoContaDespBancCnabPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabPag());
                c.setPlanoContaDespBancCnabRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabRec());
            } else {
                c.setPlanoContaDespBancPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBan2());
                c.setPlanoContaDespBancRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBan1());
            }
            c.setPlanoContaIofPag(opcoesContabeisBaixaTitulos.getPcIOFPagos());
            c.setPlanoContaIofRec(opcoesContabeisBaixaTitulos.getPcIOFRecebidos());
            c.setPlanoContaMulta(opcoesContabeisBaixaTitulos.getPlanoContaMulta2());
            c.setPlanoContaPis(opcoesContabeisBaixaTitulos.getPlanoPis2());
            c.setPlanoContaCofins(opcoesContabeisBaixaTitulos.getPlanoConfins2());
            c.setPlanoContaContrSoc(opcoesContabeisBaixaTitulos.getPlanoContrSoc2());
            c.setPlanoContaMultaEmb(opcoesContabeisBaixaTitulos.getPcMultaEmbutidaPag());
            c.setPlanoContaJurosEmb(opcoesContabeisBaixaTitulos.getPcJurosEmbutidoPag());
            c.setPlanoContaAntecipacao(opcoesContabeisBaixaTitulos.getPlanoContaBaixaAntPag());
            c.setPlanoContaDescontosEmb(opcoesContabeisBaixaTitulos.getPcDescEmbutidoPag());
            c.setPlanoContaCartorioPag(opcoesContabeisBaixaTitulos.getPlanoDespesaCartorioPag());
            c.setPlanoContaCartorioRec(opcoesContabeisBaixaTitulos.getPlanoDespesaCartorioRec());
            c.setPlanoContaValorAdd(opcoesContabeisBaixaTitulos.getPcVrAdicionalPago());
            c.setPlanoContaIR(opcoesContabeisBaixaTitulos.getPlanoContaIRPag());
            c.setPlanoContaGerencialTaxaCartao(opcoesContabeisBaixaTitulos.getPlanoGerencialCartaoCredito());
            c.setPlanoContaGerencialJuros(opcoesContabeisBaixaTitulos.getPlanoContaJuros2Gerencial());
            c.setPlanoContaGerencialDesc(opcoesContabeisBaixaTitulos.getPlanoContaDesc1Gerencial());
            c.setPlanoContaGerencialAbatimento(opcoesContabeisBaixaTitulos.getPlanoAbatimentoPagamentoGerencial());
            c.setPlanoContaGerencialAtualMonPaga(opcoesContabeisBaixaTitulos.getPlanoContaAt2Gerencial());
            c.setPlanoContaGerencialAtualMonRecebida(opcoesContabeisBaixaTitulos.getPlanoContaAt1Gerencial());
            if (origemBaixa != null && origemBaixa.equals((Object)EnumConstTipoBaixaTitulos.BAIXA_TITULOS_ORIG_CNAB)) {
                c.setPlanoContaGerencialDespBancCnabPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabGerencialPag());
                c.setPlanoContaGerencialDespBancCnabRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBanCnabGerencialRec());
            } else {
                c.setPlanoContaGerencialDespBancPag(opcoesContabeisBaixaTitulos.getPlanoContaDespBan2Gerencial());
                c.setPlanoContaGerencialDespBancRec(opcoesContabeisBaixaTitulos.getPlanoContaDespBan1Gerencial());
            }
            c.setPlanoContaGerencialMulta(opcoesContabeisBaixaTitulos.getPlanoContaMulta2Gerencial());
            c.setPlanoContaGerencialPis(opcoesContabeisBaixaTitulos.getPlanoPis2Gerencial());
            c.setPlanoContaGerencialCofins(opcoesContabeisBaixaTitulos.getPlanoConfins2Gerencial());
            c.setPlanoContaGerencialContrSoc(opcoesContabeisBaixaTitulos.getPlanoContrSoc2Gerencial());
            c.setPlanoContaGerencialIofPag(opcoesContabeisBaixaTitulos.getPlanoIOFPagamentoGerencial());
            c.setPlanoContaGerencialIofRec(opcoesContabeisBaixaTitulos.getPlanoIOFRecebimentoGerencial());
            c.setPlanoContaGerencialCartorioPag(opcoesContabeisBaixaTitulos.getPlanoGerencialDespCartorioPag());
            c.setPlanoContaGerencialCartorioRec(opcoesContabeisBaixaTitulos.getPlanoGerencialDespCartorioRec());
            c.setPlanoContaGerencialVrAdd(opcoesContabeisBaixaTitulos.getPlanoGerencialVrAdicionalPago());
            c.setPlanoContaGerencialIR(opcoesContabeisBaixaTitulos.getPlanoGerencialIRPag());
        }
    }

    private String getStringClassifPessoa(ClassificacaoClientes classificacaoPessoa) {
        return classificacaoPessoa != null ? classificacaoPessoa.getIdentificador().toString() : "0";
    }

    public Double calcularJurosEmbutidos(BaixaTitulo b, Titulo t) {
        return ToolFormatter.arrredondarNumero((Double)(b.getValor() * t.getValorJurosEmbutido() / t.getValor()), (int)2);
    }

    public Double calcularMultaEmbutida(BaixaTitulo b, Titulo t) {
        return ToolFormatter.arrredondarNumero((Double)(b.getValor() * t.getValorMultaEmbutida() / t.getValor()), (int)2);
    }
}

