/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.businessintelligence;

import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligenceTipoInfValor;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFiles;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFormGer;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementor.model.vo.DadoAdicionalBI;
import com.touchcomp.basementor.model.vo.ValorFixoDadoAdicional;
import com.touchcomp.basementor.model.vo.WhereNodeBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.AuxBuildParamsPref;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.converter.impl.OpFinder;
import com.touchcomp.basementortools.tools.converter.impl.RestrictionOption;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.util.LinkedList;
import java.util.List;

class AuxBuildDTO {
    private final AuxBuildParamsPref buildParamsPref;

    public AuxBuildDTO(CompBIDefaultParams compDynamic) {
        this.buildParamsPref = new AuxBuildParamsPref(compDynamic);
    }

    public String getIdentificacaoBI(Long identificador, Long numeroBI) {
        if (ToolMethods.isWithData((Number)numeroBI)) {
            return String.valueOf("C-" + numeroBI);
        }
        return String.valueOf("I-" + identificador);
    }

    public DTOBusinessIntelligenceDet buildToDTO(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> compParams) throws ExceptionBuildBI {
        DTOBusinessIntelligenceDet det = new DTOBusinessIntelligenceDet();
        det.setDescricao(bi.getDescricao());
        det.setIdentificador(bi.getIdentificador());
        det.setObservacao(bi.getObservacao());
        det.setIdentificacao(this.getIdentificacaoBI(bi.getIdentificador(), bi.getNumeroBI()));
        det.setNrVersaoEstruturaBI(bi.getNrVersaoEstruturaBI());
        det.setNumeroBI(bi.getNumeroBI());
        det.setNumeroControle(bi.getNumeroControle());
        det.setNumeroVersao(bi.getNumeroVersao());
        det.setTituloRelatorio(bi.getTituloRelatorio());
        if (bi.getBusinessIntelligenceInf() != null) {
            DTOBusinessIntelligenceDet.DTOBusinessIntelligenceInf inf = new DTOBusinessIntelligenceDet.DTOBusinessIntelligenceInf();
            inf.setFiltrarEmpresa(bi.getBusinessIntelligenceInf().getFiltrarEmpresa());
            inf.setIdentificador(bi.getBusinessIntelligenceInf().getIdentificador());
            inf.setNomeArquivoGerado(bi.getBusinessIntelligenceInf().getNomeArquivoGerado());
            inf.setNomeImpressora(bi.getBusinessIntelligenceInf().getNomeImpressora());
            inf.setTipoImpressora(bi.getBusinessIntelligenceInf().getTipoImpressora());
        }
        if (bi.getBusinessIntelligenceObjetos() != null && bi.getBusinessIntelligenceObjetos().getClasseModeloBI() != null && bi.getBusinessIntelligenceObjetos().getClasseModeloBI().getNodosCondicao() != null) {
            det.getDadosAdicionais().addAll(this.setDadosObj(bi.getBusinessIntelligenceObjetos().getClasseModeloBI().getNodosCondicao(), bi.getBusinessIntelligenceObjetos().getClasseModeloBI()));
        }
        if (bi.getDadosAdicionalBI() != null) {
            det.getDadosAdicionais().addAll(this.setDadosAd(bi.getDadosAdicionalBI()));
        }
        this.setChavesLayouts(bi, det);
        this.setFormatosGeracao(bi, det, tipo);
        this.buildParamsPref.buildDefValuesParams(det, compParams);
        return det;
    }

    private List<DTOBusinessIntelligenceDet.DTODadoAdicional> setDadosAd(List<DadoAdicionalBI> dadosAdicionalBI) {
        LinkedList<DTOBusinessIntelligenceDet.DTODadoAdicional> ret = new LinkedList<DTOBusinessIntelligenceDet.DTODadoAdicional>();
        for (DadoAdicionalBI dado : dadosAdicionalBI) {
            DTOBusinessIntelligenceDet.DTODadoAdicional dd = new DTOBusinessIntelligenceDet.DTODadoAdicional();
            dd.setDescricao(dado.getDescricaoParametro());
            dd.setChave(dado.getChaveParametro());
            dd.setValorExpressao1(dado.getValorExpressao());
            dd.setValorExpressao2(dado.getValorExpressao());
            dd.setIdentificador(dado.getIdentificador());
            dd.setObservacao(dado.getObservacao());
            dd.setPermiteAlterarValor(dado.getPermitirAlterarValor());
            dd.setTipo(DTOBusinessIntelligenceDet.DTODadoAdicionalTipo.DADO_ADICIONAL);
            dd.setTipoCampo(dado.getClasseParametro());
            dd.setTipoCampoExibicao(dado.getClasseParametro());
            dd.setTipoInfValor(dado.getTipoInfValor());
            dd.setUtilizarTextoFormatado(dado.getUtilizarTextoFormatado());
            dd.setValorInformado(dado.getValorParametro());
            dd.setValorInformado1(dado.getValorParametro());
            dd.setValorObrigatorio(dado.getValorObrigatorio());
            dd.setOrganizacional(dado.getOrganizacional());
            dd.setUsarCondicaoIn(dado.getUsarCondicaoIn());
            if (ToolMethods.isAffirmative((Number)dado.getUsarCondicaoIn())) {
                dd.setTipoCampoExibicao(String.class.getCanonicalName());
            }
            dd.setClassePesquisaReflection(dado.getClassePesquisa());
            dd.setMetodoPesquisaReflection(dado.getMetodoPesquisa());
            ret.add(dd);
            this.setDadosFixos(dd, dado.getValorFixo());
            dd.setDadosAdicionais(this.setDadosAd(dado.getDadoAdicionalBIFilhos()));
        }
        return ret;
    }

    private void setDadosFixos(DTOBusinessIntelligenceDet.DTODadoAdicional dd, List<ValorFixoDadoAdicional> valores) {
        for (ValorFixoDadoAdicional vlrFixo : valores) {
            DTOBusinessIntelligenceDet.DTODadoAdicionalFixo fixo = new DTOBusinessIntelligenceDet.DTODadoAdicionalFixo();
            fixo.setDescricao(vlrFixo.getDescricao());
            fixo.setIdentificador(vlrFixo.getIdentificador());
            fixo.setValorInformado(vlrFixo.getValor());
            dd.getDadosFixos().add(fixo);
        }
    }

    private List<DTOBusinessIntelligenceDet.DTODadoAdicional> setDadosObj(List<WhereNodeBI> nodosCondicao, ClasseModeloBI classe) {
        LinkedList<DTOBusinessIntelligenceDet.DTODadoAdicional> ret = new LinkedList<DTOBusinessIntelligenceDet.DTODadoAdicional>();
        for (WhereNodeBI dado : nodosCondicao) {
            DTOBusinessIntelligenceDet.DTODadoAdicional dd = new DTOBusinessIntelligenceDet.DTODadoAdicional();
            dd.setIdentificador(dado.getIdentificador());
            dd.setDescricao(dado.getDescricao());
            Object chave = dado.getAtributo();
            if (dado.getFullPathAtributo() != null) {
                chave = dado.getFullPathAtributo() + dado.getAtributo();
            }
            dd.setChave((String)chave);
            dd.setValorExpressao1(dado.getValorExpressao1());
            dd.setValorExpressao2(dado.getValorExpressao2());
            dd.setUtilizarTextoFormatado(Short.valueOf((short)0));
            dd.setTipo(DTOBusinessIntelligenceDet.DTODadoAdicionalTipo.DADO_FILTRO_OBJETOS);
            dd.setObservacao(dado.getObservacao());
            dd.setTipoInfValor(dado.getTipoInfValor());
            dd.setPermiteAlterarValor(Short.valueOf(ToolMethods.isEquals((Object)1, (Object)dado.getTravarFiltro()) ? (short)0 : 1));
            dd.setOperacoes(this.getOperacoes(dado.getClasse()));
            dd.setValorInformado(dado.getParametro1());
            dd.setValorInformado1(dado.getParametro2());
            dd.setTipoCampo(dado.getClasse());
            dd.setTipoCampoExibicao(dado.getClasse());
            dd.setOperacao(dado.getOperacao());
            if (!ToolMethods.isEquals((Object)dado.getOpcao(), (Object)99)) {
                dd.setOrganizacional(Short.valueOf((short)1));
            } else {
                dd.setOrganizacional(Short.valueOf((short)0));
            }
            String fullPath = dado.getFullPathAtributo();
            String clazz = classe.getClasse();
            if (ToolMethods.isStrWithData((String)fullPath)) {
                clazz = classe.getClasse();
                if (fullPath != null && fullPath.endsWith(".")) {
                    fullPath = fullPath.substring(0, fullPath.length() - 1);
                }
                try {
                    clazz = ToolReflections.getClassEntityFromPath((String)clazz, (String)fullPath);
                }
                catch (ExceptionReflection ex) {
                    TLogger.get(this.getClass()).error((Throwable)ex);
                }
            }
            dd.setMetodoPesquisaReflection(dado.getAtributo());
            dd.setClassePesquisaReflection(clazz);
            ret.add(dd);
            dd.setDadosAdicionais(this.setDadosObj(dado.getFilhos(), classe));
        }
        return ret;
    }

    private List<DTOBusinessIntelligenceDet.DTODadoOperacoes> getOperacoes(String classe) {
        LinkedList<DTOBusinessIntelligenceDet.DTODadoOperacoes> t = new LinkedList<DTOBusinessIntelligenceDet.DTODadoOperacoes>();
        OpFinder o = CompRestrictionsFactory.getRestrictions((String)classe);
        for (Object r : o.getRestrictions()) {
            RestrictionOption rest = (RestrictionOption)r;
            DTOBusinessIntelligenceDet.DTODadoOperacoes d = new DTOBusinessIntelligenceDet.DTODadoOperacoes();
            d.setDescricao(rest.getDescription());
            d.setOperacao(Short.valueOf((short)rest.getRestriction().getValue()));
            t.add(d);
        }
        DTOBusinessIntelligenceDet.DTODadoOperacoes d = new DTOBusinessIntelligenceDet.DTODadoOperacoes();
        d.setDescricao(EnumConstantsCriteria.IN.getDescricao());
        d.setOperacao(Short.valueOf((short)EnumConstantsCriteria.IN.getValue()));
        t.add(d);
        return t;
    }

    private void setFormatosGeracao(BusinessIntelligence bi, DTOBusinessIntelligenceDet det, EnumConstTipoSistema tipo) {
        for (BusinessIntelligenceFormGer f : bi.getFormatosGeracao()) {
            if (!ToolMethods.isEquals((Object)1, (Object)f.getLiberar()) || f.getFormatoGeracaoBI() == null || !(tipo.equals((Object)EnumConstTipoSistema.INDIFERE) || tipo.equals((Object)EnumConstTipoSistema.DESKTOP) && ToolMethods.isEquals((Object)1, (Object)f.getFormatoGeracaoBI().getLiberarDesktop()) || tipo.equals((Object)EnumConstTipoSistema.MOBILE) && ToolMethods.isEquals((Object)1, (Object)f.getFormatoGeracaoBI().getLiberarMobile())) && (!tipo.equals((Object)EnumConstTipoSistema.WEB) || !ToolMethods.isEquals((Object)1, (Object)f.getFormatoGeracaoBI().getLiberarWeb()))) continue;
            DTOBusinessIntelligenceDet.DTOFormatoGeracao form = new DTOBusinessIntelligenceDet.DTOFormatoGeracao();
            form.setDescricao(f.getFormatoGeracaoBI().getDescricao());
            form.setIdentificador(f.getIdentificador());
            form.setTipo(f.getFormatoGeracaoBI().getTipo());
            det.getFormatosGeracao().add(form);
        }
    }

    void buildParamsToBI(BusinessIntelligence bi, DTOBusinessIntelligenceDet dto) {
        this.buildParamsToBi(bi, dto.getDadosAdicionais());
    }

    private void buildParamsToBi(BusinessIntelligence bi, List<DTOBusinessIntelligenceDet.DTODadoAdicional> dadosAdicionais) {
        for (DTOBusinessIntelligenceDet.DTODadoAdicional dd : dadosAdicionais) {
            DadoAdicionalBI d = this.getDadoAdicionalBI(bi.getDadosAdicionalBI(), dd.getChave());
            if (d != null) {
                d.setValorParametro(dd.getValorInformado());
                continue;
            }
            WhereNodeBI w = this.getWhereBI(bi.getBusinessIntelligenceObjetos().getClasseModeloBI().getNodosCondicao(), dd.getChave());
            if (w == null) continue;
            w.setParametro1(dd.getValorInformado());
            w.setParametro2(dd.getValorInformado1());
        }
    }

    private DadoAdicionalBI getDadoAdicionalBI(List<DadoAdicionalBI> dadosAdicionalBI, String chave) {
        DadoAdicionalBI found = null;
        for (DadoAdicionalBI d : dadosAdicionalBI) {
            if (ToolMethods.isEquals((Object)d.getChaveParametro(), (Object)chave)) {
                found = d;
                break;
            }
            found = this.getDadoAdicionalBI(d.getDadoAdicionalBIFilhos(), chave);
            if (found == null) continue;
            break;
        }
        return found;
    }

    private WhereNodeBI getWhereBI(List<WhereNodeBI> nodosCondicao, String chave) {
        WhereNodeBI found = null;
        for (WhereNodeBI d : nodosCondicao) {
            if (ToolMethods.isEquals((Object)d.getChave(), (Object)chave)) {
                found = d;
                break;
            }
            found = this.getWhereBI(d.getFilhos(), chave);
            if (found == null) continue;
            break;
        }
        return found;
    }

    private void setChavesLayouts(BusinessIntelligence bi, DTOBusinessIntelligenceDet det) {
        DTOBusinessIntelligenceDet.DTODadoAdicional d = new DTOBusinessIntelligenceDet.DTODadoAdicional();
        d.setChave("P_ROOT_REPORT_KEY_LAYOUT");
        d.setIdentificador(Long.valueOf(0L));
        d.setDescricao("Layouts");
        d.setOrganizacional(Short.valueOf((short)0));
        d.setPermiteAlterarValor(Short.valueOf((short)1));
        d.setTipoInfValor(Short.valueOf(EnumConstBusinessIntelligenceTipoInfValor.TIPO_DADO_ADICIONAL_VLR_PRE_DEF.getValue()));
        d.setTipo(DTOBusinessIntelligenceDet.DTODadoAdicionalTipo.DADO_ADICIONAL);
        d.setTipoCampo(String.class.getCanonicalName());
        d.setTipoCampoExibicao(String.class.getCanonicalName());
        for (BusinessIntelligenceFiles bf : bi.getBusinessIntelligenceFiles()) {
            if (!TMethods.isStrWithData((String)bf.getChaveLayout())) continue;
            DTOBusinessIntelligenceDet.DTODadoAdicionalFixo aux = new DTOBusinessIntelligenceDet.DTODadoAdicionalFixo();
            aux.setDescricao(bf.getChaveLayout());
            aux.setIdentificador(bf.getIdentificador());
            aux.setValorInformado(bf.getChaveLayout());
            d.getDadosFixos().add(aux);
        }
        if (!d.getDadosFixos().isEmpty()) {
            det.getDadosAdicionais().add(d);
        }
    }
}

