/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.businessintelligence;

import com.touchcomp.basementor.model.vo.CheckNodeBI;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class AuxBuildHQL {
    private Map<String, String> aliases = new HashMap<String, String>();

    public String buildHQL(List<CheckNodeBI> nodes, ClasseModeloBI modelo) {
        String entity = modelo.getClasse().substring(modelo.getClasse().lastIndexOf(".") + 1);
        String rootAlias = this.buildAlias("", entity);
        StringBuilder selectFields = new StringBuilder();
        StringBuilder joins = new StringBuilder();
        for (CheckNodeBI node : nodes) {
            String alias = this.getTempAlias(rootAlias, joins, node);
            selectFields.append(alias).append(".").append(node.getAtributo()).append(" as ").append((CharSequence)this.getSelectAliasField(alias, node.getAtributo())).append(",\n");
        }
        selectFields.delete(selectFields.length() - 2, selectFields.length());
        selectFields.append("\n");
        StringBuilder query = new StringBuilder();
        query.append("select ");
        query.append((CharSequence)selectFields);
        query.append(" from ");
        query.append(entity);
        query.append(" ");
        query.append(rootAlias);
        query.append("\n");
        query.append((CharSequence)joins);
        return query.toString();
    }

    private String getTempAlias(String rootAlias, StringBuilder joins, CheckNodeBI node) {
        if (!ToolMethods.isStrWithData((String)node.getFullPathAtributo())) {
            return rootAlias;
        }
        StringTokenizer sk = new StringTokenizer(node.getFullPathAtributo(), ".");
        String lastAlias = rootAlias;
        Object path = "";
        while (sk.hasMoreTokens()) {
            StringBuilder tempJoin = new StringBuilder();
            String tk = sk.nextToken();
            tempJoin.append("left join ");
            tempJoin.append(lastAlias);
            lastAlias = this.buildAlias((String)path, tk);
            path = tk + ".";
            tempJoin.append(".");
            tempJoin.append(tk);
            tempJoin.append(" ");
            tempJoin.append(lastAlias);
            if (joins.indexOf(tempJoin.toString()) >= 0) continue;
            joins.append((CharSequence)tempJoin);
            joins.append("\n");
        }
        return lastAlias;
    }

    private String buildAlias(String path, String entity) {
        String full = path + entity;
        if (this.aliases.containsKey(full)) {
            return this.aliases.get(full);
        }
        String temp = "";
        int start = 0;
        while (entity.length() >= start + 3) {
            temp = entity.substring(start, 3 + start);
            Collection<String> values = this.aliases.values();
            if (!values.contains(temp) && !this.isReserved(temp)) break;
            ++start;
        }
        temp = temp.toLowerCase();
        this.aliases.put(full, temp);
        return temp;
    }

    private StringBuilder getSelectAliasField(String alias, String atributo) {
        StringBuilder temp = new StringBuilder();
        temp.append(alias.toUpperCase());
        temp.append("_");
        if (atributo.length() > 30) {
            atributo = atributo.substring(0, 30);
        }
        Object aux = "";
        char[] data = atributo.toCharArray();
        char last = ' ';
        for (int i = 0; i < data.length; ++i) {
            char ch = data[i];
            if (Character.isUpperCase(ch) && !Character.isUpperCase(last)) {
                aux = (String)aux + "_";
            }
            aux = (String)aux + Character.toUpperCase(ch);
            last = ch;
        }
        temp.append(((String)aux).toUpperCase());
        return temp;
    }

    private boolean isReserved(String temp) {
        return this.getReservedWords().contains(temp.toUpperCase());
    }

    private List<String> getReservedWords() {
        LinkedList<String> data = new LinkedList<String>();
        data.add("END");
        data.add("BEGIN");
        data.add("AS");
        data.add("TO");
        data.add("FROM");
        data.add("WHERE");
        data.add("IN");
        data.add("SUM");
        data.add("MIN");
        data.add("AVG");
        data.add("MAX");
        data.add("NOT");
        data.add("FOR");
        return data;
    }
}

