/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.businessintelligence;

import com.touchcomp.basementor.constants.enums.ConstEnumFormImprBI;
import com.touchcomp.basementor.constants.enums.bi.EnumConstBusinessIntelligencePref;
import com.touchcomp.basementor.constants.enums.tiposistemastouch.EnumConstTipoSistema;
import com.touchcomp.basementor.model.impl.BusinessIntelligenceTemp;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.BusinessIntelligenceFormGer;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePref;
import com.touchcomp.basementor.model.vo.BusinessIntelligencePrefAss;
import com.touchcomp.basementor.model.vo.CheckNodeBI;
import com.touchcomp.basementor.model.vo.ClasseModeloBI;
import com.touchcomp.basementor.model.vo.FormatoGeracaoBI;
import com.touchcomp.basementorexceptions.exceptions.impl.builbusinessintelligence.ExceptionBuildBI;
import com.touchcomp.basementorexceptions.exceptions.impl.ioexception.ExceptionIO;
import com.touchcomp.basementorservice.components.businessintelligence.CompBIDefaultParams;
import com.touchcomp.basementorservice.components.businessintelligence.model.DefaultBIParamsMap;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.AuxBuildDTO;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.AuxBuildHQL;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.AuxBuildParamsPref;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.AuxBuildSQL;
import com.touchcomp.basementorservice.helpers.impl.businessintelligence.AuxSaveReadPref;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.businessintelligence.DTOBusinessIntelligenceDet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HelperBusinessIntelligence
implements AbstractHelper<BusinessIntelligence> {
    private BusinessIntelligence bi;
    private final AuxBuildDTO builder;
    private final AuxSaveReadPref saveReadPref;
    private final AuxBuildParamsPref buildParams;

    public HelperBusinessIntelligence(CompBIDefaultParams compDynamic) {
        this.builder = new AuxBuildDTO(compDynamic);
        this.saveReadPref = new AuxSaveReadPref();
        this.buildParams = new AuxBuildParamsPref(compDynamic);
    }

    public HelperBusinessIntelligence build(BusinessIntelligence bi) {
        this.bi = bi;
        return this;
    }

    public BusinessIntelligence get() {
        return this.bi;
    }

    public String getIdentificacaoBI() {
        return this.getIdentificacaoBI(this.bi.getIdentificador(), this.bi.getNumeroBI());
    }

    public String getIdentificacao(BusinessIntelligenceTemp bi) {
        return this.getIdentificacaoBI(bi.getIdentificador(), bi.getNumeroBI());
    }

    private String getIdentificacaoBI(Long identificador, Long numeroBI) {
        return this.builder.getIdentificacaoBI(identificador, numeroBI);
    }

    public String buildToObjectPreferences(DTOBusinessIntelligenceDet det) throws ExceptionIO {
        return this.saveReadPref.buildDadosPref(det);
    }

    public DTOBusinessIntelligenceDet buildToObjectPreferences(DTOBusinessIntelligenceDet det, BusinessIntelligencePref pref, ConstEnumFormImprBI formato) throws ExceptionIO {
        this.buildToObjectPreferences(det, pref);
        det.setFormatoSelecionado(formato);
        return det;
    }

    public DTOBusinessIntelligenceDet buildToObjectPreferences(DTOBusinessIntelligenceDet det, BusinessIntelligencePref pref) throws ExceptionIO {
        if (pref == null || det == null) {
            return det;
        }
        this.saveReadPref.readDadosPref(det, pref.getDadosUtilizados());
        det.setFechoBI(pref.getFechoBI());
        det.getAssinaturasBI().clear();
        for (BusinessIntelligencePrefAss ass : pref.getAssinaturasBI()) {
            det.getAssinaturasBI().add(new DTOBusinessIntelligenceDet.DTOBusinessIntelligencePrefAss(ass.getIdentificador(), ass.getNome(), ass.getCargo(), ass.getDocumentoIdentificacao()));
        }
        return det;
    }

    public void buildToTextPreferences(DTOBusinessIntelligenceDet det, BusinessIntelligencePref perfil) throws ExceptionIO {
        if (perfil == null) {
            return;
        }
        perfil.setDadosUtilizados(this.saveReadPref.buildDadosPref(det));
        perfil.setFechoBI(det.getFechoBI());
        LinkedList<BusinessIntelligencePrefAss> temp = new LinkedList<BusinessIntelligencePrefAss>();
        for (DTOBusinessIntelligenceDet.DTOBusinessIntelligencePrefAss dto : det.getAssinaturasBI()) {
            Optional<BusinessIntelligencePrefAss> found = perfil.getAssinaturasBI().stream().filter(i -> TMethods.isEquals((Object)i.getIdentificador(), (Object)dto.getIdentificador())).findFirst();
            if (found.isPresent()) {
                found.get().setNome(dto.getNome());
                found.get().setCargo(dto.getCargo());
                found.get().setDocumentoIdentificacao(dto.getDocumentoIdentificacao());
                temp.add(found.get());
                continue;
            }
            BusinessIntelligencePrefAss b = new BusinessIntelligencePrefAss();
            b.setNome(dto.getNome());
            b.setCargo(dto.getCargo());
            b.setDocumentoIdentificacao(dto.getDocumentoIdentificacao());
            temp.add(b);
        }
        perfil.getAssinaturasBI().clear();
        perfil.getAssinaturasBI().addAll(temp);
    }

    public void buildToTextPreferences(EnumConstTipoSistema tipoSistema, BusinessIntelligencePref perfil, DefaultBIParamsMap<String, Object> compParams) throws ExceptionIO, ExceptionBuildBI {
        DTOBusinessIntelligenceDet det = this.buildToDTO(tipoSistema, compParams);
        this.buildToTextPreferences(det, perfil);
    }

    public DTOBusinessIntelligenceDet buildToDTO(EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> compParams) throws ExceptionBuildBI {
        return this.builder.buildToDTO(this.bi, tipo, compParams);
    }

    public DTOBusinessIntelligenceDet buildToDTO(EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> compParams, BusinessIntelligencePref pref) throws ExceptionBuildBI, ExceptionIO {
        DTOBusinessIntelligenceDet ret = this.builder.buildToDTO(this.bi, tipo, compParams);
        this.buildToObjectPreferences(ret, pref);
        this.buildDefValuesParams(ret, compParams);
        return ret;
    }

    public DTOBusinessIntelligenceDet buildToDTO(BusinessIntelligence bi, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> compParams) throws ExceptionBuildBI {
        return this.builder.buildToDTO(bi, tipo, compParams);
    }

    public void buildDefValuesParams(DTOBusinessIntelligenceDet bi, DefaultBIParamsMap<String, Object> defParams) throws ExceptionBuildBI {
        this.buildParams.buildDefValuesParams(bi, defParams);
    }

    public BusinessIntelligencePref createPrefGlobal(EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> compParams) throws ExceptionIO, ExceptionBuildBI {
        FormatoGeracaoBI type = null;
        Optional<BusinessIntelligenceFormGer> found = this.bi.getFormatosGeracao().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getLiberar())).findFirst();
        if (found.isPresent()) {
            type = found.get().getFormatoGeracaoBI();
        }
        BusinessIntelligencePref pr = new BusinessIntelligencePref();
        pr.setBusinessIntelligence(this.bi);
        pr.setDescricao("Default");
        pr.setFormatoSaidaSel(type);
        pr.setTipo(Short.valueOf(EnumConstBusinessIntelligencePref.PREF_GLOBAL.getValue()));
        pr.setPreferenciaPadrao(Short.valueOf((short)1));
        this.buildToTextPreferences(tipo, pr, compParams);
        return pr;
    }

    public BusinessIntelligencePref createPrefUser(EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> params) throws ExceptionIO, ExceptionBuildBI {
        BusinessIntelligencePref pr = this.createPrefGlobal(tipo, params);
        pr.setTipo(Short.valueOf(EnumConstBusinessIntelligencePref.PREF_POR_USUARIO.getValue()));
        pr.setPreferenciaPadrao(Short.valueOf((short)1));
        pr.setUsuario(params.getUsuario());
        return pr;
    }

    public void reloadPref(BusinessIntelligencePref perfil, EnumConstTipoSistema tipo, DefaultBIParamsMap<String, Object> compParams) throws ExceptionIO, ExceptionBuildBI {
        this.buildToTextPreferences(tipo, perfil, compParams);
    }

    public void updateParamsBI(DTOBusinessIntelligenceDet dto) {
        this.builder.buildParamsToBI(this.bi, dto);
    }

    public String buildHQL(ClasseModeloBI classeModelo, List<CheckNodeBI> nodes) {
        return new AuxBuildHQL().buildHQL(nodes, classeModelo);
    }

    public String buildSQL(ClasseModeloBI classeModelo, List<CheckNodeBI> nodes) {
        return new AuxBuildSQL().buildSQL(nodes, classeModelo);
    }
}

