/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.calculofrete;

import com.touchcomp.basementor.model.vo.CalculoFrete;
import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementor.model.vo.ConstantsCalcFrete;
import com.touchcomp.basementor.model.vo.FormulaCalculoFrete;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.ValorVariavelFormulaCalcFrete;
import com.touchcomp.basementor.model.vo.VariavelFormulaCalcFrete;
import com.touchcomp.basementorexceptions.exceptions.impl.jepparser.ExceptionJEPParser;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.tabelacalculofrete.ServiceTabelaCalculoFreteImpl;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.model.string.StringToken;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Ceil;
import org.nfunk.jep.function.Floor;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Round;
import org.springframework.stereotype.Component;

@Component
public class HelperCalculoFrete
implements AbstractHelper<CalculoFrete> {
    private CalculoFrete calculoFrete;

    public CalculoFrete get() {
        return this.calculoFrete;
    }

    public HelperCalculoFrete build(CalculoFrete object) {
        this.calculoFrete = object;
        return this;
    }

    public Double calcularValorFrete(Transportador transp, Cidade destino, HashMap valores) throws ExceptionJEPParser {
        ServiceTabelaCalculoFreteImpl service = (ServiceTabelaCalculoFreteImpl)Context.get(ServiceTabelaCalculoFreteImpl.class);
        TabelaCalculoFrete vo = service.findCalculoFrete(transp, destino);
        return this.calcularValorFrete(vo, valores);
    }

    public Double calcularValorFrete(Transportador transp, HashMap valores) throws ExceptionJEPParser {
        ServiceTabelaCalculoFreteImpl service = (ServiceTabelaCalculoFreteImpl)Context.get(ServiceTabelaCalculoFreteImpl.class);
        TabelaCalculoFrete vo = service.findCalculoFrete(transp);
        return this.calcularValorFrete(vo, valores);
    }

    public Double calcularValorFrete(TabelaCalculoFrete vo, HashMap valores) throws ExceptionJEPParser {
        try {
            if (vo == null) {
                return 0.0;
            }
            JEP myParser = new JEP();
            this.putConstants(vo, valores);
            FormulaCalculoFrete found = this.getFormulaCalculoFrete(vo, valores);
            double valorFrete = 0.0;
            if (found != null) {
                List tokens = ToolString.getReplaceTokens((String)found.getCalculo());
                tokens = this.filtrarTokens(tokens);
                for (Object ob : tokens) {
                    StringToken s = (StringToken)ob;
                    myParser.addVariable(s.getChave(), valores.get(s.getChave()));
                }
                this.setFunctions(myParser);
                myParser.parseExpression(this.clearArrobas(found.getCalculo()));
                valorFrete = myParser.getValue();
                if (String.valueOf(valorFrete).equalsIgnoreCase("nan")) {
                    throw new ExceptionJEPParser("Formula: " + found.getCalculo() + "\n" + myParser.getErrorInfo());
                }
            }
            return valorFrete;
        }
        catch (ParseException ex) {
            throw new ExceptionJEPParser(ex, ex.getErrorInfo());
        }
    }

    private List filtrarTokens(List tokens) {
        ArrayList<StringToken> nvo = new ArrayList<StringToken>();
        for (Object o : tokens) {
            StringToken s = (StringToken)o;
            boolean b = false;
            for (Object e : nvo) {
                StringToken st = (StringToken)e;
                if (!st.getChave().equalsIgnoreCase(s.getChave())) continue;
                b = true;
                break;
            }
            if (b) continue;
            nvo.add(s);
        }
        return nvo;
    }

    private void setFunctions(JEP myParser) {
        myParser.addFunction("arredondar", (PostfixMathCommandI)new Round());
        myParser.addFunction("teto", (PostfixMathCommandI)new Ceil());
        myParser.addFunction("piso", (PostfixMathCommandI)new Floor());
    }

    private FormulaCalculoFrete getFormulaCalculoFrete(TabelaCalculoFrete vo, HashMap valores) throws ParseException, ExceptionJEPParser {
        JEP myParser = new JEP();
        FormulaCalculoFrete found = null;
        for (Object o : vo.getFormulas()) {
            FormulaCalculoFrete f = (FormulaCalculoFrete)o;
            List tokens = ToolString.getReplaceTokens((String)f.getCondicaoAplicacao());
            this.putValoresVariaveis(f, valores);
            for (Object ob : tokens) {
                StringToken s = (StringToken)ob;
                myParser.addVariable(s.getChave(), valores.get(s.getChave()));
            }
            String cond = this.clearArrobas(f.getCondicaoAplicacao());
            try {
                Double b = (Double)myParser.evaluate(myParser.parseExpression(cond));
                if (b != 1.0) continue;
                found = f;
                break;
            }
            catch (ParseException ex) {
                throw new ExceptionJEPParser(ex, "Erro ao analisar a expressao " + cond);
            }
        }
        return found;
    }

    private String clearArrobas(String formula) {
        char[] aux = formula.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < aux.length; ++i) {
            if (aux[i] == '@') continue;
            sb.append(aux[i]);
        }
        return sb.toString();
    }

    private void putValoresVariaveis(FormulaCalculoFrete f, HashMap valores) throws ParseException {
        JEP myParser = new JEP();
        for (Object o : f.getVariavelFormulaCalcFrete()) {
            Object ob2;
            VariavelFormulaCalcFrete v = (VariavelFormulaCalcFrete)o;
            ValorVariavelFormulaCalcFrete found = null;
            for (Object ob2 : v.getValoresVariavel()) {
                Double b;
                ValorVariavelFormulaCalcFrete vv = (ValorVariavelFormulaCalcFrete)ob2;
                List tokens = ToolString.getReplaceTokens((String)vv.getCondicaoAplicacao());
                for (Object oc : tokens) {
                    StringToken s = (StringToken)oc;
                    System.out.println(s.getChave() + " = " + s.getValor());
                    myParser.addVariable(s.getChave(), valores.get(s.getChave()));
                }
                String cond = this.clearArrobas(vv.getCondicaoAplicacao());
                Node obj = myParser.parseExpression(cond);
                if (obj == null || (b = (Double)myParser.evaluate(obj)) != 1.0) continue;
                found = vv;
                break;
            }
            if (found == null) continue;
            List tokens = ToolString.getReplaceTokens((String)found.getCalculo());
            ob2 = tokens.iterator();
            while (ob2.hasNext()) {
                Object oc = ob2.next();
                StringToken s = (StringToken)oc;
                myParser.addVariable(s.getChave(), valores.get(s.getChave()));
            }
            String cond = this.clearArrobas(found.getCalculo());
            myParser.evaluate(myParser.parseExpression(cond));
            Double b = myParser.getValue();
            valores.put(found.getVariavelFormCalcFrete().getDescricao(), b);
        }
    }

    private void putConstants(TabelaCalculoFrete vo, HashMap valores) {
        for (Object o : vo.getCalculoFrete().getConstantsCalcFrete()) {
            ConstantsCalcFrete c = (ConstantsCalcFrete)o;
            valores.put(c.getDescricao(), Double.valueOf(c.getValor()));
        }
    }
}

