/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.calculos;

import com.touchcomp.basementor.constants.enums.tipofrete.EnumConstTipoFretePercentual;
import com.touchcomp.basementor.model.impl.ValoresPrecoItemPedido;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.TabelaPrecoBaseProduto;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.BaseMethods;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.usuario.HelperUsuario;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperCalcPrecosProduto
extends BaseMethods {
    @Autowired
    private HelperUsuario helperUsuario;
    @Autowired
    private HelperCondicoesPagamento helperCondicoesPagamento;

    public Map buildParameters(OpcoesFaturamento opcoesFaturamento, UnidadeFatCliente unidadeFatCliente, Representante representante, Produto produto, Moeda moeda, CondicoesPagamento condicoesPagamento, TabelaPrecoBaseProduto tabPrecoBaseProduto, TipoFrete tipoFrete, Empresa empresa, NaturezaOperacao naturezaOperacao, Usuario usuario) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        if (naturezaOperacao != null) {
            m.put(NaturezaOperacao.class.getCanonicalName(), naturezaOperacao);
        }
        if (opcoesFaturamento != null) {
            m.put(OpcoesFaturamento.class.getCanonicalName(), opcoesFaturamento);
        }
        if (unidadeFatCliente != null) {
            m.put(UnidadeFatCliente.class.getCanonicalName(), unidadeFatCliente);
        }
        if (representante != null) {
            m.put(Representante.class.getCanonicalName(), representante);
        }
        if (produto != null) {
            m.put(Produto.class.getCanonicalName(), produto);
        }
        if (moeda != null) {
            m.put(Moeda.class.getCanonicalName(), moeda);
        }
        if (condicoesPagamento != null) {
            m.put(CondicoesPagamento.class.getCanonicalName(), condicoesPagamento);
        }
        if (tipoFrete != null) {
            m.put(TipoFrete.class.getCanonicalName(), tipoFrete);
        }
        if (empresa != null) {
            m.put(Empresa.class.getCanonicalName(), empresa);
        }
        if (tabPrecoBaseProduto != null) {
            m.put(TabelaPrecoBaseProduto.class.getCanonicalName(), tabPrecoBaseProduto);
        }
        if (usuario != null) {
            m.put(Usuario.class.getCanonicalName(), usuario);
        }
        if (usuario != null) {
            Grupo gr = this.helperUsuario.getGrupo(usuario.getUsuarioBasico(), empresa);
            m.put(Grupo.class.getCanonicalName(), gr);
        }
        return m;
    }

    public void buildParametersAvaliacaoComissao(Double valorUnitario, Double valorMin, Double valorMax, Double percDesconto, Double percComissaoBase, int nrDiasMedios, TabelaPrecoBaseProduto tbp, Map values) {
        values.put(tbp.getClass().getCanonicalName(), tbp);
        values.put("pre_valor_minimo_calc_ped", valorMin);
        values.put("pre_valor_maximo_calc_ped", valorMax);
        values.put("pre_valor_unitario_inf", valorUnitario);
        values.put("pre_perc_desconto_inf", percDesconto);
        values.put("valorVenda", tbp.getValorVenda());
        values.put("pre_nr_dias_medios_cond_pag", nrDiasMedios);
        values.put("percentualComissao", percComissaoBase);
    }

    public void calcularValoresMajorados(ValoresPrecoItemPedido ret, CondicoesPagamento condicao, String parcelas, OpcoesFaturamento opFat) {
        Double valorVenda = ret.getValorSugerido();
        Double valorMinimo = ret.getValorMinimo();
        Double valorMaximo = ret.getValorMaximo();
        if (!this.isAffimative(opFat.getAplicarMajoracaoPrecoFechamentoPedido())) {
            valorMaximo = this.helperCondicoesPagamento.calcularValorTotalMajorado(valorMaximo, condicao, parcelas);
            valorVenda = this.helperCondicoesPagamento.calcularValorTotalMajorado(valorVenda, condicao, parcelas);
            valorMinimo = this.helperCondicoesPagamento.calcularValorTotalMajorado(valorMinimo, condicao, parcelas);
        }
        ret.setValorSugerido(valorVenda);
        ret.setValorMinimo(valorMinimo);
        ret.setValorMaximo(valorMaximo);
    }

    public void calculaValoresFrete(TipoFrete tipoFrete, ValoresPrecoItemPedido valores) {
        Double percFrete = 0.0;
        if (tipoFrete != null) {
            percFrete = tipoFrete.getPercFrete();
        }
        Double valorVenda = valores.getValorSugerido();
        Double valorMinimo = valores.getValorMinimo();
        Double valorMaximo = valores.getValorMaximo();
        if (tipoFrete != null && this.isEquals(tipoFrete.getOpcao(), EnumConstTipoFretePercentual.DESTACAR_PRECO_FRETE.getValue())) {
            valorVenda = valorVenda + tipoFrete.getPercFrete() / 100.0 * valores.getValorSugerido();
            valorMinimo = valorMinimo + tipoFrete.getPercFrete() / 100.0 * valores.getValorMinimo();
            valorMaximo = valorMaximo + tipoFrete.getPercFrete() / 100.0 * valores.getValorMaximo();
            percFrete = 0.0;
        }
        valores.setValorMinimo(valorMinimo);
        valores.setValorMaximo(valorMaximo);
        valores.setValorSugerido(valorVenda);
        valores.setPercFrete(percFrete);
    }
}

