/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.centrocusto;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroCustoEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.stereotype.Component;

@Component
public class HelperCentroCusto
implements AbstractHelper<CentroCusto> {
    private CentroCusto centroCusto;

    public CentroCusto get() {
        return this.centroCusto;
    }

    public HelperCentroCusto build(CentroCusto object) {
        this.centroCusto = object;
        return this;
    }

    public Integer getNivelCentroCusto(String codigo) {
        if (this.isNivel1(codigo)) {
            return 1;
        }
        if (this.isNivel2(codigo)) {
            return 2;
        }
        return 3;
    }

    private boolean isNivel1(String codigo) {
        return codigo.endsWith("000000");
    }

    private boolean isNivel2(String codigo) {
        if (!codigo.substring(0, 3).equals("000") && !codigo.substring(4, 7).equals("000")) {
            return codigo.endsWith("000");
        }
        return false;
    }

    public Boolean containsEmpresa(CentroCusto p, Empresa empresa) {
        if (p != null && p.getCentroCustoEmpresa() != null) {
            for (CentroCustoEmpresa cc : p.getCentroCustoEmpresa()) {
                if (!TMethods.isEquals((Object)cc.getEmpresa(), (Object)empresa)) continue;
                return true;
            }
        }
        return false;
    }
}

