/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.centroestoque;

import com.touchcomp.basementor.constants.enums.paramcentroestoque.EnumConstParamCenEstEntSai;
import com.touchcomp.basementor.model.deprecated.PreFaturamentoPed;
import com.touchcomp.basementor.model.deprecated.PreFaturamentoPedItem;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Fornecedor;
import com.touchcomp.basementor.model.vo.GradeItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemNotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ItemNotaTerceiros;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.NFCeItem;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoque;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.impl.paramcentroestoque.ServiceParamCentroEstoqueImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperCentroEstoque
implements AbstractHelper<CentroEstoque> {
    private CentroEstoque centroEstoque;
    @Autowired
    private ServiceParamCentroEstoqueImpl serviceCentroEstoqueImpl;

    public HelperCentroEstoque build(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
        return this;
    }

    public CentroEstoque get() {
        return this.centroEstoque;
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, UnidadeFatCliente unidadeFat) {
        if (unidadeFat == null) {
            return null;
        }
        return this.serviceCentroEstoqueImpl.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, unidadeFat.getCliente(), unidadeFat.getPessoa());
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, UnidadeFatCliente unidadeFat, Pessoa pessoa) {
        Cliente cliente = null;
        if (unidadeFat != null) {
            cliente = unidadeFat.getCliente();
        }
        return this.serviceCentroEstoqueImpl.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, cliente, pessoa);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, Cliente cliente, Pessoa parceiro) {
        return this.serviceCentroEstoqueImpl.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, cliente, parceiro);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, UnidadeFatFornecedor unidadeFat, Pessoa parceiro) {
        return this.serviceCentroEstoqueImpl.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, unidadeFat.getFornecedor(), parceiro);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, NaturezaOperacao naturezaOperacao, Fornecedor fornecedor, Pessoa parceiro) {
        return this.serviceCentroEstoqueImpl.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, naturezaOperacao, fornecedor, parceiro);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoesEstoque, Empresa empresa, Produto produto, Usuario usuario, EnumConstParamCenEstEntSai tipoParam) {
        return this.serviceCentroEstoqueImpl.getCentroEstoque(opcoesEstoque, empresa, produto, usuario, tipoParam);
    }

    public CentroEstoque getCentroEstoque(Empresa empresa, Produto produto, EnumConstParamCenEstEntSai tipoParam) {
        return this.serviceCentroEstoqueImpl.getCentroEstoque(empresa, produto, tipoParam);
    }

    public CentroEstoque getCentroEstoque(Empresa empresa, OpcoesEstoque opcoes, ItemNotaFiscalPropria item, Usuario usuario) {
        UnidadeFatCliente unid = null;
        Pessoa pessoa = null;
        NaturezaOperacao nat = null;
        if (item.getNotaFiscalPropria() != null && item.getNotaFiscalPropria().getUnidadeFatCliente() != null) {
            unid = item.getNotaFiscalPropria().getUnidadeFatCliente();
        }
        if (unid != null) {
            pessoa = unid.getPessoa();
        }
        if (item.getNotaFiscalPropria() != null) {
            nat = item.getNotaFiscalPropria().getNaturezaOperacao();
        }
        return this.getCentroEstoque(opcoes, empresa, item.getProduto(), usuario, nat, unid, pessoa);
    }

    public CentroEstoque getCentroEstoque(Empresa empresa, OpcoesEstoque opcoes, ItemNotaTerceiros item, Usuario usuario, Pessoa pessoa) {
        UnidadeFatFornecedor unid = null;
        if (item.getNotaFiscalTerceiros() != null && item.getNotaFiscalTerceiros().getUnidadeFatFornecedor() != null) {
            unid = item.getNotaFiscalTerceiros().getUnidadeFatFornecedor();
        }
        NaturezaOperacao nat = item.getNaturezaOperacao();
        return this.getCentroEstoque(opcoes, empresa, item.getProduto(), usuario, nat, unid, pessoa);
    }

    public CentroEstoque getCentroEstoque(Empresa empresa, OpcoesEstoque opcoes, ItemNotaTerceiros item, Usuario usuario) {
        UnidadeFatFornecedor unid = null;
        Pessoa pessoa = null;
        if (item.getNotaFiscalTerceiros() != null && item.getNotaFiscalTerceiros().getUnidadeFatFornecedor() != null) {
            unid = item.getNotaFiscalTerceiros().getUnidadeFatFornecedor();
        }
        if (!item.getGrade().isEmpty() && ((GradeItemNotaTerceiros)item.getGrade().get(0)).getEstoqueTerceiros() != null) {
            pessoa = ((GradeItemNotaTerceiros)item.getGrade().get(0)).getEstoqueTerceiros().getPessoaParceiro();
        }
        if (unid != null && pessoa == null) {
            pessoa = unid.getPessoa();
        }
        NaturezaOperacao nat = item.getNaturezaOperacao();
        return this.getCentroEstoque(opcoes, empresa, item.getProduto(), usuario, nat, unid, pessoa);
    }

    public CentroEstoque getCentroEstoque(Empresa empresa, OpcoesEstoque opcoes, ItemPedido item, Usuario usuario) {
        Pedido p = item.getPedido();
        if (p.getCentroEstoqueFat() != null) {
            return p.getCentroEstoqueFat();
        }
        if (TMethods.isAffirmative((Number)p.getReservarEstoque()) && p.getCentroEstoqueReserva() != null) {
            return p.getCentroEstoqueReserva();
        }
        if (item.getCentroEstoque() != null) {
            return item.getCentroEstoque();
        }
        UnidadeFatCliente unid = null;
        Pessoa pessoa = null;
        NaturezaOperacao nat = null;
        if (item.getPedido() != null && item.getPedido().getUnidadeFatCliente() != null) {
            unid = item.getPedido().getUnidadeFatCliente();
        }
        if (unid != null) {
            pessoa = unid.getPessoa();
        }
        if (item.getPedido() != null) {
            nat = item.getPedido().getNaturezaOperacao();
        }
        return this.getCentroEstoque(opcoes, empresa, item.getProduto(), usuario, nat, unid, pessoa);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoes, NFCeItem item, Usuario usuario) {
        if (item.getCentroEstoque() != null) {
            return item.getCentroEstoque();
        }
        Cliente cliente = null;
        Pessoa pessoa = null;
        NaturezaOperacao nat = null;
        if (item.getNfce() != null && item.getNfce().getUnidadeFatCliente() != null) {
            cliente = item.getNfce().getUnidadeFatCliente().getCliente();
        }
        if (item.getNfce() != null && item.getNfce().getUnidadeFatCliente() != null) {
            pessoa = item.getNfce().getUnidadeFatCliente().getPessoa();
        }
        if (item.getNfce() != null) {
            nat = item.getNfce().getNaturezaOperacao();
        }
        return this.getCentroEstoque(opcoes, opcoes.getEmpresa(), item.getProduto(), usuario, nat, cliente, pessoa);
    }

    public CentroEstoque getCentroEstoque(OpcoesEstoque opcoes, PreFaturamentoPedItem item, Usuario usuario) {
        PreFaturamentoPed p = item.getPreFaturamentoPed();
        if (p != null && p.getReservarEstoque() == 1) {
            return p.getCentroEstoqueReserva();
        }
        if (item.getCentroEstoque() != null) {
            return item.getCentroEstoque();
        }
        return this.getCentroEstoquePesquisa(opcoes, item, usuario);
    }

    public CentroEstoque getCentroEstoquePesquisa(OpcoesEstoque opcoes, PreFaturamentoPedItem item, Usuario usuario) {
        PreFaturamentoPed p = item.getPreFaturamentoPed();
        UnidadeFatCliente unid = null;
        Pessoa pessoa = null;
        NaturezaOperacao nat = null;
        if (p != null && p.getUnidadeFatCliente() != null) {
            unid = p.getUnidadeFatCliente();
        }
        if (unid != null) {
            pessoa = unid.getPessoa();
        }
        if (p != null) {
            nat = p.getNaturezaOperacao();
        }
        return this.getCentroEstoque(opcoes, opcoes.getEmpresa(), item.getProduto(), usuario, nat, unid, pessoa);
    }
}

