/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.cfop;

import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpEntSaidaFaturamento;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.service.interfaces.ServiceCfop;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperCfop
implements AbstractHelper<Cfop> {
    private Cfop cfop;
    @Autowired
    private ServiceCfop serviceCfop;

    public HelperCfop build(Cfop cfop) {
        this.cfop = cfop;
        return this;
    }

    public Cfop get() {
        return this.cfop;
    }

    public Cfop getCfop(NaturezaOperacao naturezaOperacao, UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal modeloFiscal) {
        return this.getCfop(naturezaOperacao, ufOrigem, ufDestino, modeloFiscal, null);
    }

    public Cfop getCfop(NaturezaOperacao naturezaOperacao, UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal modeloFiscal, EnumConstNFeIndicadorPresConsumidor indPresenca) {
        if (naturezaOperacao == null || ufOrigem == null || ufDestino == null || modeloFiscal == null) {
            return null;
        }
        if (ToolMethods.isEquals((Object)naturezaOperacao.getEntradaSaida(), (Object)1)) {
            String codigo = this.getCodigoSaida(ufOrigem, ufDestino, modeloFiscal, indPresenca);
            return this.serviceCfop.findByCodigo(codigo);
        }
        String codigo = this.getCodigoEntrada(ufOrigem, ufDestino, modeloFiscal);
        return this.serviceCfop.findByCodigo(codigo);
    }

    public Cfop getCfop(EnumConstNatOpEntSaidaFaturamento entradaSaida, UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal modeloFiscal, EnumConstNFeIndicadorPresConsumidor indPresenca) {
        if (ufOrigem == null || ufDestino == null || modeloFiscal == null) {
            return null;
        }
        if (ToolMethods.isEquals((Object)entradaSaida, (Object)EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_SAIDA)) {
            String codigo = this.getCodigoSaida(ufOrigem, ufDestino, modeloFiscal, indPresenca);
            return this.serviceCfop.findByCodigo(codigo);
        }
        String codigo = this.getCodigoEntrada(ufOrigem, ufDestino, modeloFiscal);
        return this.serviceCfop.findByCodigo(codigo);
    }

    public Cfop getCfop(EnumConstNatOpEntSaidaFaturamento entradaSaida, UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal modeloFiscal) {
        return this.getCfop(entradaSaida, ufOrigem, ufDestino, modeloFiscal, null);
    }

    private String getCodigoSaida(UnidadeFederativa ufEmpresa, UnidadeFederativa ufDestino, ModeloFiscal mod, EnumConstNFeIndicadorPresConsumidor indPresenca) {
        Object codigo = "";
        codigo = mod.getTipoCfop() != null && mod.getTipoCfop() == 2 ? "3." : (mod.getTipoCfop() != null && mod.getTipoCfop() == 1 ? "7." : (ufEmpresa.equals((Object)ufDestino) || ToolMethods.isEquals((Object)indPresenca, (Object)EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL) ? "5." : (!ufEmpresa.equals((Object)ufDestino) ? "6." : "7.")));
        codigo = (String)codigo + mod.getCfop();
        return codigo;
    }

    private String getCodigoEntrada(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal mod) {
        Object codigo = mod.getTipoCfop() != null && mod.getTipoCfop() == 2 ? "3." : (mod.getTipoCfop() != null && mod.getTipoCfop() == 1 ? "7." : (ufOrigem.equals((Object)ufDestino) ? "1." : (!ufOrigem.equals((Object)ufDestino) ? "2." : "3.")));
        codigo = (String)codigo + mod.getCfop();
        return codigo;
    }

    public Cfop geCfopEntrada(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal mod) {
        String codigo = this.getCodigoEntrada(ufOrigem, ufDestino, mod);
        return this.serviceCfop.findByCodigo(codigo);
    }

    public Cfop geCfopSaida(UnidadeFederativa ufOrigem, UnidadeFederativa ufDestino, ModeloFiscal mod, EnumConstNFeIndicadorPresConsumidor indPresenca) {
        String codigo = this.getCodigoSaida(ufOrigem, ufDestino, mod, indPresenca);
        return this.serviceCfop.findByCodigo(codigo);
    }

    public boolean isOperacaoExterior(Cfop c) {
        if (c == null) {
            return false;
        }
        return this.isOperacaoExteriorExportacao(c) || this.isOperacaoExteriorImportacao(c);
    }

    public boolean isOperacaoExteriorImportacao(Cfop c) {
        if (c == null) {
            return false;
        }
        return c.getCodigo().startsWith("3");
    }

    public boolean isOperacaoExteriorExportacao(Cfop c) {
        if (c == null) {
            return false;
        }
        return c.getCodigo().startsWith("7");
    }

    public boolean isOperacaoInterestadual(Cfop c) {
        if (c == null) {
            return false;
        }
        return c.getCodigo().startsWith("2") || c.getCodigo().startsWith("6");
    }

    public boolean isOperacaoEstadual(Cfop c) {
        if (c == null) {
            return false;
        }
        return c.getCodigo().startsWith("1") || c.getCodigo().startsWith("5");
    }
}

