/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.chequeterceiros;

import com.touchcomp.basementor.constants.enums.bancos.EnumConstBancos;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import org.springframework.stereotype.Component;

@Component
public class HelperChequeTerceiros
implements AbstractHelper<ChequeTerceiros> {
    ChequeTerceiros instance;

    public ChequeTerceiros get() {
        return this.instance;
    }

    public HelperChequeTerceiros build(ChequeTerceiros data) {
        this.instance = data;
        return this;
    }

    public void preencherDadosCheque(String cmc) {
        if (cmc != null && cmc.trim().length() > 29) {
            cmc = this.clear(cmc);
            String codigoBanco = cmc.substring(0, 3);
            this.instance.setBanco(codigoBanco);
            EnumConstBancos banco = EnumConstBancos.get((String)codigoBanco);
            if (banco != null) {
                switch (banco) {
                    case SANTANDER: {
                        this.setBancoSantander(cmc);
                        break;
                    }
                    case CAIXA: {
                        this.setBancoCaixa(cmc);
                        break;
                    }
                    case ITAU: {
                        this.setBancoItau(cmc);
                        break;
                    }
                    case SICOOB: {
                        this.setBancoSicoob(cmc);
                        break;
                    }
                    case BRADESCO: {
                        this.setBancoBradesco(cmc);
                        break;
                    }
                    case MERCANTIL: {
                        this.setBancoMercantil(cmc);
                        break;
                    }
                    case REAL: {
                        this.setBancoReal(cmc);
                        break;
                    }
                    default: {
                        this.setBancoGenerico(cmc);
                    }
                }
            }
        }
    }

    private void setBancoSantander(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(21, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoCaixa(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(20, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoItau(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(23, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoSicoob(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(19, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoBradesco(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(22, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoMercantil(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(19, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoReal(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(22, 29));
            this.instance.setContaCorrenteDC(cmc.substring(29, 30));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private void setBancoGenerico(String cmc) {
        if (this.instance != null) {
            this.instance.setAgencia(cmc.substring(3, 7));
            this.instance.setContaCorrente(cmc.substring(19, 28));
            this.instance.setContaCorrenteDC(cmc.substring(28, 29));
            this.instance.setNumero(Integer.valueOf(Integer.parseInt(cmc.substring(11, 17))));
        }
    }

    private String clear(String cmc) {
        cmc = cmc.replace("<", "");
        cmc = cmc.replace(">", "");
        cmc = cmc.replace("\u00c7", "");
        return cmc;
    }
}

