/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.cliente;

import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Complemento;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HelperCliente
implements AbstractHelper<Cliente> {
    private Cliente cliente;

    public HelperCliente build(Cliente cliente) {
        this.cliente = cliente;
        return this;
    }

    public Cliente get() {
        return this.cliente;
    }

    public UnidadeFatCliente criarUnidadeFatPadrao(Pessoa p) {
        UnidadeFatCliente vo = new UnidadeFatCliente();
        vo.setPessoa(p);
        vo.setUnidadeFatPadrao(Short.valueOf((short)1));
        vo.setUsarComoEnderecoEnt(Short.valueOf((short)0));
        return vo;
    }

    public UnidadeFatCliente criarUnidadeFatPadrao(Cliente c) {
        Pessoa p = c.getPessoa();
        UnidadeFatCliente vo = this.criarUnidadeFatPadrao(p);
        vo.setCategoriaPessoa(c.getFaturamento().getCategoriaPessoa());
        vo.setCliente(this.cliente);
        return vo;
    }

    public UnidadeFatCliente criarAddUnidadeFatPadrao(Cliente c) {
        Optional<UnidadeFatCliente> found = c.getUnidadeFatClientes().stream().filter(i -> ToolMethods.isEquals((Object)i.getPessoa(), (Object)c.getPessoa())).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        UnidadeFatCliente vo = this.criarUnidadeFatPadrao(c);
        c.getUnidadeFatClientes().add(vo);
        return vo;
    }

    public UnidadeFatCliente criarUnidadeFat(Cliente c) {
        Pessoa p = c.getPessoa();
        UnidadeFatCliente vo = new UnidadeFatCliente();
        vo.setUnidadeFatPadrao(Short.valueOf((short)0));
        Pessoa pu = new Pessoa();
        pu.setNome(p.getNome());
        pu.setDataInicioRelacionamento(new Date());
        pu.setTipoPessoa(Short.valueOf(EnumConstTipoPessoa.PESSOA_SECUNDARIA.value));
        vo.setPessoa(pu);
        Endereco end = new Endereco();
        pu.setEndereco(end);
        Complemento comp = new Complemento();
        comp.setCnpj(p.getComplemento().getCnpj());
        pu.setComplemento(comp);
        vo.setCategoriaPessoa(c.getFaturamento().getCategoriaPessoa());
        vo.setCliente(this.cliente);
        return vo;
    }
}

