/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.coleta;

import com.touchcomp.basementor.model.vo.AtivoDataUltimaManutencao;
import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.PlanoManutencaoAtivo;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperColeta
implements AbstractHelper<Coleta> {
    private Coleta coleta;

    public HelperColeta build(Coleta coleta) {
        this.coleta = coleta;
        return this;
    }

    public Coleta get() {
        return this.coleta;
    }

    public void calculaValorAcumulado(Coleta coleta) {
        if (coleta == null) {
            return;
        }
        Coleta coletaAnterior = coleta.getColetaAnterior();
        if (coletaAnterior == null) {
            coleta.setNumeroColeta(Long.valueOf(1L));
            return;
        }
        coleta.setValorAcumulado(Integer.valueOf(coleta.getValorColeta() - coletaAnterior.getValorColeta() + coletaAnterior.getValorAcumulado()));
        coleta.setNumeroColeta(Long.valueOf(coletaAnterior.getNumeroColeta() + 1L));
    }

    public void atualizaValorAcumulado(List<OrdemServico> osGeradas, List<PlanoManutencaoAtivo> planos, List<Coleta> coletas) {
        for (Coleta c : coletas) {
            for (PlanoManutencaoAtivo plano : planos) {
                for (AtivoDataUltimaManutencao ativo : plano.getAtivos()) {
                    for (OrdemServico os : osGeradas) {
                        for (PlanoManutencaoAtivo p : os.getPlanosManutencaoAtivo()) {
                            if (!c.getAtivo().equals((Object)os.getEquipamento()) || !plano.equals((Object)p) || !os.getEquipamento().equals((Object)ativo.getAtivo()) || !c.getTipoPontoControle().equals((Object)p.getTipoPontoControle())) continue;
                            ativo.setValorAcumulado(Integer.valueOf(0));
                            ativo.setNumeroColetaGerada(c.getNumeroColeta());
                        }
                    }
                }
            }
        }
    }
}

