/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.coleta;

import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.LogColeta;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.Date;
import org.springframework.stereotype.Component;

@Component
public class HelperLogColeta
implements AbstractHelper<LogColeta> {
    private LogColeta logColeta;

    public LogColeta get() {
        return this.logColeta;
    }

    public HelperLogColeta build(LogColeta data) {
        this.logColeta = data;
        return this;
    }

    public LogColeta build(Coleta coleta) {
        if (this.logColeta == null) {
            this.logColeta = new LogColeta();
        }
        if (coleta.getAtivo() != null) {
            this.logColeta.setAtivo(coleta.getAtivo().getCodigo() + "-" + coleta.getAtivo().getNome());
            this.logColeta.setAtivoIdentificador(coleta.getAtivo().getIdentificador());
        }
        if (coleta.getNumeroColeta() != null) {
            this.logColeta.setColeta(coleta.getNumeroColeta().toString());
        }
        if (coleta.getColetaAnterior() != null) {
            this.logColeta.setColetaAnterior(coleta.getColetaAnterior().getNumeroColeta().toString());
        }
        if (coleta.getColetaPosterior() != null) {
            this.logColeta.setColetaPosterior(coleta.getColetaPosterior().getNumeroColeta().toString());
        }
        if (coleta.getTipoPontoControle() != null) {
            this.logColeta.setTipoPontoControle(coleta.getTipoPontoControle().getDescricao());
        }
        this.logColeta.setDataCadastro(new Date());
        this.logColeta.setDataHoraColeta((Date)coleta.getDataHoraColeta());
        this.logColeta.setEmpresa(coleta.getEmpresa());
        this.logColeta.setValorAcumulado(coleta.getValorAcumulado());
        this.logColeta.setValorColeta(coleta.getValorColeta());
        return this.logColeta;
    }
}

