/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.comunicadoproducao;

import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.FichaTecItemComProducao;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.ValorFichaTecItemComProducao;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import java.util.LinkedList;
import org.springframework.stereotype.Component;

@Component
public class HelperComunicadoProducao
implements AbstractHelper<ComunicadoProducao> {
    private ComunicadoProducao comunicadoProducao;

    public HelperComunicadoProducao build(ComunicadoProducao comunicado) {
        this.comunicadoProducao = comunicado;
        return this;
    }

    public ComunicadoProducao get() {
        return this.comunicadoProducao;
    }

    public void beforeSave(ComunicadoProducao c) {
        for (ItemComunicadoProducao i : c.getItemComunicadoProducao()) {
            i.setComunicadoProducao(c);
            if (i.getGradeItemComunicadoProducao() == null) {
                i.setGradeItemComunicadoProducao(new LinkedList());
            }
            for (GradeItemComunicadoProducao g : i.getGradeItemComunicadoProducao()) {
                g.setItemComunicadoProducao(i);
                g.setDataMovimentacao(c.getDataEntradaSaida());
                g.setEmpresa(c.getEmpresa());
            }
            if (i.getFichasTecnicas() == null) {
                i.setFichasTecnicas(new LinkedList());
            }
            for (FichaTecItemComProducao fichaTecnica : i.getFichasTecnicas()) {
                fichaTecnica.setItemComunicadoProducao(i);
                for (ValorFichaTecItemComProducao itemFichaTecnica : fichaTecnica.getValoresFichaTec()) {
                    itemFichaTecnica.setFichaTecItemComProd(fichaTecnica);
                }
            }
            if (i.getItemComposicaoCusto() == null) {
                i.setItemComposicaoCusto(new LinkedList());
            }
            for (ItemComposicaoCusto itemComposicaoCusto : i.getItemComposicaoCusto()) {
                itemComposicaoCusto.setItemComProducao(i);
            }
            if (i.getItemEmbProduzidas() == null) {
                i.setItemEmbProduzidas(new LinkedList());
            }
            for (ItemEmbalagemProducao itemEmbProduzida : i.getItemEmbProduzidas()) {
                itemEmbProduzida.setItemComProducao(i);
            }
            if (i.getItemEventoOsProdSobEnc() == null) {
                i.setItemEventoOsProdSobEnc(new LinkedList());
            }
            for (ItemEventoOsProdSobEnc itemEventoOsProdSobEnc : i.getItemEventoOsProdSobEnc()) {
                itemEventoOsProdSobEnc.setItemComunicadoProducao(i);
            }
            if (i.getItensOutrosCustos() == null) {
                i.setItensOutrosCustos(new LinkedList());
            }
            for (ItemComProdOutrosCustos itensOutrosCusto : i.getItensOutrosCustos()) {
                itensOutrosCusto.setItemComunicadoProducao(i);
            }
            if (i.getRequisicoes() == null) {
                i.setRequisicoes(new LinkedList());
            }
            for (Requisicao requisicoe : i.getRequisicoes()) {
                requisicoe.setItemComunicadoProducao(i);
            }
        }
    }
}

