/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.comunicadoproducao;

import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemRequisicao;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperItemComunicadoProducao
implements AbstractHelper<ItemComunicadoProducao> {
    private ItemComunicadoProducao itemComunicado;

    public HelperItemComunicadoProducao build(ItemComunicadoProducao comunicado) {
        this.itemComunicado = comunicado;
        return this;
    }

    public ItemComunicadoProducao get() {
        return this.itemComunicado;
    }

    public void calcularTotais(List<ItemComunicadoProducao> itens) {
        for (ItemComunicadoProducao item : itens) {
            this.calcularTotais(item);
        }
    }

    public void calcularTotais(ItemComunicadoProducao itemComunicadoProducao) {
        if (ToolMethods.isNotNull((Object)itemComunicadoProducao).booleanValue()) {
            double pesoBruto = 0.0;
            double pesoLiquido = 0.0;
            double quantidadeTotal = 0.0;
            double quantidadeTotalRef = 0.0;
            for (GradeItemComunicadoProducao grade : itemComunicadoProducao.getGradeItemComunicadoProducao()) {
                quantidadeTotal += grade.getQuantidade().doubleValue();
                quantidadeTotalRef += grade.getQuantidadeReferencia().doubleValue();
                pesoBruto += grade.getQuantidade() * (itemComunicadoProducao.getProduto().getPesoUnitario() + itemComunicadoProducao.getProduto().getPesoEmbalagem());
                pesoLiquido += grade.getQuantidade() * itemComunicadoProducao.getProduto().getPesoUnitario();
            }
            itemComunicadoProducao.setQuantidadeTotalRef(Double.valueOf(quantidadeTotalRef));
            itemComunicadoProducao.setQuantidadeTotal(Double.valueOf(quantidadeTotal));
            itemComunicadoProducao.setPesoBruto(Double.valueOf(pesoBruto));
            itemComunicadoProducao.setPesoLiquido(Double.valueOf(pesoLiquido));
            double pesoBrutoMatReq = 0.0;
            double pesoLiquidoMatReq = 0.0;
            for (Requisicao req : itemComunicadoProducao.getRequisicoes()) {
                for (ItemRequisicao itemRequisicao : req.getItensRequisicao()) {
                    pesoBrutoMatReq += itemRequisicao.getQuantidadeTotal() * (itemRequisicao.getProduto().getPesoUnitario() + itemRequisicao.getProduto().getPesoEmbalagem());
                    pesoLiquidoMatReq += itemRequisicao.getQuantidadeTotal() * itemRequisicao.getProduto().getPesoUnitario();
                }
            }
            itemComunicadoProducao.setPesoBrutoMatReq(Double.valueOf(pesoBrutoMatReq));
            itemComunicadoProducao.setPesoLiquidoMatReq(Double.valueOf(pesoLiquidoMatReq));
        }
    }
}

