/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.condicoespagamento;

import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.calculos.ToolCalculos;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class HelperCondicoesPagamento
implements AbstractHelper<CondicoesPagamento> {
    private CondicoesPagamento condicoesPagamento;

    public CondicoesPagamento get() {
        return this.condicoesPagamento;
    }

    public HelperCondicoesPagamento build(CondicoesPagamento object) {
        this.condicoesPagamento = object;
        return this;
    }

    public int calcularNrDiasMedios(CondicoesPagamento cond, String parcelas) {
        if (cond == null) {
            return 0;
        }
        return this.calcularNrDiasMedios(EnumConstantsSimNao.get((Object)cond.getCondMutante()), EnumConstantsSimNao.get((Object)cond.getEntrada()), cond.getNumeroParcelas(), cond.getNumeroDiasVencimento(), cond.getParcelasMutante(), parcelas);
    }

    public boolean validaNrDiasMedios(CondicoesPagamento cp, String parcelas) {
        if (cp == null || cp.getCondMutante() == null || cp.getCondMutante() == 0) {
            return true;
        }
        int nrDias = this.calcularNrDiasMedios(cp, parcelas);
        if (nrDias > cp.getNrMaximoDiasMedios()) {
            return false;
        }
        return parcelas.endsWith(";");
    }

    public int calcularNrDiasMedios(EnumConstantsSimNao condMutante, EnumConstantsSimNao possuiEntrada, Integer numeroParcelas, Integer diasEntreVencimentos, String parcelasMutanteCondPag, String parcelasMutante) {
        if (numeroParcelas == null) {
            numeroParcelas = 1;
        }
        if (diasEntreVencimentos == null) {
            diasEntreVencimentos = 0;
        }
        if (TMethods.isAffirmative((Number)condMutante.getValue())) {
            if (!TMethods.isStrWithData((String)parcelasMutante)) {
                parcelasMutante = parcelasMutanteCondPag;
            }
            return ToolCalculos.calcularNrDiasMediosCondPag((String)parcelasMutante);
        }
        return ToolCalculos.calcularNrDiasMediosCondPag((EnumConstantsSimNao)possuiEntrada, (int)numeroParcelas, (int)diasEntreVencimentos);
    }

    public Double calcularValorTotalMajorado(Double valorTotalNota, CondicoesPagamento condicoesPagamento, String parcelasMut) {
        if (condicoesPagamento == null) {
            return valorTotalNota;
        }
        if (condicoesPagamento.getMajoracaoPreco() == null || condicoesPagamento.getMajoracaoPreco() <= 0.0) {
            return valorTotalNota;
        }
        if (condicoesPagamento.getCondMutante() != null && condicoesPagamento.getCondMutante() == 1) {
            if (condicoesPagamento.getMutanteFixa() != null && condicoesPagamento.getMutanteFixa() == 1) {
                parcelasMut = condicoesPagamento.getParcelasMutante();
            }
            int nrDiasMedios = this.calcularNrDiasMedios(condicoesPagamento, parcelasMut);
            double vlrMajorado = valorTotalNota * (condicoesPagamento.getMajoracaoPreco() / 100.0) / 30.0 * (double)nrDiasMedios;
            return vlrMajorado + valorTotalNota;
        }
        int numParc = condicoesPagamento.getNumeroParcelas();
        if (condicoesPagamento.getEntrada() != null && condicoesPagamento.getEntrada() == 1) {
            --numParc;
        }
        if (numParc > 0) {
            int prazo = 0;
            for (int i = 1; i <= numParc; ++i) {
                prazo += i * condicoesPagamento.getNumeroDiasVencimento();
            }
            double percReaj = condicoesPagamento.getMajoracaoPreco() / 30.0 * (double)(prazo / numParc);
            valorTotalNota = valorTotalNota + percReaj / 100.0 * valorTotalNota;
        }
        return valorTotalNota;
    }

    public List<Integer> getParcelas(String text) {
        ArrayList<Integer> parc = new ArrayList<Integer>();
        int lastParc = 0;
        if (text == null || text.trim().length() == 0) {
            return parc;
        }
        do {
            int index;
            if ((index = text.indexOf(";")) <= -1) continue;
            parc.add(Integer.valueOf(text.substring(lastParc, index).trim()));
            lastParc = index + 1;
            text = text.substring(lastParc);
            lastParc = 0;
        } while (text.contains(";"));
        return parc;
    }

    public Double calcularValorComissaoMinorado(CondicoesPagamento condicoesPagamento, Double percComissaoItPed, String parcelas) {
        Double percComissao = percComissaoItPed;
        if (condicoesPagamento == null || condicoesPagamento.getMinoracaoComissao() == null || condicoesPagamento.getMinoracaoComissao() <= 0.0) {
            return percComissao;
        }
        if (TMethods.isAffirmative((Number)condicoesPagamento.getCondMutante())) {
            Integer nrDiasMedios = this.calcularNrDiasMedios(condicoesPagamento, parcelas);
            Double percComissaoMinorado = percComissaoItPed * condicoesPagamento.getMinoracaoComissao() / 30.0 * ((double)nrDiasMedios.intValue() / 100.0);
            percComissao = percComissao - percComissaoMinorado;
        } else {
            Integer numParc = condicoesPagamento.getNumeroParcelas();
            if (TMethods.isAffirmative((Number)condicoesPagamento.getEntrada())) {
                Integer percComissaoMinorado = numParc;
                numParc = numParc - 1;
            }
            if (numParc > 0) {
                Integer prazo = 0;
                for (int i = 1; i <= numParc; ++i) {
                    prazo = prazo + i * condicoesPagamento.getNumeroDiasVencimento();
                }
                Double percReaj = condicoesPagamento.getMinoracaoComissao() / 30.0 * (double)(prazo / numParc);
                if ((percComissao = Double.valueOf(percComissao - percComissao * (percReaj / 100.0))) < 0.0) {
                    percComissao = 0.0;
                }
            }
        }
        return percComissao;
    }
}

