/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.configservicos;

import com.touchcomp.basementor.model.vo.ConfigServicos;
import com.touchcomp.basementor.model.vo.ConfigServicosItem;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class HelperConfigServicos
implements AbstractHelper<ConfigServicos> {
    private ConfigServicos config;

    public ConfigServicosItem getItem(String key) {
        if (this.config == null) {
            return null;
        }
        Optional<ConfigServicosItem> found = this.config.getItensConfig().stream().filter(i -> ToolMethods.isEquals((Object)i.getItem(), (Object)key)).findFirst();
        if (!found.isPresent()) {
            return null;
        }
        return found.get();
    }

    public String getValue(String key) {
        ConfigServicosItem item = this.getItem(key);
        if (item == null) {
            return null;
        }
        return item.getValor();
    }

    public boolean getValueAsBoolean(String key) {
        String value = this.getValue(key);
        if (!ToolMethods.isStrWithData((String)(value = ToolString.onlyNumbers((String)value)))) {
            return false;
        }
        return ToolMethods.isAffirmative((Number)Long.valueOf(value));
    }

    public double getValueAsDouble(String key) {
        String value = this.getValue(key);
        if (!ToolMethods.isStrWithData((String)(value = ToolString.trim((String)value)))) {
            return 0.0;
        }
        return Double.parseDouble(value);
    }

    public long getValueAsLong(String key) {
        String value = this.getValue(key);
        if (!ToolMethods.isStrWithData((String)(value = ToolString.trim((String)value)))) {
            return 0L;
        }
        return Long.parseLong(value);
    }

    public int getValueAsInt(String key) {
        String value = this.getValue(key);
        if (!ToolMethods.isStrWithData((String)(value = ToolString.trim((String)value)))) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    public ConfigServicos get() {
        return this.config;
    }

    public HelperConfigServicos build(ConfigServicos data) {
        this.config = data;
        return this;
    }

    public void setValue(String key, String valor) {
        ConfigServicosItem item = this.getItem(key);
        if (item == null) {
            return;
        }
        item.setValor(valor);
    }
}

