/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.consumoativo;

import com.touchcomp.basementor.constants.enums.opcoesmanutencaoativos.EnumConstTipoMovimentoConsumo;
import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementorexceptions.exceptions.impl.parametrizacaoctbrequisicao.ExceptionParamCtbRequisicao;
import com.touchcomp.basementorservice.helpers.AbstractHelper;
import com.touchcomp.basementorservice.helpers.impl.requisicao.HelperRequisicao;
import com.touchcomp.basementorservice.service.impl.consumoativo.ServiceConsumoAtivoImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelperConsumoAtivo
implements AbstractHelper<ConsumoAtivo> {
    private ConsumoAtivo consumoAtivo;
    private ServiceConsumoAtivoImpl serviceConsumoAtivo;
    private HelperRequisicao helperRequisicao;

    public ConsumoAtivo get() {
        return this.consumoAtivo;
    }

    @Autowired
    public HelperConsumoAtivo(ServiceConsumoAtivoImpl serviceConsumoAtivo, HelperRequisicao helperRequisicao) {
        this.serviceConsumoAtivo = serviceConsumoAtivo;
        this.helperRequisicao = helperRequisicao;
    }

    public HelperConsumoAtivo build(ConsumoAtivo consumoAtivo) {
        this.consumoAtivo = consumoAtivo;
        return this;
    }

    public ConsumoAtivo onSave(ConsumoAtivo obj) throws ExceptionParamCtbRequisicao {
        obj.setRequisicao(this.helperRequisicao.gerarRequisicaoConsumoAtivo(obj));
        return this.serviceConsumoAtivo.saveOrUpdate(obj);
    }

    public EnumConstTipoMovimentoConsumo getTipoConsumoIntExterno(Empresa empresa, UnidadeFatFornecedor unidadeFatFornecedor) {
        if (ToolMethods.isEquals((Object)empresa.getPessoa().getComplemento().getCnpj(), (Object)unidadeFatFornecedor.getPessoa().getComplemento().getCnpj())) {
            return EnumConstTipoMovimentoConsumo.CONSUMO_INTERNO;
        }
        return EnumConstTipoMovimentoConsumo.CONSUMO_EXTERNO;
    }
}

