/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.helpers.impl.cotacaocompra;

import com.touchcomp.basementor.constants.enums.cotacaoCompra.EnumConstPrecoItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FornecedorItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.ItemCotacaoCompra;
import com.touchcomp.basementor.model.vo.OpcoesCompraSuprimentos;
import com.touchcomp.basementorservice.helpers.impl.condicoespagamento.HelperCondicoesPagamento;
import com.touchcomp.basementorservice.helpers.impl.cotacaocompra.GenMapFornecedorCotacao;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.DTOLeadTimeSimples;
import com.touchcomp.basementorservice.service.impl.leadtimefornecedor.ServiceLeadTimeFornProdutoImpl;
import com.touchcomp.basementortools.constants.EnumConstantsSimNao;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class AuxSelecionaMelhorFornecedor {
    final ServiceLeadTimeFornProdutoImpl serviceLeadTimeFornProdutoImpl;
    final OpcoesCompraSuprimentos opcoesCompraSuprimentos;
    final HelperCondicoesPagamento helperCondicoesPagamento;

    public AuxSelecionaMelhorFornecedor(ServiceLeadTimeFornProdutoImpl serviceLeadTimeFornProdutoImpl, OpcoesCompraSuprimentos opcoesCompraSuprimentos, HelperCondicoesPagamento helperCondicoesPagamento) {
        this.serviceLeadTimeFornProdutoImpl = serviceLeadTimeFornProdutoImpl;
        this.opcoesCompraSuprimentos = opcoesCompraSuprimentos;
        this.helperCondicoesPagamento = helperCondicoesPagamento;
    }

    void selectBestFornecedor(CotacaoCompra cotacao) {
        for (ItemCotacaoCompra item : cotacao.getItensCotacaoCompra()) {
            this.selectBestFornecedor(item, cotacao.getEmpresa());
        }
    }

    FornecedorItemCotacaoCompra selectBestFornecedor(ItemCotacaoCompra itemCotacaoCompra, Empresa empresa) {
        itemCotacaoCompra.getFornecedoresItemCotacaoCompra().forEach(i -> i.setSelecionado(Short.valueOf((short)0)));
        GenericMapValues<GenMapFornecedorCotacao> best = null;
        for (FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra : itemCotacaoCompra.getFornecedoresItemCotacaoCompra()) {
            if (!ToolMethods.isEquals((Object)fornecedorItemCotacaoCompra.getValidado(), (Object)EnumConstantsSimNao.SIM.getValue())) continue;
            GenericMapValues<GenMapFornecedorCotacao> forn = this.converterFornecedor(fornecedorItemCotacaoCompra, itemCotacaoCompra, empresa);
            best = this.selectionaBestFornecedor(best, forn, null);
        }
        if (best != null) {
            best.getObject(GenMapFornecedorCotacao.OBJETO_ORIGEM, FornecedorItemCotacaoCompra.class).setSelecionado(Short.valueOf((short)1));
            return best.getObject(GenMapFornecedorCotacao.OBJETO_ORIGEM, FornecedorItemCotacaoCompra.class);
        }
        return null;
    }

    GenericMapValues<GenMapFornecedorCotacao> selectBestFornecedor(List<GenericMapValues<GenMapFornecedorCotacao>> fornecedoresItem, Empresa empresa) {
        return this.selectBestFornecedor(fornecedoresItem, empresa, false, null);
    }

    GenericMapValues<GenMapFornecedorCotacao> selectBestFornecedor(List<GenericMapValues<GenMapFornecedorCotacao>> fornecedoresItem, Empresa empresa, boolean rankear, List<DTOLeadTimeSimples> leadsTime) {
        for (GenericMapValues<GenMapFornecedorCotacao> fornitem : fornecedoresItem) {
            FornecedorItemCotacaoCompra o = fornitem.getObject(GenMapFornecedorCotacao.OBJETO_ORIGEM, FornecedorItemCotacaoCompra.class);
            if (o instanceof FornecedorItemCotacaoCompra) {
                o.setSelecionado(Short.valueOf((short)0));
            }
            if (!(o instanceof Map)) continue;
            ((Map)o).put(GenMapFornecedorCotacao.SELECIONADO, (short)0);
            ((Map)o).put(GenMapFornecedorCotacao.RANKING, 0);
        }
        GenericMapValues<GenMapFornecedorCotacao> best = this.getBestFornecedor(fornecedoresItem, leadsTime);
        if (rankear) {
            this.rankearFornecedores(fornecedoresItem, leadsTime);
        }
        if (best != null) {
            FornecedorItemCotacaoCompra o = best.getObject(GenMapFornecedorCotacao.OBJETO_ORIGEM, FornecedorItemCotacaoCompra.class);
            if (o instanceof FornecedorItemCotacaoCompra) {
                o.setSelecionado(Short.valueOf((short)0));
            }
            if (o instanceof Map) {
                ((Map)o).put(GenMapFornecedorCotacao.SELECIONADO, (short)0);
            }
        }
        return best;
    }

    private void rankearFornecedores(List<GenericMapValues<GenMapFornecedorCotacao>> fornecedoresItem, List<DTOLeadTimeSimples> leadsTime) {
        LinkedList<GenericMapValues<GenMapFornecedorCotacao>> aux = new LinkedList<GenericMapValues<GenMapFornecedorCotacao>>(fornecedoresItem);
        int ranking = 1;
        GenericMapValues<GenMapFornecedorCotacao> best = null;
        do {
            if ((best = this.getBestFornecedor(aux, leadsTime)) == null) continue;
            FornecedorItemCotacaoCompra o = best.getObject(GenMapFornecedorCotacao.OBJETO_ORIGEM, FornecedorItemCotacaoCompra.class);
            if (o instanceof Map) {
                ((Map)o).put(GenMapFornecedorCotacao.RANKING.getValue(), ranking);
            }
            aux.remove(best);
            ++ranking;
        } while (!aux.isEmpty() && best != null);
    }

    private GenericMapValues<GenMapFornecedorCotacao> getBestFornecedor(List<GenericMapValues<GenMapFornecedorCotacao>> fornecedoresItem, List<DTOLeadTimeSimples> leadsTime) {
        GenericMapValues<GenMapFornecedorCotacao> best = null;
        for (GenericMapValues<GenMapFornecedorCotacao> fornecedorItemCotacaoCompra : fornecedoresItem) {
            best = this.selectionaBestFornecedor(best, fornecedorItemCotacaoCompra, leadsTime);
        }
        return best;
    }

    public GenericMapValues<GenMapFornecedorCotacao> selectionaBestFornecedor(GenericMapValues<GenMapFornecedorCotacao> bestFornecedor, GenericMapValues<GenMapFornecedorCotacao> fornAvaliar, List<DTOLeadTimeSimples> leadsTime) {
        Long idEmpresa;
        Long idGradeCor;
        if (bestFornecedor != null && TMethods.isAffirmative((Number)bestFornecedor.getShort(GenMapFornecedorCotacao.AQUISICAO_PREFERENCIAL))) {
            return bestFornecedor;
        }
        if (TMethods.isAffirmative((Number)fornAvaliar.getShort(GenMapFornecedorCotacao.AQUISICAO_PREFERENCIAL))) {
            return fornAvaliar;
        }
        Long idUnidadeForn = fornAvaliar.getLong(GenMapFornecedorCotacao.ID_UNIDADE_FAT_FORN);
        if (this.isAquisicaoPreferencial(idUnidadeForn, idGradeCor = fornAvaliar.getLong(GenMapFornecedorCotacao.ID_GRADE_COR), idEmpresa = fornAvaliar.getLong(GenMapFornecedorCotacao.ID_EMPRESA), leadsTime)) {
            fornAvaliar.putShort(GenMapFornecedorCotacao.AQUISICAO_PREFERENCIAL, (short)1);
            return fornAvaliar;
        }
        if (bestFornecedor == null) {
            return fornAvaliar;
        }
        Double valorBest = bestFornecedor.getDouble(GenMapFornecedorCotacao.VALOR_CUSTO);
        Double valorForn = fornAvaliar.getDouble(GenMapFornecedorCotacao.VALOR_CUSTO);
        if (ToolMethods.isEquals((Object)this.opcoesCompraSuprimentos.getPrecoCotacao(), (Object)EnumConstPrecoItemCotacaoCompra.VALOR_UNITARIO.getValue())) {
            valorBest = bestFornecedor.getDouble(GenMapFornecedorCotacao.VALOR_UNITARIO);
            valorForn = fornAvaliar.getDouble(GenMapFornecedorCotacao.VALOR_UNITARIO);
        }
        bestFornecedor = this.avaliarValoresMenor(bestFornecedor, fornAvaliar, valorBest, valorForn);
        if (valorBest.doubleValue() != valorForn.doubleValue()) {
            return bestFornecedor;
        }
        int prazoBest = this.getPrazoPagamento(bestFornecedor);
        int prazoForn = this.getPrazoPagamento(fornAvaliar);
        bestFornecedor = this.avaliarValoresMaior(bestFornecedor, fornAvaliar, prazoBest, prazoForn);
        if (prazoBest != prazoForn) {
            return bestFornecedor;
        }
        long prazoEntBest = bestFornecedor.getLong(GenMapFornecedorCotacao.PRAZO_ENTREGA_FORNECEDOR);
        long prazoEntForn = fornAvaliar.getLong(GenMapFornecedorCotacao.PRAZO_ENTREGA_FORNECEDOR);
        bestFornecedor = this.avaliarValoresMenor(bestFornecedor, fornAvaliar, prazoEntBest, prazoEntForn);
        if (prazoEntBest != prazoEntForn) {
            return bestFornecedor;
        }
        if (bestFornecedor.getDate(GenMapFornecedorCotacao.DATA_PREV_FATURAMENTO) != null && fornAvaliar.getDate(GenMapFornecedorCotacao.DATA_PREV_FATURAMENTO) != null) {
            long prazoEntregaBest = bestFornecedor.getDate(GenMapFornecedorCotacao.DATA_PREV_FATURAMENTO).getTime();
            long prazoEntregaForn = fornAvaliar.getDate(GenMapFornecedorCotacao.DATA_PREV_FATURAMENTO).getTime();
            bestFornecedor = this.avaliarValoresMenor(bestFornecedor, fornAvaliar, prazoEntregaBest, prazoEntregaForn);
        }
        return bestFornecedor;
    }

    private Integer getPrazoPagamento(GenericMapValues<GenMapFornecedorCotacao> forn) {
        EnumConstantsSimNao condMutante = EnumConstantsSimNao.get((Object)forn.getShort(GenMapFornecedorCotacao.COND_PAG_MUTANTE));
        EnumConstantsSimNao possuiEntrada = EnumConstantsSimNao.get((Object)forn.getInteger(GenMapFornecedorCotacao.COND_PAG_POSSUI_ENTRADA));
        Integer numeroParcelas = forn.getInteger(GenMapFornecedorCotacao.COND_PAG_NUMERO_PARCELAS);
        Integer diasEntreVencimentos = forn.getInteger(GenMapFornecedorCotacao.COND_PAG_DIAS_ENTRE_VENCIMENTO);
        String parcelasMutCond = forn.getString(GenMapFornecedorCotacao.COND_PAG_PARCELAS_MUTANTE_CP);
        String parcelasMut = forn.getString(GenMapFornecedorCotacao.COND_PAG_PARCELAS_MUTANTE_INF);
        return this.helperCondicoesPagamento.calcularNrDiasMedios(condMutante, possuiEntrada, numeroParcelas, diasEntreVencimentos, parcelasMutCond, parcelasMut);
    }

    private boolean isAquisicaoPreferencial(Long idUnidadeFatForn, Long idGradeCor, Long idEmpresa, List<DTOLeadTimeSimples> leadsTime) {
        if (leadsTime != null) {
            Optional<DTOLeadTimeSimples> found = leadsTime.stream().filter(i -> TMethods.isEquals((Object)i.getIdEmpresa(), (Object)idEmpresa) && TMethods.isEquals((Object)i.getIdGradeCor(), (Object)idGradeCor) && TMethods.isEquals((Object)i.getIdUnidadeFatFornecedor(), (Object)idUnidadeFatForn)).findFirst();
            return found.isPresent() && TMethods.isAffirmative((Number)found.get().getAquisicaoPreferencial());
        }
        return this.serviceLeadTimeFornProdutoImpl.isAquisicaoPreferencial(idUnidadeFatForn, idGradeCor, idEmpresa);
    }

    private boolean isPrazoDeEntregaCompativel(Date dataMaximaEntrega, Long prazoEntregaForn) {
        if (dataMaximaEntrega == null) {
            return false;
        }
        int diasDif = TDate.diferenceDayBetweenDates((Date)dataMaximaEntrega, (Date)new Date());
        if (diasDif < 0) {
            return false;
        }
        return (long)diasDif < prazoEntregaForn;
    }

    private GenericMapValues<GenMapFornecedorCotacao> avaliarValoresMenor(GenericMapValues<GenMapFornecedorCotacao> bestFornecedor, GenericMapValues<GenMapFornecedorCotacao> fornAvaliar, Number valorBest, Number valorForn) {
        if (!TMethods.isWithData((Number)valorForn)) {
            return bestFornecedor;
        }
        if (valorForn.doubleValue() < valorBest.doubleValue()) {
            return fornAvaliar;
        }
        return bestFornecedor;
    }

    private GenericMapValues<GenMapFornecedorCotacao> avaliarValoresMaior(GenericMapValues<GenMapFornecedorCotacao> bestFornecedor, GenericMapValues<GenMapFornecedorCotacao> fornAvaliar, Number prazoBest, Number prazoForn) {
        if (!TMethods.isWithData((Number)prazoForn)) {
            return bestFornecedor;
        }
        if (prazoBest.doubleValue() < prazoForn.doubleValue()) {
            return fornAvaliar;
        }
        return bestFornecedor;
    }

    protected GenericMapValues<GenMapFornecedorCotacao> converterFornecedor(FornecedorItemCotacaoCompra fornecedorItemCotacaoCompra, ItemCotacaoCompra itemCotacaoCompra, Empresa empresa) {
        GenericMapValues<GenMapFornecedorCotacao> forn = new GenericMapValues<GenMapFornecedorCotacao>();
        forn.putShort(GenMapFornecedorCotacao.AQUISICAO_PREFERENCIAL, fornecedorItemCotacaoCompra.getAquisicaoPreferencial());
        if (fornecedorItemCotacaoCompra.getCondicoesPagamento() != null) {
            forn.putInteger(GenMapFornecedorCotacao.COND_PAG_DIAS_ENTRE_VENCIMENTO, fornecedorItemCotacaoCompra.getCondicoesPagamento().getNumeroDiasVencimento());
            forn.putShort(GenMapFornecedorCotacao.COND_PAG_MUTANTE, fornecedorItemCotacaoCompra.getCondicoesPagamento().getCondMutante());
            forn.putInteger(GenMapFornecedorCotacao.COND_PAG_NUMERO_PARCELAS, fornecedorItemCotacaoCompra.getCondicoesPagamento().getNumeroParcelas());
            forn.putString(GenMapFornecedorCotacao.COND_PAG_PARCELAS_MUTANTE_CP, fornecedorItemCotacaoCompra.getCondicoesPagamento().getParcelasMutante());
            forn.putString(GenMapFornecedorCotacao.COND_PAG_PARCELAS_MUTANTE_INF, fornecedorItemCotacaoCompra.getCondicaoPagamentoMutante());
            forn.putInteger(GenMapFornecedorCotacao.COND_PAG_POSSUI_ENTRADA, fornecedorItemCotacaoCompra.getCondicoesPagamento().getEntrada());
        }
        forn.putDate(GenMapFornecedorCotacao.DATA_MAXIMA_ENTREGA, itemCotacaoCompra.getDataMaxEntrega());
        forn.putDate(GenMapFornecedorCotacao.DATA_PREV_FATURAMENTO, fornecedorItemCotacaoCompra.getDataPrevFaturamento());
        forn.putObject(GenMapFornecedorCotacao.OBJETO_ORIGEM, fornecedorItemCotacaoCompra);
        forn.putLong(GenMapFornecedorCotacao.ID_EMPRESA, empresa.getIdentificador());
        forn.putLong(GenMapFornecedorCotacao.ID_GRADE_COR, itemCotacaoCompra.getGradeCor().getIdentificador());
        forn.putLong(GenMapFornecedorCotacao.ID_UNIDADE_FAT_FORN, fornecedorItemCotacaoCompra.getUnidadeFaturamentoFornecedor().getIdentificador());
        forn.putLong(GenMapFornecedorCotacao.PRAZO_ENTREGA_FORNECEDOR, fornecedorItemCotacaoCompra.getPrazoEntrega());
        forn.putDouble(GenMapFornecedorCotacao.VALOR_CUSTO, fornecedorItemCotacaoCompra.getValorCusto());
        forn.putDouble(GenMapFornecedorCotacao.VALOR_UNITARIO, fornecedorItemCotacaoCompra.getValorUnitario());
        return forn;
    }
}

